/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.StandardTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSFrameSlot;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.DeclareTagProvider;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;

public abstract class JSFunctionExpressionNode
extends JavaScriptNode
implements FunctionNameHolder {
    protected final JSFunctionData functionData;

    protected JSFunctionExpressionNode(JSFunctionData functionData) {
        this.functionData = functionData;
    }

    public static JSFunctionExpressionNode create(JSFunctionData function) {
        assert (!function.needsParentFrame());
        return new AutonomousFunctionExpressionNode(function);
    }

    public static JSFunctionExpressionNode create(JSFunctionData function, JSFrameSlot blockScopeSlot) {
        if (function.needsParentFrame()) {
            return new ClosureFunctionExpressionNode(function, blockScopeSlot != null ? blockScopeSlot.getIndex() : -1);
        }
        return new AutonomousFunctionExpressionNode(function);
    }

    public static JSFunctionExpressionNode createLexicalThis(JSFunctionData function, JSFrameSlot blockScopeSlot, JavaScriptNode thisNode) {
        if (function.needsParentFrame()) {
            return new LexicalThisClosureFunctionExpressionNode(function, blockScopeSlot != null ? blockScopeSlot.getIndex() : -1, thisNode);
        }
        return new LexicalThisAutonomousFunctionExpressionNode(function, thisNode);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeWithRealm(frame, this.getRealm());
    }

    public abstract Object executeWithRealm(VirtualFrame var1, JSRealm var2);

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.LiteralTag.class) {
            return true;
        }
        if (tag == JSTags.InputNodeTag.class) {
            return true;
        }
        if (tag == JSTags.DeclareTag.class) {
            return !super.hasTag(StandardTags.ExpressionTag.class);
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        if (super.hasTag(StandardTags.ExpressionTag.class)) {
            return JSTags.createNodeObjectDescriptor("literalType", JSTags.LiteralTag.Type.FunctionLiteral.name());
        }
        NodeObjectDescriptor descriptor = DeclareTagProvider.createDeclareNodeObject(this.functionData.getName(), "var");
        descriptor.addProperty("literalType", JSTags.LiteralTag.Type.FunctionLiteral.name());
        return descriptor;
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (!materializedTags.isEmpty()) {
            this.functionData.materialize();
        }
        return this;
    }

    public final JSFunctionData getFunctionData() {
        return this.functionData;
    }

    @Override
    public TruffleString getFunctionName() {
        return this.functionData.getName();
    }

    @Override
    public void setFunctionName(TruffleString name) {
        CompilerAsserts.neverPartOfCompilation();
        this.functionData.setName(name);
    }

    private static final class AutonomousFunctionExpressionNode
    extends JSFunctionExpressionNode {
        protected AutonomousFunctionExpressionNode(JSFunctionData functionData) {
            super(functionData);
        }

        @Override
        public Object executeWithRealm(VirtualFrame frame, JSRealm realm) {
            return JSFunction.create(realm, this.functionData);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new AutonomousFunctionExpressionNode(this.functionData);
        }
    }

    private static final class ClosureFunctionExpressionNode
    extends JSFunctionExpressionNode {
        private final int blockScopeSlot;

        protected ClosureFunctionExpressionNode(JSFunctionData functionData, int blockScopeSlot) {
            super(functionData);
            this.blockScopeSlot = blockScopeSlot;
        }

        @Override
        public Object executeWithRealm(VirtualFrame frame, JSRealm realm) {
            MaterializedFrame closureFrame;
            if (this.blockScopeSlot >= 0) {
                Object blockScope = frame.getObject(this.blockScopeSlot);
                closureFrame = JSFrameUtil.castMaterializedFrame(blockScope);
            } else {
                closureFrame = frame.materialize();
            }
            return JSFunction.create(realm, this.functionData, closureFrame);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ClosureFunctionExpressionNode(this.functionData, this.blockScopeSlot);
        }
    }

    private static final class LexicalThisClosureFunctionExpressionNode
    extends JSFunctionExpressionNode {
        @Node.Child
        private JavaScriptNode thisNode;
        private final int blockScopeSlot;

        protected LexicalThisClosureFunctionExpressionNode(JSFunctionData functionData, int blockScopeSlot, JavaScriptNode thisNode) {
            super(functionData);
            this.blockScopeSlot = blockScopeSlot;
            this.thisNode = thisNode;
        }

        @Override
        public Object executeWithRealm(VirtualFrame frame, JSRealm realm) {
            MaterializedFrame closureFrame;
            if (this.blockScopeSlot >= 0) {
                Object blockScope = frame.getObject(this.blockScopeSlot);
                closureFrame = JSFrameUtil.castMaterializedFrame(blockScope);
            } else {
                closureFrame = frame.materialize();
            }
            return JSFunction.createLexicalThis(realm, this.functionData, closureFrame, this.thisNode.execute(frame));
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new LexicalThisClosureFunctionExpressionNode(this.functionData, this.blockScopeSlot, LexicalThisClosureFunctionExpressionNode.cloneUninitialized(this.thisNode, materializedTags));
        }
    }

    private static final class LexicalThisAutonomousFunctionExpressionNode
    extends JSFunctionExpressionNode {
        @Node.Child
        private JavaScriptNode thisNode;

        protected LexicalThisAutonomousFunctionExpressionNode(JSFunctionData functionData, JavaScriptNode thisNode) {
            super(functionData);
            this.thisNode = thisNode;
        }

        @Override
        public Object executeWithRealm(VirtualFrame frame, JSRealm realm) {
            return JSFunction.createLexicalThis(realm, this.functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, this.thisNode.execute(frame));
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new LexicalThisAutonomousFunctionExpressionNode(this.functionData, LexicalThisAutonomousFunctionExpressionNode.cloneUninitialized(this.thisNode, materializedTags));
        }
    }
}

