/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Executed;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.IndirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSFrameSlot;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.ScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.AbstractFunctionRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.EvalNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionArgumentsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSError;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class EvalNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    @Executed
    protected JavaScriptNode functionNode;
    @Node.Child
    protected AbstractFunctionArgumentsNode arguments;
    @Node.Child
    protected DirectEvalNode directEvalNode;

    protected EvalNode(JSContext context, JavaScriptNode function, JavaScriptNode[] args, JavaScriptNode thisObject, Object env, int blockScopeSlot) {
        this(context, function, JSFunctionArgumentsNode.create(context, args), DirectEvalNode.create(context, thisObject, env, blockScopeSlot));
    }

    protected EvalNode(JSContext context, JavaScriptNode functionNode, AbstractFunctionArgumentsNode arguments, DirectEvalNode directEvalNode) {
        this.context = context;
        this.functionNode = functionNode;
        this.arguments = arguments;
        this.directEvalNode = directEvalNode;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.EvalCallTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Specialization(guards={"!isEvalOverridden(evalFunction)"})
    protected Object evalNotOverridden(VirtualFrame frame, Object evalFunction) {
        int argCount = this.arguments.getCount(frame);
        Object[] args = new Object[argCount];
        JSDynamicObject source = (args = this.arguments.executeFillObjectArray(frame, args, 0)).length == 0 ? Undefined.instance : args[0];
        return this.directEvalNode.executeWithSource(frame, source);
    }

    @Specialization(guards={"isEvalOverridden(evalFunction)"})
    protected Object evalOverridden(VirtualFrame frame, Object evalFunction, @Cached(value="createCall()") JSFunctionCallNode redirectCall) {
        int argCount = this.arguments.getCount(frame);
        Object[] args = JSArguments.createInitial(Undefined.instance, evalFunction, argCount);
        args = this.arguments.executeFillObjectArray(frame, args, 2);
        return redirectCall.executeCall(args);
    }

    protected final boolean isEvalOverridden(Object function) {
        return function != this.getRealm().getEvalFunctionObject();
    }

    public static EvalNode create(JSContext context, JavaScriptNode functionNode, JavaScriptNode[] args, JavaScriptNode thisObject, Object env, JSFrameSlot blockScopeSlot) {
        return EvalNodeGen.create(context, functionNode, args, thisObject, env, blockScopeSlot != null ? blockScopeSlot.getIndex() : -1);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatEvalOrigin(Node callNode, JSContext context, String defaultName) {
        if (callNode == null || !context.isOptionV8CompatibilityMode()) {
            return defaultName;
        }
        SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
        if (sourceSection == null) {
            return defaultName;
        }
        String sourceName = sourceSection.getSource().getName();
        String callerName = callNode.getRootNode().getName();
        if (callerName == null || callerName.startsWith(":")) {
            callerName = Strings.toJavaString(JSError.getAnonymousFunctionNameStackTrace(context));
        }
        if (sourceName.startsWith("eval at ")) {
            return "eval at " + callerName + " (" + sourceName + ")";
        }
        return "eval at " + callerName + " (" + sourceName + ":" + sourceSection.getStartLine() + ":" + sourceSection.getStartColumn() + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public static Node findCallNode(JSRealm realm) {
        JavaScriptBaseNode caller = realm.getCallNode();
        if (EvalNode.isValidCallNode(caller)) {
            return caller;
        }
        return Truffle.getRuntime().iterateFrames(frameInstance -> {
            Node callNode = frameInstance.getCallNode();
            if (EvalNode.isValidCallNode(callNode)) {
                return callNode;
            }
            return null;
        });
    }

    private static boolean isValidCallNode(Node callNode) {
        AbstractFunctionRootNode functionRoot;
        RootNode rootNode;
        return callNode != null && (rootNode = callNode.getRootNode()) instanceof AbstractFunctionRootNode && (functionRoot = (AbstractFunctionRootNode)rootNode).getActiveScriptOrModule() != null;
    }

    @CompilerDirectives.TruffleBoundary
    public static ScriptOrModule findActiveScriptOrModule(Node callNode) {
        RootNode rootNode;
        if (callNode != null && (rootNode = callNode.getRootNode()) instanceof AbstractFunctionRootNode) {
            AbstractFunctionRootNode functionRoot = (AbstractFunctionRootNode)rootNode;
            return functionRoot.getActiveScriptOrModule();
        }
        return null;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return EvalNodeGen.create(this.context, EvalNode.cloneUninitialized(this.functionNode, materializedTags), AbstractFunctionArgumentsNode.cloneUninitialized(this.arguments, materializedTags), this.directEvalNode.copyUninitialized(materializedTags));
    }

    protected static abstract class DirectEvalNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        private final Object currEnv;
        @Node.Child
        private JavaScriptNode thisNode;
        @Node.Child
        private IndirectCallNode callNode;
        private final int blockScopeSlot;

        protected DirectEvalNode(JSContext context, JavaScriptNode thisNode, Object currEnv, int blockScopeSlot) {
            assert (currEnv != null);
            this.context = context;
            this.currEnv = currEnv;
            this.thisNode = thisNode;
            this.callNode = IndirectCallNode.create();
            this.blockScopeSlot = blockScopeSlot;
        }

        protected static DirectEvalNode create(JSContext context, JavaScriptNode thisNode, Object currEnv, int blockScopeSlot) {
            return EvalNodeGen.DirectEvalNodeGen.create(context, thisNode, currEnv, blockScopeSlot);
        }

        public abstract Object executeWithSource(VirtualFrame var1, Object var2);

        @Specialization
        protected int directEvalInt(int source) {
            return source;
        }

        @Specialization
        protected SafeInteger directEvalSafeInteger(SafeInteger source) {
            return source;
        }

        @Specialization
        protected long directEvalLong(long source) {
            return source;
        }

        @Specialization
        protected double directEvalDouble(double source) {
            return source;
        }

        @Specialization
        protected boolean directEvalBoolean(boolean source) {
            return source;
        }

        @Specialization
        protected Symbol directEvalSymbol(Symbol source) {
            return source;
        }

        @Specialization
        protected BigInt directEvalBigInt(BigInt source) {
            return source;
        }

        @Specialization
        protected JSDynamicObject directEvalJSType(JSDynamicObject source) {
            return source;
        }

        @Specialization
        protected Object directEvalCharSequence(VirtualFrame frame, TruffleString source) {
            return this.directEvalImpl(frame, source);
        }

        private Object directEvalImpl(VirtualFrame frame, TruffleString sourceCode) {
            MaterializedFrame blockScopeFrame;
            Source source = this.sourceFromString(sourceCode);
            JSRealm realm = this.getRealm();
            Object evalThis = this.thisNode.execute(frame);
            ScriptNode script = this.context.getEvaluator().parseDirectEval(this.context, this.getParent(), source, this.currEnv);
            if (this.blockScopeSlot >= 0) {
                Object maybeFrame = frame.getObject(this.blockScopeSlot);
                blockScopeFrame = JSFrameUtil.castMaterializedFrame(maybeFrame);
            } else {
                blockScopeFrame = frame.materialize();
            }
            return script.runEval(this.callNode, realm, evalThis, blockScopeFrame);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isForeignObject(sourceCode)"}, limit="3")
        protected Object directEvalForeignObject(VirtualFrame frame, Object sourceCode, @CachedLibrary(value="sourceCode") InteropLibrary interop, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            if (interop.isString(sourceCode)) {
                return this.directEvalImpl(frame, Strings.interopAsTruffleString(sourceCode, interop, switchEncoding));
            }
            return sourceCode;
        }

        @CompilerDirectives.TruffleBoundary
        private Source sourceFromString(TruffleString sourceCode) {
            String evalSourceName = EvalNode.formatEvalOrigin(this, this.context, "<eval>");
            return Source.newBuilder("js", Strings.toJavaString(sourceCode), evalSourceName).cached(false).build();
        }

        protected DirectEvalNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return DirectEvalNode.create(this.context, JavaScriptNode.cloneUninitialized(this.thisNode, materializedTags), this.currEnv, this.blockScopeSlot);
        }
    }
}

