/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ControlFlowException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.ResumableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.StatementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.YieldException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@NodeInfo(shortName="try-finally")
public class TryFinallyNode
extends StatementNode
implements ResumableNode.WithObjectState {
    @Node.Child
    private JavaScriptNode tryBlock;
    @Node.Child
    private JavaScriptNode finallyBlock;

    TryFinallyNode(JavaScriptNode tryBlock, JavaScriptNode finallyBlock) {
        this.tryBlock = tryBlock;
        this.finallyBlock = finallyBlock;
    }

    public static JavaScriptNode create(JavaScriptNode tryBlock, JavaScriptNode finallyBlock) {
        return new TryFinallyNode(tryBlock, finallyBlock);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return TryFinallyNode.create(TryFinallyNode.cloneUninitialized(this.tryBlock, materializedTags), TryFinallyNode.cloneUninitialized(this.finallyBlock, materializedTags));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Throwable throwable;
        Object result = null;
        try {
            result = this.tryBlock.execute(frame);
            throwable = null;
        }
        catch (ControlFlowException cfe) {
            throwable = cfe;
        }
        catch (AbstractTruffleException ex) {
            throwable = ex;
        }
        catch (StackOverflowError ste) {
            throwable = ste;
        }
        this.finallyBlock.executeVoid(frame);
        if (throwable != null) {
            throw JSRuntime.rethrow(throwable);
        }
        assert (result != null);
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        Throwable throwable;
        try {
            this.tryBlock.executeVoid(frame);
            throwable = null;
        }
        catch (ControlFlowException cfe) {
            throwable = cfe;
        }
        catch (AbstractTruffleException ex) {
            throwable = ex;
        }
        catch (StackOverflowError ste) {
            throwable = ste;
        }
        this.finallyBlock.executeVoid(frame);
        if (throwable != null) {
            throw JSRuntime.rethrow(throwable);
        }
    }

    @Override
    public Object resume(VirtualFrame frame, int stateSlot) {
        Object result = EMPTY;
        Throwable throwable = null;
        Object state = this.getStateAndReset(frame, stateSlot);
        if (state == Undefined.instance) {
            try {
                result = this.tryBlock.execute(frame);
            }
            catch (YieldException e) {
                throw e;
            }
            catch (ControlFlowException cfe) {
                throwable = cfe;
            }
            catch (AbstractTruffleException ex) {
                throwable = ex;
            }
            catch (StackOverflowError ste) {
                throwable = ste;
            }
        } else if (state instanceof Throwable) {
            throwable = (Throwable)state;
        }
        try {
            this.finallyBlock.execute(frame);
        }
        catch (YieldException e) {
            this.setState(frame, stateSlot, throwable);
            throw e;
        }
        if (throwable != null) {
            throw JSRuntime.rethrow(throwable);
        }
        return result;
    }
}

