/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control;

import java.util.ArrayDeque;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Completion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class AsyncGeneratorEnqueueNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callPromiseRejectNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;
    private final ConditionProfile notExecutingProf = ConditionProfile.create();

    protected AsyncGeneratorEnqueueNode(JSContext context) {
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.asyncGeneratorResumeNextNode = AsyncGeneratorResumeNextNode.create(context);
    }

    public static AsyncGeneratorEnqueueNode create(JSContext context) {
        return new AsyncGeneratorEnqueueNode(context);
    }

    public Object execute(Object generator, Completion completion) {
        JSAsyncGeneratorObject asyncGeneratorObject;
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        if (!(generator instanceof JSAsyncGeneratorObject) || (asyncGeneratorObject = (JSAsyncGeneratorObject)generator).hasGeneratorBrand()) {
            this.enterErrorBranch();
            return this.badGeneratorError(promiseCapability);
        }
        assert (asyncGeneratorObject.getAsyncGeneratorContext() != null);
        ArrayDeque<AsyncGeneratorRequest> queue = asyncGeneratorObject.getAsyncGeneratorQueue();
        AsyncGeneratorRequest request = AsyncGeneratorRequest.create(completion, promiseCapability);
        Boundaries.queueAdd(queue, request);
        JSFunction.AsyncGeneratorState state = asyncGeneratorObject.getAsyncGeneratorState();
        if (this.notExecutingProf.profile(state != JSFunction.AsyncGeneratorState.Executing)) {
            this.asyncGeneratorResumeNextNode.execute(asyncGeneratorObject);
        }
        return promiseCapability.getPromise();
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private void enterErrorBranch() {
        if (this.callPromiseRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callPromiseRejectNode = this.insert(JSFunctionCallNode.createCall());
        }
    }

    private Object badGeneratorError(PromiseCapabilityRecord promiseCapability) {
        Object badGeneratorError = Errors.createTypeErrorAsyncGeneratorObjectExpected().getErrorObject();
        Object reject = promiseCapability.getReject();
        this.callPromiseRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, reject, badGeneratorError));
        return promiseCapability.getPromise();
    }
}

