/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={JSConfig.class, JSRuntime.class})
public abstract class ToArrayIndexNoToPropertyKeyNode
extends JavaScriptBaseNode {
    public abstract long executeLong(Node var1, Object var2);

    protected ToArrayIndexNoToPropertyKeyNode() {
    }

    @Specialization(guards={"isIntArrayIndex(value)"})
    protected static long doInteger(int value) {
        return value;
    }

    @Specialization(guards={"!isIntArrayIndex(value)"})
    protected static long doIntegerNonArrayIndex(int value) {
        return -1L;
    }

    @Specialization(guards={"isLongArrayIndex(value)"})
    protected static long doLong(long value) {
        return JSRuntime.castArrayIndex(value);
    }

    @Specialization(guards={"!isLongArrayIndex(value)"})
    protected static long doLongNonArrayIndex(long value) {
        return -1L;
    }

    protected static boolean doubleIsIntIndex(double d) {
        return JSRuntime.doubleIsRepresentableAsInt(d) && d >= 0.0;
    }

    @Specialization(guards={"doubleIsIntIndex(value)"})
    protected static long doDoubleAsIntIndex(double value) {
        return JSRuntime.castArrayIndex(value);
    }

    protected static boolean doubleIsUintIndex(double d) {
        return JSRuntime.doubleIsRepresentableAsUnsignedInt(d, true) && d >= 0.0 && d < 4.294967295E9;
    }

    @Specialization(guards={"doubleIsUintIndex(value)"}, replaces={"doDoubleAsIntIndex"})
    protected static long doDoubleAsUintIndex(double value) {
        return JSRuntime.castArrayIndex(value);
    }

    @Specialization(guards={"!doubleIsUintIndex(value)"})
    protected static long doDoubleNonArrayIndex(double value) {
        return -1L;
    }

    @Specialization(guards={"isBigIntArrayIndex(value)"})
    protected static long doBigInt(BigInt value) {
        return value.longValue();
    }

    @Specialization
    protected static long doBigIntNonArrayIndex(BigInt value) {
        return -1L;
    }

    @Specialization(guards={"arrayIndexLengthInRange(index)"})
    protected static long convertFromString(Node node, TruffleString index, @Cached TruffleString.ReadCharUTF16Node stringReadNode, @Cached InlinedBranchProfile startsWithDigitBranch, @Cached InlinedBranchProfile isArrayIndexBranch, @Cached InlinedBranchProfile invalidArrayIndexBranch) {
        if (JSRuntime.isAsciiDigit(Strings.charAt(stringReadNode, index, 0))) {
            startsWithDigitBranch.enter(node);
            long longValue = JSRuntime.parseArrayIndexRaw(index, stringReadNode);
            if (JSRuntime.isArrayIndex(longValue)) {
                isArrayIndexBranch.enter(node);
                return JSRuntime.castArrayIndex(longValue);
            }
        }
        invalidArrayIndexBranch.enter(node);
        return -1L;
    }

    @Specialization(guards={"!arrayIndexLengthInRange(index)"})
    protected static long convertFromStringNotInRange(TruffleString index) {
        return -1L;
    }

    protected static boolean notArrayIndex(Object o) {
        return !(o instanceof Integer) && !(o instanceof Double) && !(o instanceof Long) && !(o instanceof BigInt) && !(o instanceof TruffleString);
    }

    @Specialization(guards={"notArrayIndex(value)"}, limit="InteropLibraryLimit")
    protected static long doNonArrayIndex(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        long index = ToArrayIndexNode.toArrayIndex(value, interop);
        if (index >= 0L) {
            return JSRuntime.castArrayIndex(index);
        }
        return -1L;
    }
}

