/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;

@GenerateInline
@GenerateUncached
public abstract class LongToIntOrDoubleNode
extends JavaScriptBaseNode {
    public abstract Number execute(Node var1, long var2);

    public final Number fromIndex(Node node, long index) {
        assert (JSRuntime.isIntegerIndex(index)) : index;
        return this.execute(node, index);
    }

    @Specialization
    protected static Number toIntOrDouble(Node node, long value, @Cached InlinedBranchProfile toDoubleBranch) {
        if (CompilerDirectives.injectBranchProbability(0.75, JSRuntime.longIsRepresentableAsInt(value))) {
            return (int)value;
        }
        toDoubleBranch.enter(node);
        return (double)value;
    }

    @NeverDefault
    public static LongToIntOrDoubleNode create() {
        return LongToIntOrDoubleNodeGen.create();
    }
}

