/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Idempotent;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.OperatorsBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;

public abstract class JSToNumericNode
extends JavaScriptBaseNode {
    private final boolean toNumericOperand;

    public abstract Object execute(Object var1);

    protected JSToNumericNode(boolean toNumericOperand) {
        this.toNumericOperand = toNumericOperand;
    }

    @NeverDefault
    public static JSToNumericNode create(boolean toNumericOperand) {
        return JSToNumericNodeGen.create(toNumericOperand);
    }

    @NeverDefault
    public static JSToNumericNode create() {
        return JSToNumericNode.create(false);
    }

    @NeverDefault
    public static JSToNumericNode createToNumericOperand() {
        return JSToNumericNode.create(true);
    }

    public static JavaScriptNode create(JavaScriptNode child, boolean toNumericOperand) {
        Object constantOperand;
        if (child.isResultAlwaysOfType(Number.class) || child.isResultAlwaysOfType(Integer.TYPE) || child.isResultAlwaysOfType(Double.TYPE)) {
            return child;
        }
        if (child instanceof JSConstantNode && (constantOperand = ((JSConstantNode)child).getValue()) != null && !(constantOperand instanceof Symbol) && JSRuntime.isJSPrimitive(constantOperand)) {
            return JSConstantNode.create(JSRuntime.toNumeric(constantOperand));
        }
        return JSToNumericNodeGen.JSToNumericWrapperNodeGen.create(child, toNumericOperand);
    }

    public static JavaScriptNode createToNumericOperand(JavaScriptNode child) {
        return JSToNumericNode.create(child, true);
    }

    @Specialization
    protected static int doInt(int value) {
        return value;
    }

    @Specialization
    protected static double doDouble(double value) {
        return value;
    }

    @Specialization(guards={"!value.isForeign()"})
    protected static BigInt doBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"value.isForeign()"})
    protected static double doForeignBigInt(BigInt value) {
        return value.doubleValue();
    }

    @Specialization(guards={"isToNumericOperand()"})
    protected Object doOverloaded(JSOverloadedOperatorsObject arg) {
        OperatorsBuiltins.checkOverloadedOperatorsAllowed(arg, this);
        return arg;
    }

    @Specialization(guards={"isToNumericOperand()", "!hasOverloadedOperators(value)"})
    protected final Object doToNumericOperandOther(Object value, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveNode, @Cached.Shared @Cached PrimitiveToNumericOrNullNode numericOrNullNode, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        Object primValue = toPrimitiveNode.executeHintNumber(value);
        Object alreadyNumeric = numericOrNullNode.execute(this, primValue);
        if (alreadyNumeric != null) {
            return alreadyNumeric;
        }
        return toNumberNode.executeNumber(primValue);
    }

    @Specialization(guards={"!isToNumericOperand()", "!isBigInt(value)"})
    protected final Object doToNumericOther(Object value, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveNode, @Cached.Shared @Cached PrimitiveToNumericOrNullNode numericOrNullNode, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        Object primValue = toPrimitiveNode.executeHintNumber(value);
        Object alreadyNumeric = numericOrNullNode.execute(this, primValue);
        if (alreadyNumeric != null) {
            return alreadyNumeric;
        }
        return toNumberNode.executeNumber(primValue);
    }

    @Idempotent
    protected final boolean isToNumericOperand() {
        return this.toNumericOperand;
    }

    public static abstract class JSToNumericWrapperNode
    extends JSUnaryNode {
        protected final boolean toNumericOperand;

        protected JSToNumericWrapperNode(JavaScriptNode operand, boolean toNumericOperand) {
            super(operand);
            this.toNumericOperand = toNumericOperand;
        }

        @Specialization
        protected static Object doDefault(Object value, @Cached(value="create(toNumericOperand)") JSToNumericNode toNumericNode) {
            return toNumericNode.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToNumericNode.create(JSToNumericWrapperNode.cloneUninitialized(this.getOperand(), materializedTags), this.toNumericOperand);
        }

        @Override
        public String expressionToString() {
            return this.getOperand().expressionToString();
        }
    }

    @ImportStatic(value={JSToNumericNode.class})
    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class PrimitiveToNumericOrNullNode
    extends JavaScriptBaseNode {
        protected PrimitiveToNumericOrNullNode() {
        }

        public abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"!value.isForeign()"})
        protected static BigInt doBigInt(BigInt value) {
            return value;
        }

        @Specialization(guards={"value.isForeign()"})
        protected static double doForeignBigInt(BigInt value) {
            return value.doubleValue();
        }

        @Specialization
        protected static double doLong(long value) {
            return value;
        }

        @Fallback
        protected static Object doOther(Object value) {
            return null;
        }
    }
}

