/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@GenerateUncached
public abstract class JSDoubleToStringNode
extends JavaScriptBaseNode {
    public abstract TruffleString executeString(Object var1);

    public abstract TruffleString executeString(double var1);

    public abstract TruffleString executeString(long var1);

    @Specialization
    protected static TruffleString doInt(int i, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode) {
        return Strings.fromLong(fromLongNode, i);
    }

    @Specialization
    protected static TruffleString doLong(long i, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode) {
        return Strings.fromLong(fromLongNode, i);
    }

    @Specialization
    protected TruffleString doDouble(double d, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode, @Cached InlinedConditionProfile isInt, @Cached InlinedConditionProfile isNaN, @Cached InlinedConditionProfile isPositiveInfinity, @Cached InlinedConditionProfile isNegativeInfinity, @Cached InlinedConditionProfile isZero, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        if (isZero.profile(this, d == 0.0)) {
            return Strings.ZERO;
        }
        if (isInt.profile(this, JSRuntime.doubleIsRepresentableAsInt(d, true))) {
            return JSDoubleToStringNode.doInt((int)d, fromLongNode);
        }
        if (isNaN.profile(this, Double.isNaN(d))) {
            return Strings.NAN;
        }
        if (isPositiveInfinity.profile(this, d == Double.POSITIVE_INFINITY)) {
            return Strings.INFINITY;
        }
        if (isNegativeInfinity.profile(this, d == Double.NEGATIVE_INFINITY)) {
            return Strings.NEGATIVE_INFINITY;
        }
        return Strings.fromJavaString(fromJavaStringNode, JSRuntime.formatDtoA(d));
    }
}

