/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSCompareNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSLessOrEqualNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringOrNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@NodeInfo(shortName="<=")
public abstract class JSLessOrEqualNode
extends JSCompareNode {
    protected JSLessOrEqualNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JSLessOrEqualNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSLessOrEqualNodeGen.create(left, right);
    }

    public static JSLessOrEqualNode create() {
        return JSLessOrEqualNodeGen.create(null, null);
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    @Specialization
    protected static boolean doInt(int a, int b) {
        return a <= b;
    }

    @Specialization
    protected static boolean doSafeInteger(int a, SafeInteger b) {
        return (long)a <= b.longValue();
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger a, int b) {
        return a.longValue() <= (long)b;
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger a, SafeInteger b) {
        return a.longValue() <= b.longValue();
    }

    @Specialization
    protected static boolean doLong(long a, long b) {
        return a <= b;
    }

    @Specialization
    protected static boolean doDouble(double a, double b) {
        return a <= b;
    }

    @Specialization
    protected static boolean doString(TruffleString a, TruffleString b, @Cached TruffleString.CompareCharsUTF16Node compareNode) {
        return Strings.compareTo(compareNode, a, b) <= 0;
    }

    @Specialization
    protected static boolean doStringDouble(TruffleString a, double b, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSLessOrEqualNode.doDouble(stringToDouble.execute(a), b);
    }

    @Specialization
    protected static boolean doDoubleString(double a, TruffleString b, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSLessOrEqualNode.doDouble(a, stringToDouble.execute(b));
    }

    @Specialization
    protected static boolean doStringBigInt(TruffleString a, BigInt b) {
        BigInt aBigInt = JSRuntime.stringToBigInt(a);
        return aBigInt == null ? false : JSLessOrEqualNode.doBigInt(aBigInt, b);
    }

    @Specialization
    protected static boolean doBigIntString(BigInt a, TruffleString b) {
        BigInt bBigInt = JSRuntime.stringToBigInt(b);
        return bBigInt == null ? false : JSLessOrEqualNode.doBigInt(a, bBigInt);
    }

    @Specialization
    protected static boolean doBigInt(BigInt a, BigInt b) {
        return a.compareTo(b) <= 0;
    }

    @Specialization
    protected static boolean doBigIntAndInt(BigInt a, int b) {
        return a.compareValueTo(b) <= 0;
    }

    @Specialization
    protected static boolean doBigIntAndNumber(BigInt a, double b) {
        if (Double.isNaN(b)) {
            return false;
        }
        return a.compareValueTo(b) <= 0;
    }

    @Specialization
    protected static boolean doIntAndBigInt(int a, BigInt b) {
        return b.compareValueTo(a) >= 0;
    }

    @Specialization
    protected static boolean doNumberAndBigInt(double a, BigInt b) {
        if (Double.isNaN(a)) {
            return false;
        }
        return b.compareValueTo(a) >= 0;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected static boolean doOverloaded(Object a, Object b, @Bind Node node, @Cached(value="createHintNumberRightToLeft(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
        Object result = overloadedOperatorNode.execute(b, a);
        if (result == Undefined.instance) {
            return false;
        }
        return !toBooleanNode.executeBoolean(node, result);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_OPEN;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doString", "doStringDouble", "doDoubleString", "doStringBigInt", "doBigIntString", "doBigInt", "doBigIntAndInt", "doIntAndBigInt", "doBigIntAndNumber", "doNumberAndBigInt"})
    protected static boolean doGeneric(Object a, Object b, @Cached JSToStringOrNumberNode toStringOrNumber1, @Cached JSToPrimitiveNode toPrimitive1, @Cached JSToStringOrNumberNode toStringOrNumber2, @Cached JSToPrimitiveNode toPrimitive2, @Cached JSLessOrEqualNode lessOrEqualNode) {
        Object aPrimitive = toPrimitive1.executeHintNumber(a);
        Object bPrimitive = toPrimitive2.executeHintNumber(b);
        aPrimitive = toStringOrNumber1.execute(aPrimitive);
        bPrimitive = toStringOrNumber2.execute(bPrimitive);
        return lessOrEqualNode.executeBoolean(aPrimitive, bPrimitive);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSLessOrEqualNodeGen.create(JSLessOrEqualNode.cloneUninitialized(this.getLeft(), materializedTags), JSLessOrEqualNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

