/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSExponentiateNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName="**")
public abstract class JSExponentiateNode
extends JSBinaryNode {
    protected JSExponentiateNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSExponentiateNodeGen.create(left, right);
    }

    public static JSExponentiateNode create() {
        return (JSExponentiateNode)JSExponentiateNode.create(null, null);
    }

    public abstract Object execute(Object var1, Object var2);

    @Specialization
    protected double doDouble(double a, double b) {
        return Math.pow(a, b);
    }

    @Specialization(guards={"isBigIntNegativeVal(b)"})
    protected Object doBigIntNegativeExponent(BigInt a, BigInt b) {
        throw Errors.createRangeError("BigInt exponent must not be negative");
    }

    @Specialization(guards={"isBigIntZero(a)", "!isBigIntZero(b)", "!isBigIntNegativeVal(b)"})
    protected BigInt doBigIntZero(BigInt a, BigInt b) {
        return BigInt.ZERO;
    }

    @Specialization(guards={"isBigIntZero(b)"})
    protected BigInt doBigIntZeroPowZero(BigInt a, BigInt b) {
        return BigInt.ONE;
    }

    @Specialization(guards={"!isBigIntZero(a)", "!isBigIntZero(b)", "!isBigIntNegativeVal(b)"})
    @CompilerDirectives.TruffleBoundary
    protected BigInt doBigInt(BigInt a, BigInt b) {
        if (b.compareTo(BigInt.MAX_INT) < 0) {
            try {
                return a.pow(b.intValue());
            }
            catch (ArithmeticException ae) {
                throw Errors.createRangeErrorBigIntMaxSizeExceeded();
            }
        }
        if (a.compareTo(BigInt.ONE) == 0) {
            return BigInt.ONE;
        }
        if (a.compareTo(BigInt.NEGATIVE_ONE) == 0) {
            return b.testBit(0) ? BigInt.NEGATIVE_ONE : BigInt.ONE;
        }
        throw Errors.createRangeErrorBigIntMaxSizeExceeded();
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a, Object b, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, b);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_STAR_STAR;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doDouble"})
    protected static Object doGeneric(Object a, Object b, @Bind Node node, @Cached JSExponentiateNode nestedExponentiateNode, @Cached JSToNumericNode toNumeric1Node, @Cached JSToNumericNode toNumeric2Node, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object operandA = toNumeric1Node.execute(a);
        Object operandB = toNumeric2Node.execute(b);
        JSExponentiateNode.ensureBothSameNumericType(operandA, operandB, node, mixedNumericTypes);
        return nestedExponentiateNode.execute(operandA, operandB);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSExponentiateNodeGen.create(JSExponentiateNode.cloneUninitialized(this.getLeft(), materializedTags), JSExponentiateNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

