/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSDivideNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName="/")
public abstract class JSDivideNode
extends JSBinaryNode {
    protected JSDivideNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JSDivideNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSDivideNodeGen.create(left, right);
    }

    public static JSDivideNode create() {
        return JSDivideNode.create(null, null);
    }

    public abstract Object execute(Object var1, Object var2);

    protected static boolean isCornercase(int a, int b) {
        return a != 0 && (b != -1 || a != Integer.MIN_VALUE);
    }

    @Specialization(rewriteOn={ArithmeticException.class}, guards={"b > 0"})
    protected int doInt1(int a, int b) {
        if (a % b == 0) {
            return a / b;
        }
        throw new ArithmeticException();
    }

    @Specialization(rewriteOn={ArithmeticException.class}, guards={"a > 0"})
    protected int doInt2(int a, int b) {
        return this.doInt1(a, b);
    }

    @Specialization(rewriteOn={ArithmeticException.class}, guards={"isCornercase(a, b)"})
    protected int doInt3(int a, int b) {
        return this.doInt1(a, b);
    }

    @Specialization(replaces={"doInt1", "doInt2", "doInt3"})
    protected double doDouble(double a, double b) {
        return a / b;
    }

    @Specialization(guards={"isBigIntZero(b)"})
    protected BigInt doBigIntZeroDivision(BigInt a, BigInt b) {
        throw Errors.createRangeError("Division by zero");
    }

    @Specialization(guards={"!isBigIntZero(b)"})
    protected BigInt doBigInt(BigInt a, BigInt b) {
        return a.divide(b);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a, Object b, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, b);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SLASH;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doDouble"})
    protected static Object doGeneric(Object a, Object b, @Bind Node node, @Cached JSDivideNode nestedDivideNode, @Cached JSToNumericNode toNumeric1Node, @Cached JSToNumericNode toNumeric2Node, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object numericA = toNumeric1Node.execute(a);
        Object numericB = toNumeric2Node.execute(b);
        JSDivideNode.ensureBothSameNumericType(numericA, numericB, node, mixedNumericTypes);
        return nestedDivideNode.execute(numericA, numericB);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSDivideNodeGen.create(JSDivideNode.cloneUninitialized(this.getLeft(), materializedTags), JSDivideNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

