/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSSetLengthNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@ImportStatic(value={JSArray.class})
public abstract class JSSetLengthNode
extends JavaScriptBaseNode {
    private final JSContext context;
    protected final boolean isStrict;

    protected JSSetLengthNode(JSContext context, boolean isStrict) {
        this.context = context;
        this.isStrict = isStrict;
    }

    public static JSSetLengthNode create(JSContext context, boolean strict) {
        return JSSetLengthNodeGen.create(context, strict);
    }

    public abstract Object execute(Object var1, Object var2);

    @NeverDefault
    protected final PropertySetNode createSetLengthProperty() {
        return PropertySetNode.create(JSArray.LENGTH, false, this.context, this.isStrict);
    }

    @Specialization(guards={"isJSFastArray(object)"})
    protected static int setArrayLength(JSArrayObject object, int length, @Cached(value="create(isStrict)") ArrayLengthNode.ArrayLengthWriteNode arrayLengthWriteNode) {
        arrayLengthWriteNode.executeVoid(object, length);
        return length;
    }

    @Specialization
    protected static int setIntLength(JSDynamicObject object, int length, @Cached(value="createSetLengthProperty()") @Cached.Shared PropertySetNode setLengthProperty) {
        setLengthProperty.setValueInt(object, length);
        return length;
    }

    @Specialization(replaces={"setIntLength"})
    protected static Object setLength(JSDynamicObject object, Object length, @Cached(value="createSetLengthProperty()") @Cached.Shared PropertySetNode setLengthProperty) {
        setLengthProperty.setValue(object, length);
        return length;
    }

    @Specialization(guards={"!isJSDynamicObject(object)"})
    protected static Object setLengthForeign(Object object, Object length) {
        return length;
    }
}

