/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.TypedArrayLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@ImportStatic(value={JSArrayBufferView.class})
@GenerateInline
@GenerateCached(value=false)
public abstract class ArrayBufferViewGetByteLengthNode
extends JavaScriptBaseNode {
    protected ArrayBufferViewGetByteLengthNode() {
    }

    public abstract int executeInt(Node var1, JSTypedArrayObject var2, JSContext var3);

    @Specialization(guards={"!isOutOfBounds(obj, context)", "cachedArray == obj.getArrayType()"}, limit="1")
    protected static int getByteLengthCached(JSTypedArrayObject obj, JSContext context, @Cached(value="obj.getArrayType()") TypedArray cachedArray) {
        return cachedArray.lengthInt(obj) << cachedArray.bytesPerElementShift();
    }

    @Specialization(replaces={"getByteLengthCached"})
    protected static int getByteLength(Node node, JSTypedArrayObject typedArray, JSContext context, @Cached TypedArrayLengthNode typedArrayLengthNode) {
        return typedArrayLengthNode.execute(node, typedArray, context) << typedArray.getArrayType().bytesPerElementShift();
    }
}

