/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameSlotKind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.FrameSlotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;

public final class TemporalDeadZoneCheckNode
extends FrameSlotNode {
    @Node.Child
    private JavaScriptNode child;
    @Node.Child
    private ScopeFrameNode levelFrameNode;
    @CompilerDirectives.CompilationFinal
    private boolean seenDead;

    private TemporalDeadZoneCheckNode(int slot, Object identifier, ScopeFrameNode levelFrameNode, JavaScriptNode child) {
        super(slot, identifier);
        this.levelFrameNode = levelFrameNode;
        this.child = child;
    }

    private void checkNotDead(VirtualFrame frame) {
        Frame levelFrame = this.levelFrameNode.executeFrame(frame);
        if (CompilerDirectives.injectBranchProbability(1.0E-4, levelFrame.getTag(this.slot) == FrameSlotKind.Illegal.tag)) {
            if (!this.seenDead) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenDead = true;
            }
            throw Errors.createReferenceErrorNotDefined(this.getIdentifier(), this);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.checkNotDead(frame);
        return this.child.execute(frame);
    }

    @Override
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        this.checkNotDead(frame);
        return this.child.executeInt(frame);
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        this.checkNotDead(frame);
        return this.child.executeDouble(frame);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        this.checkNotDead(frame);
        return this.child.executeBoolean(frame);
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return this.levelFrameNode;
    }

    @Override
    public boolean hasTemporalDeadZone() {
        return true;
    }

    public static TemporalDeadZoneCheckNode create(int slotIndex, Object identifier, ScopeFrameNode levelFrameNode, JavaScriptNode rhs) {
        return new TemporalDeadZoneCheckNode(slotIndex, identifier, levelFrameNode, rhs);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new TemporalDeadZoneCheckNode(this.getSlotIndex(), this.getIdentifier(), this.levelFrameNode, TemporalDeadZoneCheckNode.cloneUninitialized(this.child, materializedTags));
    }
}

