/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorNextUnaryNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;

public abstract class IteratorNextUnaryNode
extends JavaScriptNode {
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private IsObjectNode isObjectNode;
    @Node.Child
    private JavaScriptNode iteratorNode;

    protected IteratorNextUnaryNode(JavaScriptNode iteratorNode) {
        this.iteratorNode = iteratorNode;
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.isObjectNode = IsObjectNode.create();
    }

    public static JavaScriptNode create(JavaScriptNode iteratorNode) {
        return IteratorNextUnaryNodeGen.create(iteratorNode);
    }

    @Specialization
    protected final Object doDefault(VirtualFrame frame, @Cached InlinedBranchProfile errorBranch) {
        IteratorRecord iterator = (IteratorRecord)this.iteratorNode.execute(frame);
        return this.iteratorNext(iterator, errorBranch);
    }

    protected final Object iteratorNext(IteratorRecord iteratorRecord, InlinedBranchProfile errorBranch) {
        Object next;
        Object iterator = iteratorRecord.getIterator();
        Object nextResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, next = iteratorRecord.getNextMethod()));
        if (!this.isObjectNode.executeBoolean(nextResult)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorIteratorResultNotObject(nextResult, this);
        }
        return nextResult;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorNextUnaryNode.create(IteratorNextUnaryNode.cloneUninitialized(this.iteratorNode, materializedTags));
    }
}

