/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetSetRecordNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSNumberToDoubleNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.SetRecord;

@ImportStatic(value={Strings.class})
public abstract class GetSetRecordNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    protected GetSetRecordNode(JSContext context) {
        this.context = context;
    }

    @NeverDefault
    public static GetSetRecordNode create(JSContext context) {
        return GetSetRecordNodeGen.create(context);
    }

    public abstract SetRecord execute(Object var1);

    @Specialization
    protected SetRecord get(Object obj, @Cached IsObjectNode isObjectNode, @Cached(value="create(SIZE, context)") PropertyGetNode getSizeNode, @Cached(value="create(HAS, context)") PropertyGetNode getHasNode, @Cached(value="create(KEYS, context)") PropertyGetNode getKeysNode, @Cached JSToNumberNode toNumberNode, @Cached JSToIntegerOrInfinityNode toIntegerOrInfinityNode, @Cached JSNumberToDoubleNode numberToDoubleValueNode, @Cached IsCallableNode isCallableNode, @Cached InlinedBranchProfile errorBranch) {
        if (!isObjectNode.executeBoolean(obj)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAnObject(obj, this);
        }
        Object rawSize = getSizeNode.getValue(obj);
        Object numSize = toNumberNode.execute(rawSize);
        if (JSRuntime.isNaN(numSize)) {
            errorBranch.enter(this);
            throw Errors.createTypeError("The .size property is NaN", (Node)this);
        }
        Object intSize = toIntegerOrInfinityNode.execute(numSize);
        double doubleSize = numberToDoubleValueNode.execute(this, intSize);
        if (doubleSize < 0.0) {
            errorBranch.enter(this);
            throw Errors.createRangeErrorFormat("'%s' is an invalid size", this, JSRuntime.safeToString(intSize));
        }
        Object has = getHasNode.getValue(obj);
        if (!isCallableNode.executeBoolean(has)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorCallableExpected();
        }
        Object keys = getKeysNode.getValue(obj);
        if (!isCallableNode.executeBoolean(keys)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorCallableExpected();
        }
        return new SetRecord(obj, doubleSize, has, keys);
    }
}

