/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.DeclareGlobalNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.DeclareGlobalVariableNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSGlobalObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class DeclareGlobalVariableNode
extends DeclareGlobalNode {
    private final boolean configurable;
    @Node.Child
    private HasPropertyCacheNode hasOwnPropertyNode;
    @Node.Child
    private IsExtensibleNode isExtensibleNode = IsExtensibleNode.create();

    protected DeclareGlobalVariableNode(TruffleString varName, boolean configurable) {
        super(varName);
        this.configurable = configurable;
    }

    public static DeclareGlobalVariableNode create(TruffleString varName, boolean configurable) {
        return DeclareGlobalVariableNodeGen.create(varName, configurable);
    }

    @Override
    public void verify(JSContext context, JSRealm realm) {
        super.verify(context, realm);
        JSDynamicObject globalObject = realm.getGlobalObject();
        if (this.hasOwnPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.hasOwnPropertyNode = this.insert(HasPropertyCacheNode.create(this.varName, context, true));
        }
        if (!this.hasOwnPropertyNode.hasProperty(globalObject) && !this.isExtensibleNode.executeBoolean(globalObject)) {
            this.errorProfile.enter();
            throw Errors.createTypeErrorGlobalObjectNotExtensible(this);
        }
    }

    @Override
    public final void executeVoid(JSContext context, JSRealm realm) {
        JSDynamicObject globalObject = realm.getGlobalObject();
        if (!this.hasOwnPropertyNode.hasProperty(globalObject)) {
            assert (JSObject.isExtensible(globalObject));
            this.executeVoid(globalObject, context);
        }
    }

    protected abstract void executeVoid(JSDynamicObject var1, JSContext var2);

    @Specialization(guards={"context.getPropertyCacheLimit() > 0"})
    protected void doCached(JSGlobalObject globalObject, JSContext context, @Cached(value="makeDefineOwnPropertyCache(context)") PropertySetNode cache) {
        cache.setValue(globalObject, Undefined.instance);
    }

    @Specialization(replaces={"doCached"})
    protected void doUncached(JSGlobalObject globalObject, JSContext context) {
        JSObjectUtil.defineConstantDataProperty(context, globalObject, this.varName, Undefined.instance, this.getAttributeFlags());
    }

    @Fallback
    protected void doGeneric(JSDynamicObject globalObject, JSContext context) {
        assert (!(globalObject instanceof JSGlobalObject));
        PropertyDescriptor desc = this.configurable ? PropertyDescriptor.undefinedDataDesc : PropertyDescriptor.undefinedDataDescNotConfigurable;
        JSObject.defineOwnProperty(globalObject, this.varName, desc, true);
    }

    private int getAttributeFlags() {
        return this.configurable ? JSAttributes.configurableEnumerableWritable() : JSAttributes.notConfigurableEnumerableWritable();
    }

    @NeverDefault
    protected final PropertySetNode makeDefineOwnPropertyCache(JSContext context) {
        return PropertySetNode.createImpl(this.varName, false, context, true, true, this.getAttributeFlags(), true);
    }

    @Override
    protected DeclareGlobalNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return DeclareGlobalVariableNode.create(this.varName, this.configurable);
    }
}

