/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateDataPropertyNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class CreateDataPropertyNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    protected final Object key;
    protected final boolean enumerable;
    @Node.Child
    protected IsJSObjectNode isObject;

    protected CreateDataPropertyNode(JSContext context, Object key, boolean enumerable) {
        assert (JSRuntime.isPropertyKey(key));
        this.context = context;
        this.key = key;
        this.isObject = IsJSObjectNode.create();
        this.enumerable = enumerable;
    }

    @NeverDefault
    public static CreateDataPropertyNode create(JSContext context, Object key) {
        return CreateDataPropertyNodeGen.create(context, key, true);
    }

    @NeverDefault
    public static CreateDataPropertyNode createNonEnumerable(JSContext context, Object key) {
        return CreateDataPropertyNodeGen.create(context, key, false);
    }

    public abstract void executeVoid(Object var1, Object var2);

    public final void executeVoid(Object object, Object propertyKey, Object value) {
        assert (propertyKey.equals(this.key));
        this.executeVoid(object, value);
    }

    @Specialization(guards={"context.getPropertyCacheLimit() > 0", "isObject.executeBoolean(object)"})
    protected static void doCached(Object object, Object value, @Cached(value="makeDefinePropertyCache()") PropertySetNode propertyCache) {
        propertyCache.setValue(object, value);
    }

    @Specialization(guards={"context.getPropertyCacheLimit() == 0"})
    protected final void doUncached(JSObject object, Object value) {
        if (this.enumerable) {
            JSRuntime.createDataPropertyOrThrow(object, this.key, value);
        } else {
            JSRuntime.createNonEnumerableDataPropertyOrThrow(object, this.key, value);
        }
    }

    @Specialization(guards={"!isJSObject(object)"})
    protected final void doNonObject(Object object, Object value) {
        throw Errors.createTypeErrorNotAnObject(object, this);
    }

    @NeverDefault
    protected final PropertySetNode makeDefinePropertyCache() {
        if (this.enumerable) {
            return PropertySetNode.createImpl(this.key, false, this.context, true, true, JSAttributes.getDefault());
        }
        return PropertySetNode.createImpl(this.key, false, this.context, true, true, JSAttributes.getDefaultNotEnumerable());
    }
}

