/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.codec;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;

public final class BinaryDecoder {
    private static final VarHandle INT32 = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT64 = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer buffer;
    private int pos;

    public BinaryDecoder(ByteBuffer buffer, int position) {
        this.buffer = buffer;
        this.pos = position;
    }

    public BinaryDecoder(ByteBuffer buffer) {
        this(buffer, 0);
    }

    private int getU1() {
        int u1 = Byte.toUnsignedInt(this.buffer.get(this.pos));
        ++this.pos;
        return u1;
    }

    private long getSV() {
        long b;
        long result = 0L;
        int shift = 0;
        do {
            b = this.getU1();
            result |= (b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80L) != 0L);
        if ((b & 0x40L) != 0L && shift < 64) {
            result |= -1L << shift;
        }
        return result;
    }

    public int getInt() {
        return (int)this.getSV();
    }

    private long getUV() {
        long b;
        long result = 0L;
        int shift = 0;
        do {
            b = this.getU1();
            result |= (b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80L) != 0L);
        return result;
    }

    public int getUInt() {
        return (int)this.getUV();
    }

    public long getLong() {
        return this.getSV();
    }

    public TruffleString getString() {
        int strideLog2 = this.getU1();
        byte[] byteArray = this.getByteArray();
        if (strideLog2 == TruffleString.CompactionLevel.S1.getLog2()) {
            return TruffleString.fromByteArrayUncached(byteArray, TruffleString.Encoding.ISO_8859_1).switchEncodingUncached(TruffleString.Encoding.UTF_16);
        }
        assert (strideLog2 == TruffleString.CompactionLevel.S2.getLog2()) : strideLog2;
        return TruffleString.fromByteArrayUncached(byteArray, TruffleString.Encoding.UTF_16);
    }

    public byte[] getByteArray() {
        int size = this.getUInt();
        byte[] array = new byte[size];
        this.buffer.get(this.pos, array);
        this.pos += size;
        return array;
    }

    public BigInteger getBigInteger() {
        long b;
        BigInteger result = BigInteger.ZERO;
        int shift = 0;
        do {
            b = this.getU1();
            result = result.or(BigInteger.valueOf(b & 0x7FL).shiftLeft(shift));
            shift += 7;
        } while ((b & 0x80L) != 0L);
        if ((b & 0x40L) != 0L) {
            result = result.negate();
        }
        return result;
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getInt64());
    }

    public long getInt64() {
        long i64 = INT64.get(this.buffer, this.pos);
        this.pos += 8;
        return i64;
    }

    public int getInt32() {
        int i32 = INT32.get(this.buffer, this.pos);
        this.pos += 4;
        return i32;
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

