/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.web;

import java.nio.ByteBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.InternalByteArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ConstructorBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.web.JSTextEncoder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.web.JSTextEncoderObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.web.TextEncoderBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.ArrayBufferViewGetByteLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;

public class TextEncoderBuiltins {
    public static final TruffleString UTF_8 = Strings.constant("utf-8");
    public static final TruffleString TEXT_ENCODER_PROTOTYPE = Strings.constant("TextEncoder.prototype");
    public static final JSBuiltinsContainer BUILTINS = JSBuiltinsContainer.fromEnum(TEXT_ENCODER_PROTOTYPE, TextEncoderPrototype.class);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TextEncoderPrototype implements BuiltinEnum<TextEncoderPrototype>
    {
        TextEncoder(0){

            @Override
            public boolean isConstructor() {
                return true;
            }

            @Override
            public boolean isNewTargetConstructor() {
                return true;
            }
        }
        ,
        encode(0),
        encodeInto(2),
        encoding(0);

        private final int length;

        private TextEncoderPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == encoding;
        }

        @Override
        public Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> TextEncoderBuiltinsFactory.ConstructorNodeGen.create(context, builtin, newTarget, this.args().functionOrNewTarget(newTarget).createArgumentNodes(context));
                case 1 -> TextEncoderBuiltinsFactory.EncodeNodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                case 2 -> TextEncoderBuiltinsFactory.EncodeIntoNodeGen.create(context, builtin, this.args().withThis().fixedArgs(2).createArgumentNodes(context));
                case 3 -> TextEncoderBuiltinsFactory.GetEncodingNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
            };
        }
    }

    @ImportStatic(value={JSArrayBuffer.class, JSConfig.class})
    public static abstract class UTF8EncodeIntoNode
    extends JavaScriptBaseNode {
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode = TruffleString.SwitchEncodingNode.create();
        @Node.Child
        private TruffleString.ReadByteNode readByteNode = TruffleString.ReadByteNode.create();
        @Node.Child
        private TruffleString.GetCodeRangeImpreciseNode getCodeRangeImpreciseNode = TruffleString.GetCodeRangeImpreciseNode.create();
        @Node.Child
        private TruffleString.GetInternalByteArrayNode getInternalByteArrayNode = TruffleString.GetInternalByteArrayNode.create();

        protected UTF8EncodeIntoNode() {
        }

        public final long execute(TruffleString string, JSTypedArrayObject destination) {
            return this.execute(string, destination, 0, Integer.MAX_VALUE);
        }

        public abstract long execute(TruffleString var1, JSTypedArrayObject var2, int var3, int var4);

        @Specialization(guards={"isJSHeapArrayBuffer(destination.getArrayBuffer())"})
        protected final long doHeapBuffer(TruffleString string, JSTypedArrayObject destination, int destOffset, int maxLength, @Cached @Cached.Shared ArrayBufferViewGetByteLengthNode getTypedArrayByteLengthNode) {
            ByteBuffer rawBuffer = Boundaries.byteBufferWrap(JSArrayBufferObject.getByteArray(destination.getArrayBuffer()));
            return this.encodeInto(string, destination, destOffset, maxLength, rawBuffer, getTypedArrayByteLengthNode, null);
        }

        @Specialization(guards={"isJSDirectOrSharedArrayBuffer(destination.getArrayBuffer())"})
        protected final long doDirectBuffer(TruffleString string, JSTypedArrayObject destination, int destOffset, int maxLength, @Cached @Cached.Shared ArrayBufferViewGetByteLengthNode getTypedArrayByteLengthNode) {
            ByteBuffer rawBuffer = JSArrayBuffer.getDirectByteBuffer(destination.getArrayBuffer());
            return this.encodeInto(string, destination, destOffset, maxLength, rawBuffer, getTypedArrayByteLengthNode, null);
        }

        @Specialization(guards={"isJSInteropArrayBuffer(destination.getArrayBuffer())"})
        protected final long doInteropBuffer(TruffleString string, JSTypedArrayObject destination, int destOffset, int maxLength, @Cached @Cached.Shared ArrayBufferViewGetByteLengthNode getTypedArrayByteLengthNode, @CachedLibrary(limit="1") InteropLibrary asByteBufferInterop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary bufferInterop) {
            ByteBuffer rawBuffer = JSInteropUtil.foreignInteropBufferAsByteBuffer(destination.getArrayBuffer(), asByteBufferInterop, this.getRealm());
            if (rawBuffer != null && rawBuffer.isReadOnly()) {
                rawBuffer = null;
            }
            return this.encodeInto(string, destination, destOffset, maxLength, rawBuffer, getTypedArrayByteLengthNode, bufferInterop);
        }

        protected final long encodeInto(TruffleString string, JSTypedArrayObject destination, int viewOffset, int maxLength, ByteBuffer rawBuffer, ArrayBufferViewGetByteLengthNode getTypedArrayByteLengthNode, InteropLibrary interop) {
            int readLength;
            int copyLength;
            int bufferByteOffset = destination.getByteOffset();
            int bufferByteLength = getTypedArrayByteLengthNode.executeInt(this, destination, this.getJSContext());
            int destinationOffset = bufferByteOffset + viewOffset;
            int destinationByteLength = Math.min(bufferByteLength - viewOffset, maxLength);
            if (destinationByteLength <= 0) {
                return 0L;
            }
            TruffleString utf8Str = this.switchEncodingNode.execute(string, TruffleString.Encoding.UTF_8);
            int utf8ByteLength = utf8Str.byteLength(TruffleString.Encoding.UTF_8);
            JSArrayBufferObject arrayBuffer = destination.getArrayBuffer();
            InternalByteArray byteArray = this.getInternalByteArrayNode.execute(utf8Str, TruffleString.Encoding.UTF_8);
            if (utf8ByteLength <= destinationByteLength) {
                copyLength = byteArray.getLength();
                readLength = Strings.length(string);
            } else {
                for (copyLength = destinationByteLength; copyLength > 0 && UTF8EncodeIntoNode.isUTF8ContinuationByte(this.readByteNode.execute(utf8Str, copyLength, TruffleString.Encoding.UTF_8)); --copyLength) {
                }
                TruffleString.CodeRange codeRange = this.getCodeRangeImpreciseNode.execute(utf8Str, TruffleString.Encoding.UTF_8);
                readLength = codeRange.isSubsetOf(TruffleString.CodeRange.ASCII) ? copyLength : UTF8EncodeIntoNode.calculateUtf16Length(byteArray.getArray(), byteArray.getOffset(), copyLength);
                assert (copyLength <= byteArray.getLength());
            }
            if (interop == null || rawBuffer != null) {
                Boundaries.byteBufferPutArray(rawBuffer, destinationOffset, byteArray.getArray(), byteArray.getOffset(), copyLength);
            } else {
                JSInteropUtil.writeBuffer(arrayBuffer, destinationOffset, byteArray.getArray(), byteArray.getOffset(), copyLength, interop);
            }
            UTF8EncodeIntoNode.reportLoopCount((Node)this, copyLength);
            return (long)readLength << 32 | Integer.toUnsignedLong(copyLength);
        }

        private static boolean isUTF8ContinuationByte(int b) {
            return (b & 0xC0) == 128;
        }

        private static int calculateUtf16Length(byte[] utf8Bytes, int offset, int length) {
            int utf16Length = 0;
            int utf8Index = offset;
            while (utf8Index < length) {
                int utf16Width;
                int utf8Width;
                int b = Byte.toUnsignedInt(utf8Bytes[utf8Index]);
                if (b < 128) {
                    utf8Width = 1;
                    utf16Width = 1;
                } else if (b < 224) {
                    utf8Width = 2;
                    utf16Width = 1;
                } else if (b < 240) {
                    utf8Width = 3;
                    utf16Width = 1;
                } else {
                    utf8Width = 4;
                    utf16Width = 2;
                }
                utf8Index += utf8Width;
                utf16Length += utf16Width;
            }
            assert (utf8Index == length);
            return utf16Length;
        }
    }

    @ImportStatic(value={TypedArrayFactory.class, JSConfig.class})
    public static abstract class EncodeIntoNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateDataPropertyNode createReadDataPropertyNode;
        @Node.Child
        private CreateDataPropertyNode createWrittenDataPropertyNode;

        protected EncodeIntoNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createReadDataPropertyNode = CreateDataPropertyNode.create(context, Strings.READ);
            this.createWrittenDataPropertyNode = CreateDataPropertyNode.create(context, Strings.WRITTEN);
        }

        @Specialization(guards={"destination.getArrayType().getFactory() == Uint8Array"})
        protected final JSObject encodeInto(JSTextEncoderObject thisObj, TruffleString string, JSTypedArrayObject destination, @Cached @Cached.Shared UTF8EncodeIntoNode utf8EncodeInto) {
            long result = JSArrayBufferView.isOutOfBounds(destination, this.getContext()) ? 0L : utf8EncodeInto.execute(string, destination);
            int readLength = (int)(result >>> 32);
            int writtenLength = (int)result;
            return this.createEncodeIntoResult(readLength, writtenLength);
        }

        private JSObject createEncodeIntoResult(int readLength, int writtenLength) {
            JSRealm realm = this.getRealm();
            JSObject result = JSOrdinary.create(this.getContext(), realm);
            this.createReadDataPropertyNode.executeVoid(result, readLength);
            this.createWrittenDataPropertyNode.executeVoid(result, writtenLength);
            return result;
        }

        @Specialization
        protected final JSObject doValidate(JSTextEncoderObject thisObj, Object source, Object destination, @Cached JSToStringNode toStringNode, @Cached @Cached.Shared UTF8EncodeIntoNode utf8EncodeInto) {
            JSTypedArrayObject typedArray;
            TruffleString string = toStringNode.executeString(source);
            if (destination instanceof JSTypedArrayObject && (typedArray = (JSTypedArrayObject)destination).getArrayType().getFactory() == TypedArrayFactory.Uint8Array) {
                return this.encodeInto(thisObj, string, typedArray, utf8EncodeInto);
            }
            throw Errors.createTypeError("Not a Uint8Array");
        }

        @Fallback
        protected final Object incompatibleReceiver(Object thisObj, Object string, Object destination) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class EncodeNode
    extends JSBuiltinNode {
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode constructTypedArrayNode;
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode;

        protected EncodeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.constructTypedArrayNode = ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(context, true);
            this.switchEncodingNode = TruffleString.SwitchEncodingNode.create();
        }

        @Specialization
        protected final JSTypedArrayObject doString(JSTextEncoderObject thisObj, TruffleString string) {
            ByteBuffer rawBuffer;
            TruffleString utf8Str = this.switchEncodingNode.execute(string, TruffleString.Encoding.UTF_8);
            int utf8ByteLength = utf8Str.byteLength(TruffleString.Encoding.UTF_8);
            JSTypedArrayObject destination = this.constructTypedArrayNode.typedArrayCreate((Object)this.getRealm().getArrayBufferViewConstructor(TypedArrayFactory.Uint8Array), utf8ByteLength);
            JSArrayBufferObject arrayBuffer = destination.getArrayBuffer();
            if (arrayBuffer instanceof JSArrayBufferObject.Heap) {
                JSArrayBufferObject.Heap heapBuffer = (JSArrayBufferObject.Heap)arrayBuffer;
                rawBuffer = Boundaries.byteBufferWrap(heapBuffer.getByteArray());
            } else {
                rawBuffer = ((JSArrayBufferObject.Direct)arrayBuffer).getByteBuffer();
            }
            InternalByteArray byteArray = utf8Str.getInternalByteArrayUncached(TruffleString.Encoding.UTF_8);
            assert (byteArray.getLength() == utf8ByteLength);
            Boundaries.byteBufferPutArray(rawBuffer, 0, byteArray.getArray(), byteArray.getOffset(), utf8ByteLength);
            EncodeNode.reportLoopCount((Node)this, utf8ByteLength);
            return destination;
        }

        @Specialization
        protected final JSTypedArrayObject doOther(JSTextEncoderObject thisObj, Object string, @Cached(value="createUndefinedToEmpty()") JSToStringNode toStringNode) {
            return this.doString(thisObj, toStringNode.executeString(string));
        }

        @Fallback
        protected final Object incompatibleReceiver(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class GetEncodingNode
    extends JSBuiltinNode {
        protected GetEncodingNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static TruffleString encoding(JSTextEncoderObject thisObj) {
            return UTF_8;
        }

        @Fallback
        protected final JSObject incompatibleReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class ConstructorNode
    extends ConstructorBuiltins.ConstructWithNewTargetNode {
        protected ConstructorNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected final JSObject construct(JSDynamicObject newTarget) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTextEncoder.create(this.getJSContext(), realm, proto);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return this.getRealm().getTextEncoderPrototype();
        }
    }
}

