/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm.WebAssemblyTablePrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToWebAssemblyIndexOrSizeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyValueType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class WebAssemblyTablePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WebAssemblyTablePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WebAssemblyTablePrototypeBuiltins();

    protected WebAssemblyTablePrototypeBuiltins() {
        super(JSWebAssemblyTable.PROTOTYPE_NAME, WebAssemblyTablePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WebAssemblyTablePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGrowNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 1: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGetNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableSetNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 3: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGetLengthNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum WebAssemblyTablePrototype implements BuiltinEnum<WebAssemblyTablePrototype>
    {
        grow(1),
        get(1),
        set(1),
        length(0);

        private final int functionLength;

        private WebAssemblyTablePrototype(int length) {
            this.functionLength = length;
        }

        @Override
        public int getLength() {
            return this.functionLength;
        }

        @Override
        public boolean isEnumerable() {
            return true;
        }

        @Override
        public boolean isGetter() {
            return this == length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyTableGrowNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toDeltaNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.grow(): Argument 0");

        public WebAssemblyTableGrowNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object grow(Object thiz, Object delta, Object[] args, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary tableGrowLib, @Cached InlinedBranchProfile errorBranch) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("WebAssembly.Table.grow(): Receiver is not a WebAssembly.Table");
            }
            JSWebAssemblyTableObject table = (JSWebAssemblyTableObject)thiz;
            int deltaInt = this.toDeltaNode.executeInt(delta);
            Object wasmTable = table.getWASMTable();
            WebAssemblyValueType elementKind = table.getElementKind();
            JSRealm realm = this.getRealm();
            Object wasmValue = args.length == 0 ? elementKind.getDefaultValue(realm) : toWebAssemblyValueNode.execute(args[0], elementKind);
            try {
                Object growFn = realm.getWASMTableGrow();
                return tableGrowLib.execute(growFn, wasmTable, deltaInt, wasmValue);
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException ex) {
                errorBranch.enter(this);
                throw Errors.createRangeError(ex, (Node)this);
            }
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyTableGetNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toIndexNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.get(): Argument 0");

        public WebAssemblyTableGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object get(Object thiz, Object index, @Cached ToJSValueNode toJSValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary tableGetLib, @Cached InlinedBranchProfile errorBranch) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("WebAssembly.Table.get(): Receiver is not a WebAssembly.Table");
            }
            JSRealm realm = this.getRealm();
            int indexInt = this.toIndexNode.executeInt(index);
            Object wasmTable = ((JSWebAssemblyTableObject)thiz).getWASMTable();
            try {
                Object getFn = realm.getWASMTableRead();
                Object fn = tableGetLib.execute(getFn, wasmTable, indexInt);
                return toJSValueNode.execute(fn);
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException ex) {
                errorBranch.enter(this);
                throw Errors.createRangeError(ex, (Node)this);
            }
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyTableSetNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toIndexNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.set(): Argument 0");

        public WebAssemblyTableSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object set(Object thiz, Object index, Object[] args, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary tableSetLib, @Cached InlinedBranchProfile errorBranch) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("WebAssembly.Table.set(): Receiver is not a WebAssembly.Table");
            }
            JSWebAssemblyTableObject table = (JSWebAssemblyTableObject)thiz;
            int indexInt = this.toIndexNode.executeInt(index);
            Object wasmTable = table.getWASMTable();
            WebAssemblyValueType elementKind = table.getElementKind();
            JSRealm realm = this.getRealm();
            Object wasmValue = args.length == 0 ? elementKind.getDefaultValue(realm) : toWebAssemblyValueNode.execute(args[0], elementKind);
            try {
                Object setFn = realm.getWASMTableWrite();
                tableSetLib.execute(setFn, wasmTable, indexInt, wasmValue);
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException ex) {
                errorBranch.enter(this);
                throw Errors.createRangeError(ex, (Node)this);
            }
            return Undefined.instance;
        }
    }

    public static abstract class WebAssemblyTableGetLengthNode
    extends JSBuiltinNode {
        @Node.Child
        InteropLibrary tableLengthLib = InteropLibrary.getFactory().createDispatched(5);

        public WebAssemblyTableGetLengthNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getLength(JSWebAssemblyTableObject tableObj) {
            Object wasmTable = tableObj.getWASMTable();
            try {
                Object lengthFn = this.getRealm().getWASMTableLength();
                return this.tableLengthLib.execute(lengthFn, wasmTable);
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        protected Object doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError("WebAssembly.Table.length(): Receiver is not a WebAssembly.Table", (Node)this);
        }
    }
}

