/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ExceptionType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm.WebAssemblyBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.TryCatchNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ExportByteSourceNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.GraalJSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromise;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstance;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstanceObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModule;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModuleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.ByteSequence;

public class WebAssemblyBuiltins
extends JSBuiltinsContainer.SwitchEnum<WebAssembly> {
    public static final JSBuiltinsContainer BUILTINS = new WebAssemblyBuiltins();

    protected WebAssemblyBuiltins() {
        super(JSWebAssembly.CLASS_NAME, WebAssembly.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WebAssembly builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WebAssemblyBuiltinsFactory.WebAssemblyCompileNodeGen.create(context, builtin, WebAssemblyBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return WebAssemblyBuiltinsFactory.WebAssemblyInstantiateNodeGen.create(context, builtin, WebAssemblyBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return WebAssemblyBuiltinsFactory.WebAssemblyValidateNodeGen.create(context, builtin, WebAssemblyBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Source buildSource(ByteSequence byteSource) {
        String moduleName = "js:module-" + Integer.toHexString(byteSource.hashCode());
        return Source.newBuilder("wasm", byteSource, moduleName).mimeType("application/wasm").build();
    }

    @CompilerDirectives.TruffleBoundary
    public static Object moduleDecode(JSRealm realm, Source wasmSource) {
        assert ("wasm".equals(wasmSource.getLanguage())) : wasmSource;
        CallTarget result = realm.getEnv().parsePublic(wasmSource, new String[0]);
        return result.call("module_decode");
    }

    public static enum WebAssembly implements BuiltinEnum<WebAssembly>
    {
        compile(1),
        instantiate(1),
        validate(1);

        private final int length;

        private WebAssembly(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isEnumerable() {
            return true;
        }
    }

    public static abstract class WebAssemblyCompileNode
    extends PromisifiedBuiltinNode {
        @Node.Child
        ExportByteSourceNode exportByteSourceNode;

        public WebAssemblyCompileNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.exportByteSourceNode = ExportByteSourceNode.create(context, "WebAssembly.compile(): Argument 0 must be a buffer source", "WebAssembly.compile(): BufferSource argument is empty");
        }

        @Specialization
        protected Object compile(Object byteSource) {
            return this.promisify(byteSource);
        }

        @Override
        protected Object process(Object argument) {
            ByteSequence byteSource = this.exportByteSourceNode.execute(argument);
            JSRealm realm = this.getRealm();
            Source wasmSource = WebAssemblyBuiltins.buildSource(byteSource);
            Object wasmModule = WebAssemblyBuiltins.moduleDecode(realm, wasmSource);
            return JSWebAssemblyModule.create(this.getContext(), realm, wasmModule, wasmSource);
        }
    }

    public static abstract class WebAssemblyInstantiateNode
    extends PromisifiedBuiltinNode {
        @Node.Child
        ExportByteSourceNode exportByteSourceNode;
        @Node.Child
        IsObjectNode isObjectNode;
        @Node.Child
        PerformPromiseThenNode performPromiseThenNode;
        @Node.Child
        InteropLibrary instantiateModuleLib;
        private final BranchProfile errorBranch = BranchProfile.create();

        public WebAssemblyInstantiateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.exportByteSourceNode = ExportByteSourceNode.create(context, "WebAssembly.instantiate(): Argument 0 must be a buffer source or a WebAssembly.Module object", "WebAssembly.instantiate(): BufferSource argument is empty");
            this.isObjectNode = IsObjectNode.create();
            this.performPromiseThenNode = PerformPromiseThenNode.create(context);
            this.instantiateModuleLib = InteropLibrary.getFactory().createDispatched(5);
        }

        @Specialization
        protected Object instantiate(Object byteSourceOrModule, Object importObject) {
            JSPromiseObject promise = this.promisify(new Object[]{byteSourceOrModule, importObject});
            if (byteSourceOrModule instanceof JSWebAssemblyModuleObject) {
                return promise;
            }
            assert (!JSPromise.isPending(promise));
            if (JSPromise.isRejected(promise)) {
                return promise;
            }
            JSContext context = this.getContext();
            JSRealm realm = this.getRealm();
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapability.execute(realm.getPromiseConstructor());
            JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WebAssemblySourceInstantiation, c -> WebAssemblyInstantiateNode.createSourceInstantiationImpl(c));
            this.performPromiseThenNode.execute(promise, JSFunction.create(realm, functionData), Undefined.instance, promiseCapability);
            return promiseCapability.getPromise();
        }

        @Override
        protected Object process(Object argument) {
            Object[] args = (Object[])argument;
            Object byteSourceOrModule = args[0];
            Object importObject = args[1];
            if (importObject != Undefined.instance && !this.isObjectNode.executeBoolean(importObject)) {
                throw Errors.createTypeError("WebAssembly.instantiate(): Argument 1 must be an object", (Node)this);
            }
            JSRealm realm = this.getRealm();
            if (byteSourceOrModule instanceof JSWebAssemblyModuleObject) {
                Object wasmModule = ((JSWebAssemblyModuleObject)byteSourceOrModule).getWASMModule();
                return WebAssemblyInstantiateNode.instantiateModule(this.getContext(), realm, wasmModule, importObject, this.instantiateModuleLib);
            }
            ByteSequence wasmByteSource = this.exportByteSourceNode.execute(byteSourceOrModule);
            try {
                try {
                    Source wasmSource = WebAssemblyBuiltins.buildSource(wasmByteSource);
                    Object wasmModule = WebAssemblyBuiltins.moduleDecode(realm, wasmSource);
                    return new InstantiatedSourceInfo(wasmModule, importObject, wasmSource);
                }
                catch (AbstractTruffleException ex) {
                    this.errorBranch.enter();
                    ExceptionType type = InteropLibrary.getUncached(ex).getExceptionType(ex);
                    if (type == ExceptionType.PARSE_ERROR) {
                        throw Errors.createCompileError(ex, (Node)this);
                    }
                    throw ex;
                }
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
        }

        public static JSWebAssemblyInstanceObject instantiateModule(JSContext context, JSRealm realm, Object wasmModule, Object importObject, InteropLibrary instantiateModuleLib) {
            Object wasmInstance;
            Object wasmImportObject = JSWebAssemblyInstance.transformImportObject(context, realm, wasmModule, importObject);
            Object instantiate = realm.getWASMModuleInstantiate();
            try {
                wasmInstance = instantiateModuleLib.execute(instantiate, wasmModule, wasmImportObject);
            }
            catch (GraalJSException jsex) {
                throw jsex;
            }
            catch (AbstractTruffleException ex) {
                throw Errors.createLinkError(ex, null);
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            return JSWebAssemblyInstance.create(context, realm, wasmInstance, wasmModule);
        }

        private static JSFunctionData createSourceInstantiationImpl(final JSContext context) {
            RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private InteropLibrary instantiateModuleLib;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.instantiateModuleLib = InteropLibrary.getFactory().createDispatched(5);
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    InstantiatedSourceInfo info = (InstantiatedSourceInfo)JSArguments.getUserArgument(frame.getArguments(), 0);
                    JSWebAssemblyInstanceObject jsInstance = WebAssemblyInstantiateNode.instantiateModule(context, this.getRealm(), info.wasmModule(), info.importObject(), this.instantiateModuleLib);
                    return this.toJSInstantiatedSource(info.wasmModule(), jsInstance, info.wasmSource());
                }

                Object toJSInstantiatedSource(Object wasmModule, Object jsInstance, Source wasmSource) {
                    JSRealm realm = this.getRealm();
                    JSObject instantiatedSource = JSOrdinary.create(context, realm);
                    JSObject.set((JSDynamicObject)instantiatedSource, Strings.MODULE, (Object)JSWebAssemblyModule.create(context, realm, wasmModule, wasmSource));
                    JSObject.set((JSDynamicObject)instantiatedSource, Strings.INSTANCE, jsInstance);
                    return instantiatedSource;
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(context, callTarget, 1, Strings.EMPTY_STRING);
        }
    }

    public static abstract class WebAssemblyValidateNode
    extends JSBuiltinNode {
        @Node.Child
        ExportByteSourceNode exportByteSourceNode;

        public WebAssemblyValidateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.exportByteSourceNode = ExportByteSourceNode.create(context, "WebAssembly.validate(): Argument 0 must be a buffer source", null);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean validateImpl(JSRealm realm, ByteSequence byteSource) {
            try {
                realm.getEnv().parsePublic(WebAssemblyBuiltins.buildSource(byteSource), new String[0]);
                return true;
            }
            catch (AbstractTruffleException ex) {
                return false;
            }
        }

        @Specialization
        protected Object validate(Object byteSource) {
            return WebAssemblyValidateNode.validateImpl(this.getRealm(), this.exportByteSourceNode.execute(byteSource));
        }
    }

    record InstantiatedSourceInfo(Object wasmModule, Object importObject, Source wasmSource) implements TruffleObject
    {
    }

    protected static abstract class PromisifiedBuiltinNode
    extends JSBuiltinNode {
        @Node.Child
        NewPromiseCapabilityNode newPromiseCapability;
        @Node.Child
        JSFunctionCallNode promiseResolutionCallNode;
        @Node.Child
        TryCatchNode.GetErrorObjectNode getErrorObjectNode;
        private final BranchProfile errorBranch = BranchProfile.create();

        public PromisifiedBuiltinNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapability = NewPromiseCapabilityNode.create(context);
            this.promiseResolutionCallNode = JSFunctionCallNode.createCall();
        }

        protected abstract Object process(Object var1);

        protected JSPromiseObject promisify(Object argument) {
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapability.executeDefault();
            try {
                Object resolution = this.process(argument);
                this.promiseResolutionCallNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), resolution));
            }
            catch (AbstractTruffleException ex) {
                this.errorBranch.enter();
                try {
                    InteropLibrary interop = InteropLibrary.getUncached(ex);
                    ExceptionType type = interop.getExceptionType(ex);
                    AbstractTruffleException exception = ex;
                    if (type == ExceptionType.PARSE_ERROR) {
                        exception = Errors.createCompileError(ex, (Node)this);
                    }
                    if (this.getErrorObjectNode == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
                    }
                    Object error = this.getErrorObjectNode.execute(exception);
                    this.promiseResolutionCallNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), error));
                }
                catch (UnsupportedMessageException umex) {
                    throw Errors.shouldNotReachHere(umex);
                }
            }
            return (JSPromiseObject)promiseCapability.getPromise();
        }
    }
}

