/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalNowBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalNowBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalNow> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalNowBuiltins();

    protected TemporalNowBuiltins() {
        super(TemporalConstants.NOW, TemporalNow.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalNow builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalNowBuiltinsFactory.TemporalNowTimeZoneIdNodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(0).createArgumentNodes(context));
            }
            case 1: {
                return TemporalNowBuiltinsFactory.TemporalNowInstantNodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainDateTimeISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return TemporalNowBuiltinsFactory.TemporalNowZonedDateTimeISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainDateISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 5: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainTimeISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalNow implements BuiltinEnum<TemporalNow>
    {
        timeZoneId(0),
        instant(0),
        plainDateTimeISO(0),
        zonedDateTimeISO(0),
        plainDateISO(0),
        plainTimeISO(0);

        private final int length;

        private TemporalNow(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class TemporalNowTimeZoneIdNode
    extends JSBuiltinNode {
        protected TemporalNowTimeZoneIdNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString timeZoneId() {
            return TemporalUtil.systemTimeZoneIdentifier(this.getRealm());
        }
    }

    public static abstract class TemporalNowInstantNode
    extends JSBuiltinNode {
        protected TemporalNowInstantNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalInstantObject instant() {
            return TemporalUtil.systemInstant(this.getContext(), this.getRealm());
        }
    }

    public static abstract class TemporalNowPlainDateTimeISONode
    extends JSBuiltinNode {
        protected TemporalNowPlainDateTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainDateTimeObject plainDateTimeISO(Object temporalTimeZoneLike, @Cached ToTemporalTimeZoneIdentifierNode toTemporalIdentifier, @Cached InlinedBranchProfile errorBranch) {
            JSRealm realm = this.getRealm();
            JSTemporalDateTimeRecord isoDateTime = TemporalUtil.systemDateTime(realm, temporalTimeZoneLike, toTemporalIdentifier);
            return JSTemporalPlainDateTime.create(this.getContext(), realm, isoDateTime.getYear(), isoDateTime.getMonth(), isoDateTime.getDay(), isoDateTime.getHour(), isoDateTime.getMinute(), isoDateTime.getSecond(), isoDateTime.getMillisecond(), isoDateTime.getMicrosecond(), isoDateTime.getNanosecond(), TemporalConstants.ISO8601, this, errorBranch);
        }
    }

    public static abstract class TemporalNowZonedDateTimeISONode
    extends JSBuiltinNode {
        protected TemporalNowZonedDateTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalZonedDateTimeObject zonedDateTimeISO(Object temporalTimeZoneLike, @Cached ToTemporalTimeZoneIdentifierNode toTemporalIdentifier) {
            JSRealm realm = this.getRealm();
            TruffleString timeZone = temporalTimeZoneLike == Undefined.instance ? TemporalUtil.systemTimeZoneIdentifier(realm) : toTemporalIdentifier.execute(temporalTimeZoneLike);
            BigInt ns = TemporalUtil.systemUTCEpochNanoseconds(realm);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, ns, timeZone, TemporalConstants.ISO8601);
        }
    }

    public static abstract class TemporalNowPlainDateISONode
    extends JSBuiltinNode {
        protected TemporalNowPlainDateISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainDateObject plainDateISO(Object temporalTimeZoneLike, @Cached ToTemporalTimeZoneIdentifierNode toTemporalIdentifier, @Cached InlinedBranchProfile errorBranch) {
            JSRealm realm = this.getRealm();
            JSTemporalDateTimeRecord isoDateTime = TemporalUtil.systemDateTime(realm, temporalTimeZoneLike, toTemporalIdentifier);
            return JSTemporalPlainDate.create(this.getContext(), realm, isoDateTime.getYear(), isoDateTime.getMonth(), isoDateTime.getDay(), TemporalConstants.ISO8601, this, errorBranch);
        }
    }

    public static abstract class TemporalNowPlainTimeISONode
    extends JSBuiltinNode {
        protected TemporalNowPlainTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainTimeObject plainTimeISO(Object temporalTimeZoneLike, @Cached ToTemporalTimeZoneIdentifierNode toTemporalIdentifier, @Cached InlinedBranchProfile errorBranch) {
            JSRealm realm = this.getRealm();
            JSTemporalDateTimeRecord isoDateTime = TemporalUtil.systemDateTime(realm, temporalTimeZoneLike, toTemporalIdentifier);
            return JSTemporalPlainTime.create(this.getContext(), realm, isoDateTime.getHour(), isoDateTime.getMinute(), isoDateTime.getSecond(), isoDateTime.getMillisecond(), isoDateTime.getMicrosecond(), isoDateTime.getNanosecond(), this, errorBranch);
        }
    }
}

