/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.MathOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorStepNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.IsNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSNumberToDoubleNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.external.XSum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;

public abstract class SumPreciseNode
extends MathOperation {
    public SumPreciseNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected double sumPrecise(Object items, @Cached RequireObjectCoercibleNode requireObjectCoercible, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached IteratorStepNode iteratorStepNode, @Cached IteratorValueNode iteratorValueNode, @Cached(value="create(getContext())") IteratorCloseNode iteratorCloseNode, @Cached IsNumberNode isNumberNode, @Cached JSNumberToDoubleNode toDoubleNode, @Cached InlinedBranchProfile errorBranch) {
        requireObjectCoercible.executeVoid(items);
        IteratorRecord iter = getIteratorNode.execute(this, items);
        boolean negativeZero = true;
        XSum.SmallAccumulator acc = new XSum.SmallAccumulator();
        try {
            Object next;
            while ((next = iteratorStepNode.execute(iter)) != Boolean.FALSE) {
                Object nextValue = iteratorValueNode.execute(next);
                if (isNumberNode.execute(this, nextValue)) {
                    double doubleValue = toDoubleNode.execute(this, nextValue);
                    if (JSRuntime.isNegativeZero(doubleValue)) continue;
                    negativeZero = false;
                    acc.add(doubleValue);
                    continue;
                }
                errorBranch.enter(this);
                throw Errors.createTypeErrorNotANumber(nextValue);
            }
            return negativeZero ? -0.0 : acc.round();
        }
        catch (AbstractTruffleException ex) {
            errorBranch.enter(this);
            iteratorCloseNode.executeAbrupt(iter.getIterator());
            throw ex;
        }
    }
}

