/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.MathOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;

public abstract class FloorNode
extends MathOperation {
    public FloorNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static int floorInt(int a) {
        return a;
    }

    @Specialization
    protected static SafeInteger floorSafeInt(SafeInteger a) {
        return a;
    }

    @Specialization
    protected final Object floorDouble(double d, @Cached @Cached.Shared InlinedConditionProfile isZero, @Cached @Cached.Shared InlinedConditionProfile fitsInt, @Cached @Cached.Shared InlinedConditionProfile fitsSafeLong, @Cached @Cached.Shared InlinedConditionProfile smaller) {
        if (isZero.profile(this, d == 0.0)) {
            return d;
        }
        if (fitsInt.profile(this, d >= -2.147483648E9 && d <= 2.147483647E9)) {
            int i = (int)d;
            return smaller.profile(this, d < (double)i) ? i - 1 : i;
        }
        if (fitsSafeLong.profile(this, JSRuntime.isSafeInteger(d))) {
            long i = (long)d;
            long result = smaller.profile(this, d < (double)i) ? i - 1L : i;
            return SafeInteger.valueOf(result);
        }
        return Math.floor(d);
    }

    @Specialization(replaces={"floorDouble"})
    protected final Object floorToDouble(Object a, @Cached @Cached.Shared InlinedConditionProfile isZero, @Cached @Cached.Shared InlinedConditionProfile fitsInt, @Cached @Cached.Shared InlinedConditionProfile fitsSafeLong, @Cached @Cached.Shared InlinedConditionProfile smaller) {
        double d = this.toDouble(a);
        return this.floorDouble(d, isZero, fitsInt, fitsSafeLong, smaller);
    }
}

