/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.MathOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;

public abstract class AbsNode
extends MathOperation {
    public AbsNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    protected final int absInt(int a, @Cached InlinedConditionProfile negative) throws ArithmeticException {
        return negative.profile(this, a < 0) ? Math.subtractExact(0, a) : a;
    }

    @Specialization
    protected static double absIntSpecial(int a) {
        return Math.abs((double)a);
    }

    @Specialization
    protected static double absDouble(double a) {
        return Math.abs(a);
    }

    @Specialization
    protected double absGeneric(Object a) {
        return AbsNode.absDouble(this.toDouble(a));
    }
}

