/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.FinalizationRegistryPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.CanBeHeldWeaklyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistry;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistryObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class FinalizationRegistryPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<FinalizationRegistryPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new FinalizationRegistryPrototypeBuiltins();

    protected FinalizationRegistryPrototypeBuiltins() {
        super(JSFinalizationRegistry.PROTOTYPE_NAME, FinalizationRegistryPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, FinalizationRegistryPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return FinalizationRegistryPrototypeBuiltinsFactory.JSFinalizationRegistryRegisterNodeGen.create(context, builtin, FinalizationRegistryPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 1: {
                return FinalizationRegistryPrototypeBuiltinsFactory.JSFinalizationRegistryUnregisterNodeGen.create(context, builtin, FinalizationRegistryPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return FinalizationRegistryPrototypeBuiltinsFactory.JSFinalizationRegistryCleanupSomeNodeGen.create(context, builtin, FinalizationRegistryPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    static JSException invalidUnregisterToken(Object token) {
        throw Errors.createTypeErrorFormat("unregisterToken ('%s') must be an object", JSRuntime.safeToString(token));
    }

    public static enum FinalizationRegistryPrototype implements BuiltinEnum<FinalizationRegistryPrototype>
    {
        register(2),
        unregister(1),
        cleanupSome(0);

        private final int length;

        private FinalizationRegistryPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 2 -> 17;
                default -> 12;
            };
        }
    }

    public static abstract class JSFinalizationRegistryRegisterNode
    extends JSBuiltinNode {
        public JSFinalizationRegistryRegisterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject register(JSFinalizationRegistryObject thisObj, Object target, Object holdings, Object unregisterTokenArg, @Cached CanBeHeldWeaklyNode canBeHeldWeakly, @Cached(value="createSameValue()") JSIdenticalNode sameValueNode, @Cached InlinedBranchProfile errorBranch) {
            if (!canBeHeldWeakly.execute(this, target)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("FinalizationRegistry.prototype.register: invalid target");
            }
            if (sameValueNode.executeBoolean(target, holdings)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("FinalizationRegistry.prototype.register: target and holdings must not be same");
            }
            Object unregisterToken = unregisterTokenArg;
            if (!canBeHeldWeakly.execute(this, unregisterToken)) {
                if (unregisterToken != Undefined.instance) {
                    errorBranch.enter(this);
                    throw FinalizationRegistryPrototypeBuiltins.invalidUnregisterToken(unregisterToken);
                }
                unregisterToken = Undefined.instance;
            }
            JSFinalizationRegistry.appendToCells(thisObj, target, holdings, unregisterToken);
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSFinalizationRegistry(thisObj)"})
        protected static JSDynamicObject notFinalizationRegistry(Object thisObj, Object target, Object holdings, Object unregisterToken) {
            throw Errors.createTypeErrorFinalizationRegistryExpected();
        }
    }

    public static abstract class JSFinalizationRegistryUnregisterNode
    extends JSBuiltinNode {
        public JSFinalizationRegistryUnregisterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean unregister(JSFinalizationRegistryObject thisObj, Object unregisterToken, @Cached CanBeHeldWeaklyNode canBeHeldWeakly, @Cached InlinedBranchProfile errorBranch) {
            if (!canBeHeldWeakly.execute(this, unregisterToken)) {
                errorBranch.enter(this);
                throw FinalizationRegistryPrototypeBuiltins.invalidUnregisterToken(unregisterToken);
            }
            return JSFinalizationRegistry.removeFromCells(thisObj, unregisterToken);
        }

        @Specialization(guards={"!isJSFinalizationRegistry(thisObj)"})
        protected static boolean notFinalizationRegistry(Object thisObj, Object unregisterToken) {
            throw Errors.createTypeErrorFinalizationRegistryExpected();
        }
    }

    public static abstract class JSFinalizationRegistryCleanupSomeNode
    extends JSBuiltinNode {
        public JSFinalizationRegistryCleanupSomeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject cleanupSome(JSFinalizationRegistryObject thisObj, Object callback, @Cached IsCallableNode isCallableNode, @Cached InlinedBranchProfile errorBranch) {
            if (callback != Undefined.instance && !isCallableNode.executeBoolean(callback)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("FinalizationRegistry: cleanup must be callable");
            }
            JSFinalizationRegistry.cleanupFinalizationRegistry(thisObj, callback);
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSFinalizationRegistry(thisObj)"})
        protected static JSDynamicObject notFinalizationRegistry(Object thisObj, Object callback) {
            throw Errors.createTypeErrorFinalizationRegistryExpected();
        }
    }
}

