/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.TypedArrayLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@GenerateInline
@GenerateCached(value=false)
abstract class ArrayIteratorGetLengthNode
extends Node {
    ArrayIteratorGetLengthNode() {
    }

    abstract long execute(Node var1, Object var2, JSContext var3);

    @Specialization
    static long doArray(JSArrayObject array, JSContext context) {
        return JSArray.arrayGetLength(array);
    }

    @Specialization
    static long doTypedArray(Node node, JSTypedArrayObject typedArray, JSContext context, @Cached TypedArrayLengthNode typedArrayLengthNode, @Cached InlinedBranchProfile errorBranch) {
        if (JSArrayBufferView.isOutOfBounds(typedArray, context)) {
            errorBranch.enter(node);
            throw Errors.createTypeError("Cannot perform Array Iterator.prototype.next on a detached ArrayBuffer");
        }
        return typedArrayLengthNode.execute(node, typedArray, context);
    }

    @Fallback
    static long doArrayLike(Object array, JSContext context, @Cached(value="create(context)", inline=false) JSGetLengthNode getLengthNode) {
        return getLengthNode.executeLong(array);
    }
}

