/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractTruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.DecodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.Encodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.Stride;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.StringAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TSCodeRange;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringUnsafe;
import sun.misc.Unsafe;

final class TStringOps {
    TStringOps() {
    }

    static int readFromByteArray(byte[] array, int stride, int i) {
        long offset = TStringUnsafe.byteArrayBaseOffset();
        assert (TStringOps.validateRegionIndex(array, 0L, array.length >> stride, stride, i));
        return switch (stride) {
            case 0 -> TStringOps.uInt(array[i]);
            case 1 -> TStringUnsafe.getChar(array, offset + ((long)i << 1));
            default -> TStringUnsafe.getInt(array, offset + ((long)i << 2));
        };
    }

    static int readFromByteArrayS1(byte[] array, int i) {
        long offset = TStringUnsafe.byteArrayBaseOffset();
        assert (TStringOps.validateRegionIndex(array, 0L, array.length >> 1, 1, i));
        return TStringUnsafe.getChar(array, offset + ((long)i << 1));
    }

    static void writeToByteArrayS1(byte[] array, int i, int value) {
        long offset = TStringUnsafe.byteArrayBaseOffset();
        assert (TStringOps.validateRegionIndex(array, 0L, array.length >> 1, 1, i));
        TStringUnsafe.putChar(array, offset + ((long)i << 1), (char)value);
    }

    static void writeToByteArrayS2(byte[] array, int i, int value) {
        long offset = TStringUnsafe.byteArrayBaseOffset();
        assert (TStringOps.validateRegionIndex(array, 0L, array.length >> 2, 2, i));
        TStringUnsafe.putInt(array, offset + ((long)i << 2), value);
    }

    static void writeToByteArray(byte[] array, int stride, int i, int value) {
        switch (stride) {
            case 0: {
                array[i] = (byte)value;
                break;
            }
            case 1: {
                TStringOps.writeToByteArrayS1(array, i, value);
                break;
            }
            default: {
                TStringOps.writeToByteArrayS2(array, i, value);
            }
        }
    }

    static int readValue(AbstractTruffleString a, byte[] arrayA, long offsetA, int stride, int i) {
        return TStringOps.readValue(arrayA, offsetA, a.length(), stride, i);
    }

    static int readS0(AbstractTruffleString a, byte[] arrayA, long offsetA, int i) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(arrayA, offsetA, a.length(), 0, i));
        return TStringOps.uInt(TStringUnsafe.getByte(arrayA, offsetA + (long)i));
    }

    static char readS1(AbstractTruffleString a, byte[] arrayA, long offsetA, int i) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(arrayA, offsetA, a.length(), 1, i));
        return TStringUnsafe.getChar(arrayA, offsetA + ((long)i << 1));
    }

    static int readS2(AbstractTruffleString a, byte[] arrayA, long offsetA, int i) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(arrayA, offsetA, a.length(), 2, i));
        return TStringUnsafe.getInt(arrayA, offsetA + ((long)i << 2));
    }

    static int readS0(byte[] array, long offset, int length, int i) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, 0, i));
        return TStringOps.uInt(TStringUnsafe.getByte(array, offset + (long)i));
    }

    static char readS1(byte[] array, long offset, int length, int i) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, 1, i));
        return TStringUnsafe.getChar(array, offset + ((long)i << 1));
    }

    static int readS2(byte[] array, long offset, int length, int i) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, 2, i));
        return TStringUnsafe.getInt(array, offset + ((long)i << 2));
    }

    static long readS3(byte[] array, long offset, int length) {
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 3));
        return TStringUnsafe.getLong(array, offset);
    }

    static void writeS0(byte[] array, long offset, int length, int i, byte value) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, 0, i));
        TStringUnsafe.putByte(array, offset + (long)i, value);
    }

    static int readValue(byte[] array, long offset, int length, int stride, int i) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, i));
        return TStringOps.readValue(array, offset, stride, i);
    }

    private static int readValueS0(byte[] array, long offset, int i) {
        return TStringOps.uInt(TStringUnsafe.getByte(array, offset + (long)i));
    }

    private static char readValueS1(byte[] array, long offset, int i) {
        return TStringUnsafe.getChar(array, offset + ((long)i << 1));
    }

    private static int readValueS2(byte[] array, long offset, int i) {
        return TStringUnsafe.getInt(array, offset + ((long)i << 2));
    }

    private static int readValue(byte[] array, long offset, int stride, int i) {
        switch (stride) {
            case 0: {
                return TStringOps.uInt(TStringUnsafe.getByte(array, offset + (long)i));
            }
            case 1: {
                return TStringUnsafe.getChar(array, offset + ((long)i << 1));
            }
        }
        return TStringUnsafe.getInt(array, offset + ((long)i << 2));
    }

    private static void writeValue(byte[] array, long offset, int stride, int i, int value) {
        switch (stride) {
            case 0: {
                TStringUnsafe.putByte(array, offset + (long)i, (byte)value);
                return;
            }
            case 1: {
                TStringUnsafe.putChar(array, offset + ((long)i << 1), (char)value);
                return;
            }
        }
        TStringUnsafe.putInt(array, offset + ((long)i << 2), value);
    }

    static int indexOfAnyByte(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int toIndex, byte[] values) {
        assert (a.stride() == 0);
        return TStringOps.indexOfAnyByteIntl(location, arrayA, offsetA, toIndex, fromIndex, values);
    }

    private static int indexOfAnyByteIntl(Node location, byte[] array, long offset, int length, int fromIndex, byte[] values) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, 0, fromIndex));
        switch (values.length) {
            case 1: {
                return TStringOps.runIndexOfAny1(location, array, offset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]));
            }
            case 2: {
                return TStringOps.runIndexOfAny2(location, array, offset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]));
            }
            case 3: {
                return TStringOps.runIndexOfAny3(location, array, offset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]), TStringOps.uInt(values[2]));
            }
            case 4: {
                return TStringOps.runIndexOfAny4(location, array, offset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]), TStringOps.uInt(values[2]), TStringOps.uInt(values[3]));
            }
        }
        return TStringOps.runIndexOfAnyByte(location, array, offset, length, fromIndex, values);
    }

    static int indexOfAnyChar(Node location, byte[] arrayA, long offsetA, int stride, int fromIndex, int toIndex, char[] values) {
        assert (stride == 0 || stride == 1);
        return TStringOps.indexOfAnyCharIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, values);
    }

    private static int indexOfAnyCharIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, char[] values) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        if (stride == 0) {
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, array, offset, length, 0, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, array, offset, length, 0, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, array, offset, length, 0, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, array, offset, length, 0, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        } else {
            assert (stride == 1);
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, array, offset, length, 1, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, array, offset, length, 1, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, array, offset, length, 1, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, array, offset, length, 1, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        }
        return TStringOps.runIndexOfAnyChar(location, array, offset, length, stride, fromIndex, values);
    }

    static int indexOfAnyInt(Node location, byte[] arrayA, long offsetA, int stride, int fromIndex, int toIndex, int[] values) {
        return TStringOps.indexOfAnyIntIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, values);
    }

    private static int indexOfAnyIntIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int[] values) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        if (stride == 0) {
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, array, offset, length, 0, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, array, offset, length, 0, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, array, offset, length, 0, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, array, offset, length, 0, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        } else if (stride == 1) {
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, array, offset, length, 1, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, array, offset, length, 1, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, array, offset, length, 1, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, array, offset, length, 1, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        } else {
            assert (stride == 2);
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, array, offset, length, 2, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, array, offset, length, 2, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, array, offset, length, 2, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, array, offset, length, 2, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        }
        return TStringOps.runIndexOfAnyInt(location, array, offset, length, stride, fromIndex, values);
    }

    static int indexOfAnyIntRange(Node location, byte[] arrayA, long offsetA, int stride, int fromIndex, int toIndex, int[] ranges) {
        return TStringOps.indexOfAnyIntRangeIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, ranges);
    }

    private static int indexOfAnyIntRangeIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int[] ranges) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        if (stride == 0) {
            if (ranges.length == 2) {
                return TStringOps.runIndexOfRange1(location, array, offset, length, 0, isNative, fromIndex, ranges[0], ranges[1]);
            }
            if (ranges.length == 4) {
                return TStringOps.runIndexOfRange2(location, array, offset, length, 0, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
            }
        } else if (stride == 1) {
            if (ranges.length == 2) {
                return TStringOps.runIndexOfRange1(location, array, offset, length, 1, isNative, fromIndex, ranges[0], ranges[1]);
            }
            if (ranges.length == 4) {
                return TStringOps.runIndexOfRange2(location, array, offset, length, 1, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
            }
        } else {
            assert (stride == 2);
            if (ranges.length == 2) {
                return TStringOps.runIndexOfRange1(location, array, offset, length, 2, isNative, fromIndex, ranges[0], ranges[1]);
            }
            if (ranges.length == 4) {
                return TStringOps.runIndexOfRange2(location, array, offset, length, 2, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
            }
        }
        return TStringOps.runIndexOfAnyIntRange(location, array, offset, length, stride, fromIndex, ranges);
    }

    static int indexOfTable(Node location, byte[] arrayA, long offsetA, int stride, int fromIndex, int toIndex, byte[] tables) {
        return TStringOps.indexOfTableIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, tables);
    }

    private static int indexOfTableIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, byte[] tables) {
        boolean isNative;
        assert (tables.length == 32);
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        if (stride == 0) {
            return TStringOps.runIndexOfTable(location, array, offset, length, 0, isNative, fromIndex, tables);
        }
        if (stride == 1) {
            return TStringOps.runIndexOfTable(location, array, offset, length, 1, isNative, fromIndex, tables);
        }
        assert (stride == 2);
        return TStringOps.runIndexOfTable(location, array, offset, length, 2, isNative, fromIndex, tables);
    }

    static int indexOfCodePointWithStride(Node location, byte[] arrayA, long offsetA, int strideA, int fromIndex, int toIndex, int codepoint) {
        return TStringOps.indexOfCodePointWithStrideIntl(location, arrayA, offsetA, toIndex, strideA, fromIndex, codepoint);
    }

    private static int indexOfCodePointWithStrideIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int v1) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        switch (stride) {
            case 0: {
                return TStringOps.runIndexOfAny1(location, array, offset, length, 0, isNative, fromIndex, v1);
            }
            case 1: {
                return TStringOps.runIndexOfAny1(location, array, offset, length, 1, isNative, fromIndex, v1);
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOfAny1(location, array, offset, length, 2, isNative, fromIndex, v1);
    }

    static int indexOfCodePointWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, int strideA, int fromIndex, int toIndex, int codepoint, int maskA) {
        return TStringOps.indexOfCodePointWithMaskWithStrideIntl(location, arrayA, offsetA, toIndex, strideA, fromIndex, codepoint, maskA);
    }

    static int indexOfCodePointWithMaskWithStrideIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int v1, int mask1) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        switch (stride) {
            case 0: {
                return (v1 ^ mask1) <= 255 ? TStringOps.runIndexOfWithOrMaskWithStride(location, array, offset, length, 0, isNative, fromIndex, v1, mask1) : -1;
            }
            case 1: {
                return (v1 ^ mask1) <= 65535 ? TStringOps.runIndexOfWithOrMaskWithStride(location, array, offset, length, 1, isNative, fromIndex, v1, mask1) : -1;
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOfWithOrMaskWithStride(location, array, offset, length, 2, isNative, fromIndex, v1, mask1);
    }

    static int indexOf2ConsecutiveWithStride(Node location, byte[] arrayA, long offsetA, int strideA, int fromIndex, int toIndex, int v1, int v2) {
        return TStringOps.indexOf2ConsecutiveWithStrideIntl(location, arrayA, offsetA, toIndex, strideA, fromIndex, v1, v2);
    }

    private static int indexOf2ConsecutiveWithStrideIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int v1, int v2) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        switch (stride) {
            case 0: {
                return (v1 | v2) <= 255 ? TStringOps.runIndexOf2ConsecutiveWithStride(location, array, offset, length, 0, isNative, fromIndex, v1, v2) : -1;
            }
            case 1: {
                return (v1 | v2) <= 65535 ? TStringOps.runIndexOf2ConsecutiveWithStride(location, array, offset, length, 1, isNative, fromIndex, v1, v2) : -1;
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOf2ConsecutiveWithStride(location, array, offset, length, 2, isNative, fromIndex, v1, v2);
    }

    private static int indexOf2ConsecutiveWithOrMaskWithStrideIntl(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int v1, int v2, int mask1, int mask2) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, length, stride, fromIndex));
        switch (stride) {
            case 0: {
                return (v1 ^ mask1 | v2 ^ mask2) <= 255 ? TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, array, offset, length, 0, isNative, fromIndex, v1, v2, mask1, mask2) : -1;
            }
            case 1: {
                return (v1 ^ mask1 | v2 ^ mask2) <= 65535 ? TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, array, offset, length, 1, isNative, fromIndex, v1, v2, mask1, mask2) : -1;
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, array, offset, length, 2, isNative, fromIndex, v1, v2, mask1, mask2);
    }

    static int indexOfStringWithOrMaskWithStride(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, int strideA, AbstractTruffleString b, byte[] arrayB, long offsetB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        return TStringOps.indexOfStringWithOrMaskWithStride(location, arrayA, offsetA, a.length(), strideA, arrayB, offsetB, b.length(), strideB, fromIndex, toIndex, maskB);
    }

    static int indexOfStringWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, int lengthA, int strideA, byte[] arrayB, long offsetB, int lengthB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        int mask1;
        int offsetMask = TStringUnsafe.byteArrayBaseOffset();
        assert (lengthB > 1);
        assert (lengthA >= lengthB);
        int max = toIndex - (lengthB - 2);
        int index = fromIndex;
        int b0 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 0);
        int b1 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 1);
        int mask0 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, 0);
        int n = mask1 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, 1);
        while (index < max - 1) {
            index = maskB == null ? TStringOps.indexOf2ConsecutiveWithStrideIntl(location, arrayA, offsetA, max, strideA, index, b0, b1) : TStringOps.indexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, offsetA, max, strideA, index, b0, b1, mask0, mask1);
            if (index < 0) {
                return -1;
            }
            if (lengthB == 2 || TStringOps.regionEqualsWithOrMaskWithStrideIntl(location, arrayA, offsetA, lengthA, strideA, index, arrayB, offsetB, lengthB, strideB, 0, maskB, lengthB)) {
                return index;
            }
            TStringConstants.truffleSafePointPoll(location, ++index);
        }
        return -1;
    }

    static int lastIndexOfCodePointWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, int stride, int fromIndex, int toIndex, int codepoint, int mask) {
        return TStringOps.lastIndexOfCodePointWithOrMaskWithStrideIntl(location, arrayA, offsetA, stride, fromIndex, toIndex, codepoint, mask);
    }

    private static int lastIndexOfCodePointWithOrMaskWithStrideIntl(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int codepoint, int mask) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, fromIndex, stride, toIndex));
        switch (stride) {
            case 0: {
                return TStringOps.runLastIndexOfWithOrMaskWithStride(location, array, offset, 0, fromIndex, toIndex, codepoint, mask);
            }
            case 1: {
                return TStringOps.runLastIndexOfWithOrMaskWithStride(location, array, offset, 1, fromIndex, toIndex, codepoint, mask);
            }
        }
        assert (stride == 2);
        return TStringOps.runLastIndexOfWithOrMaskWithStride(location, array, offset, 2, fromIndex, toIndex, codepoint, mask);
    }

    static int lastIndexOf2ConsecutiveWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, int stride, int fromIndex, int toIndex, int v1, int v2, int mask1, int mask2) {
        return TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, offsetA, stride, fromIndex, toIndex, v1, v2, mask1, mask2);
    }

    private static int lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int v1, int v2, int mask1, int mask2) {
        assert (TStringOps.validateRegionIndexWithBaseOffset(array, offset, fromIndex, stride, toIndex));
        switch (stride) {
            case 0: {
                return TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, array, offset, 0, fromIndex, toIndex, v1, v2, mask1, mask2);
            }
            case 1: {
                return TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, array, offset, 1, fromIndex, toIndex, v1, v2, mask1, mask2);
            }
        }
        assert (stride == 2);
        return TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, array, offset, 2, fromIndex, toIndex, v1, v2, mask1, mask2);
    }

    static int lastIndexOfStringWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, int lengthA, int strideA, byte[] arrayB, long offsetB, int lengthB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        int offsetMask = TStringUnsafe.byteArrayBaseOffset();
        assert (lengthB > 1);
        assert (lengthA >= lengthB);
        int index = fromIndex;
        int b0 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, lengthB - 2);
        int b1 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, lengthB - 1);
        int mask0 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, lengthB - 2);
        int mask1 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, lengthB - 1);
        int toIndex2Consecutive = toIndex + lengthB - 2;
        while (index > toIndex2Consecutive) {
            if ((index = TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, offsetA, strideA, index, toIndex2Consecutive, b0, b1, mask0, mask1)) < 0) {
                return -1;
            }
            if (lengthB == 2 || TStringOps.regionEqualsWithOrMaskWithStrideIntl(location, arrayA, offsetA, lengthA, strideA, (index += 2) - lengthB, arrayB, offsetB, lengthB, strideB, 0, maskB, lengthB)) {
                return index - lengthB;
            }
            TStringConstants.truffleSafePointPoll(location, --index);
        }
        return -1;
    }

    static boolean regionEqualsWithOrMaskWithStride(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, int strideA, int fromIndexA, AbstractTruffleString b, byte[] arrayB, long offsetB, int strideB, int fromIndexB, byte[] maskB, int lengthCMP) {
        return TStringOps.regionEqualsWithOrMaskWithStrideIntl(location, arrayA, offsetA, a.length(), strideA, fromIndexA, arrayB, offsetB, b.length(), strideB, fromIndexB, maskB, lengthCMP);
    }

    private static boolean regionEqualsWithOrMaskWithStrideIntl(Node location, byte[] arrayA, long offsetA, int lengthA, int strideA, int fromIndexA, byte[] arrayB, long offsetB, int lengthB, int strideB, int fromIndexB, byte[] maskB, int lengthCMP) {
        if (!TStringOps.rangeInBounds(fromIndexA, lengthCMP, lengthA) || !TStringOps.rangeInBounds(fromIndexB, lengthCMP, lengthB)) {
            return false;
        }
        boolean isNativeA = arrayA == null;
        boolean isNativeB = arrayB == null;
        long combinedOffsetA = offsetA + ((long)fromIndexA << strideA);
        long combinedOffsetB = offsetB + ((long)fromIndexB << strideB);
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, combinedOffsetA, lengthCMP, strideA));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, combinedOffsetB, lengthCMP, strideB));
        int stubStride = TStringOps.stubStride(strideA, strideB);
        if (maskB == null) {
            return TStringOps.runRegionEqualsWithStride(location, arrayA, combinedOffsetA, isNativeA, arrayB, combinedOffsetB, isNativeB, lengthCMP, stubStride);
        }
        assert (TStringOps.validateRegion(maskB, 0L, lengthCMP, strideB));
        return TStringOps.runRegionEqualsWithOrMaskWithStride(location, arrayA, combinedOffsetA, isNativeA, arrayB, combinedOffsetB, isNativeB, maskB, lengthCMP, stubStride);
    }

    static int memcmpWithStride(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, int strideA, AbstractTruffleString b, byte[] arrayB, long offsetB, int strideB, int lengthCMP) {
        assert (lengthCMP <= a.length());
        assert (lengthCMP <= b.length());
        return TStringOps.memcmpWithStrideIntl(location, arrayA, offsetA, strideA, arrayB, offsetB, strideB, lengthCMP);
    }

    private static int memcmpWithStrideIntl(Node location, byte[] arrayA, long offsetA, int strideA, byte[] arrayB, long offsetB, int strideB, int lengthCMP) {
        boolean isNativeB;
        if (lengthCMP == 0) {
            return 0;
        }
        boolean isNativeA = arrayA == null;
        boolean bl = isNativeB = arrayB == null;
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, offsetA, lengthCMP, strideA));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, offsetB, lengthCMP, strideB));
        return TStringOps.runMemCmp(location, arrayA, offsetA, isNativeA, arrayB, offsetB, isNativeB, lengthCMP, TStringOps.stubStride(strideA, strideB));
    }

    static int memcmpBytesWithStride(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, int strideA, AbstractTruffleString b, byte[] arrayB, long offsetB, int strideB, int lengthCMP) {
        assert (lengthCMP <= a.length());
        assert (lengthCMP <= b.length());
        return TStringOps.memcmpBytesWithStrideIntl(location, arrayA, offsetA, strideA, arrayB, offsetB, strideB, lengthCMP);
    }

    private static int memcmpBytesWithStrideIntl(Node location, byte[] arrayA, long offsetA, int strideA, byte[] arrayB, long offsetB, int strideB, int lengthCMP) {
        int swappedResult;
        boolean swappedIsNativeB;
        boolean swappedIsNativeA;
        long swappedOffsetB;
        long swappedOffsetA;
        byte[] swappedArrayB;
        byte[] swappedArrayA;
        int swappedStrideB;
        int swappedStrideA;
        boolean isNativeB;
        if (lengthCMP == 0) {
            return 0;
        }
        boolean isNativeA = arrayA == null;
        boolean bl = isNativeB = arrayB == null;
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, offsetA, lengthCMP, strideA));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, offsetB, lengthCMP, strideB));
        if (strideA == strideB) {
            switch (strideA) {
                case 0: {
                    return TStringOps.runMemCmp(location, arrayA, offsetA, isNativeA, arrayB, offsetB, isNativeB, lengthCMP, 0);
                }
                case 1: {
                    return TStringOps.runMemCmpBytes(location, arrayA, offsetA, 1, isNativeA, arrayB, offsetB, 1, isNativeB, lengthCMP);
                }
            }
            assert (strideA == 2);
            return TStringOps.runMemCmpBytes(location, arrayA, offsetA, 2, isNativeA, arrayB, offsetB, 2, isNativeB, lengthCMP);
        }
        if (strideA < strideB) {
            swappedStrideA = strideB;
            swappedStrideB = strideA;
            swappedArrayA = arrayB;
            swappedArrayB = arrayA;
            swappedOffsetA = offsetB;
            swappedOffsetB = offsetA;
            swappedIsNativeA = isNativeB;
            swappedIsNativeB = isNativeA;
            swappedResult = -1;
        } else {
            swappedStrideA = strideA;
            swappedStrideB = strideB;
            swappedArrayA = arrayA;
            swappedArrayB = arrayB;
            swappedOffsetA = offsetA;
            swappedOffsetB = offsetB;
            swappedIsNativeA = isNativeA;
            swappedIsNativeB = isNativeB;
            swappedResult = 1;
        }
        if (swappedStrideA == 1) {
            assert (swappedStrideB == 0);
            return swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 1, swappedIsNativeA, swappedArrayB, swappedOffsetB, 0, swappedIsNativeB, lengthCMP);
        }
        assert (swappedStrideA == 2);
        if (swappedStrideB == 0) {
            return swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 2, swappedIsNativeA, swappedArrayB, swappedOffsetB, 0, swappedIsNativeB, lengthCMP);
        }
        assert (swappedStrideB == 1);
        return swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 2, swappedIsNativeA, swappedArrayB, swappedOffsetB, 1, swappedIsNativeB, lengthCMP);
    }

    static int hashCodeWithStride(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, int stride) {
        int length = a.length();
        return TStringOps.hashCodeWithStrideIntl(location, arrayA, offsetA, length, stride);
    }

    private static int hashCodeWithStrideIntl(Node location, byte[] array, long offset, int length, int stride) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, stride));
        switch (stride) {
            case 0: {
                return TStringOps.runHashCode(location, array, offset, length, 0, isNative);
            }
            case 1: {
                return TStringOps.runHashCode(location, array, offset, length, 1, isNative);
            }
        }
        assert (stride == 2);
        return TStringOps.runHashCode(location, array, offset, length, 2, isNative);
    }

    static byte[] arraycopyWithStrideCB(Node location, char[] arrayA, long offsetA, byte[] arrayB, long offsetB, int strideB, int lengthCPY) {
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, offsetA, lengthCPY));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, offsetB, lengthCPY, strideB));
        TStringOps.runArrayCopy(location, arrayA, offsetA, arrayB, offsetB, lengthCPY, TStringOps.stubStride(1, strideB));
        return arrayB;
    }

    static byte[] arraycopyWithStrideIB(Node location, int[] arrayA, long offsetA, byte[] arrayB, long offsetB, int strideB, int lengthCPY) {
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, offsetA, lengthCPY));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, offsetB, lengthCPY, strideB));
        TStringOps.runArrayCopy(location, arrayA, offsetA, arrayB, offsetB, lengthCPY, TStringOps.stubStride(2, strideB));
        return arrayB;
    }

    static byte[] arraycopyWithStride(Node location, byte[] arrayA, long offsetA, int strideA, int fromIndexA, byte[] arrayB, long offsetB, int strideB, int fromIndexB, int lengthCPY) {
        boolean isNativeA = arrayA == null;
        boolean isNativeB = arrayB == null;
        long combinedOffsetA = offsetA + ((long)fromIndexA << strideA);
        long combinedOffsetB = offsetB + ((long)fromIndexB << strideB);
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, combinedOffsetA, lengthCPY, strideA));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, combinedOffsetB, lengthCPY, strideB));
        TStringOps.runArrayCopy(location, arrayA, combinedOffsetA, isNativeA, arrayB, combinedOffsetB, isNativeB, lengthCPY, TStringOps.stubStride(strideA, strideB));
        return arrayB;
    }

    static byte[] arraycopyOfWithStride(Node location, byte[] arrayA, long offsetA, int lengthA, int strideA, int lengthB, int strideB) {
        byte[] dst = new byte[lengthB << strideB];
        TStringOps.arraycopyWithStride(location, arrayA, offsetA, strideA, 0, dst, TStringUnsafe.byteArrayBaseOffset(), strideB, 0, lengthA);
        return dst;
    }

    static Object byteSwapS1(Node location, byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, int lengthCPY) {
        boolean isNativeB;
        boolean isNativeA = arrayA == null;
        boolean bl = isNativeB = arrayB == null;
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, offsetA, lengthCPY, 1));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, offsetB, lengthCPY, 1));
        TStringOps.runByteSwapS1(location, arrayA, offsetA, isNativeA, arrayB, offsetB, isNativeB, lengthCPY);
        return arrayB;
    }

    static Object byteSwapS2(Node location, byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, int lengthCPY) {
        boolean isNativeB;
        boolean isNativeA = arrayA == null;
        boolean bl = isNativeB = arrayB == null;
        assert (TStringOps.validateRegionWithBaseOffset(arrayA, offsetA, lengthCPY, 2));
        assert (TStringOps.validateRegionWithBaseOffset(arrayB, offsetB, lengthCPY, 2));
        TStringOps.runByteSwapS2(location, arrayA, offsetA, isNativeA, arrayB, offsetB, isNativeB, lengthCPY);
        return arrayB;
    }

    static int calcStringAttributesLatin1(Node location, byte[] array, long offset, int length) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 0));
        return TStringOps.runCalcStringAttributesLatin1(location, array, offset, length, isNative);
    }

    static int calcStringAttributesBMP(Node location, byte[] array, long offset, int length) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 1));
        return TStringOps.runCalcStringAttributesBMP(location, array, offset, length, isNative);
    }

    static long calcStringAttributesUTF8(Node location, byte[] array, long offset, int length, boolean assumeValid, boolean isAtEnd, InlinedConditionProfile brokenProfile) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 0));
        if (assumeValid && !Encodings.isUTF8ContinuationByte(TStringOps.readS0(array, offset, length, 0)) && (isAtEnd || !Encodings.isUTF8ContinuationByte(TStringOps.readS0(array, offset, length + 1, length)))) {
            return TStringOps.runCalcStringAttributesUTF8(location, array, offset, length, isNative, true);
        }
        return TStringOps.calcStringAttributesUTF8Invalid(location, array, offset, length, brokenProfile, isNative);
    }

    @HostCompilerDirectives.InliningCutoff
    private static long calcStringAttributesUTF8Invalid(Node location, byte[] array, long offset, int length, InlinedConditionProfile brokenProfile, boolean isNative) {
        long attrs = TStringOps.runCalcStringAttributesUTF8(location, array, offset, length, isNative, false);
        if (brokenProfile.profile(location, TStringGuards.isBrokenMultiByte(StringAttributes.getCodeRange(attrs)))) {
            int codePointLength = 0;
            for (int i = 0; i < length; i += Encodings.utf8GetCodePointLength(array, offset, length, i, DecodingErrorHandler.DEFAULT)) {
                TStringConstants.truffleSafePointPoll(location, ++codePointLength);
            }
            return StringAttributes.create(codePointLength, StringAttributes.getCodeRange(attrs));
        }
        return attrs;
    }

    static long calcStringAttributesUTF16C(Node location, char[] array, long offset, int length) {
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length));
        return TStringOps.runCalcStringAttributesUTF16C(location, array, offset, length);
    }

    static long calcStringAttributesUTF16(Node location, byte[] array, long offset, int length, boolean assumeValid) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 1));
        long attrs = assumeValid ? TStringOps.runCalcStringAttributesUTF16(location, array, offset, length, isNative, true) : TStringOps.runCalcStringAttributesUTF16(location, array, offset, length, isNative, false);
        if (assumeValid && length > 0) {
            if (Encodings.isUTF16LowSurrogate(TStringOps.readS1(array, offset, length, 0))) {
                attrs = StringAttributes.create(StringAttributes.getCodePointLength(attrs), TSCodeRange.getBrokenMultiByte());
            }
            if (Encodings.isUTF16HighSurrogate(TStringOps.readS1(array, offset, length, length - 1))) {
                attrs = StringAttributes.create(StringAttributes.getCodePointLength(attrs) + 1, TSCodeRange.getBrokenMultiByte());
            }
        }
        return attrs;
    }

    @HostCompilerDirectives.InliningCutoff
    static long calcStringAttributesUTF16FE(Node location, byte[] array, long offset, int length) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 1));
        return TStringOps.runCalcStringAttributesUTF16FE(location, array, offset, length, isNative);
    }

    static int calcStringAttributesUTF32I(Node location, int[] array, long offset, int length) {
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length));
        return TStringOps.runCalcStringAttributesUTF32I(location, array, offset, length);
    }

    static int calcStringAttributesUTF32(Node location, byte[] array, long offset, int length) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 2));
        return TStringOps.runCalcStringAttributesUTF32(location, array, offset, length, isNative);
    }

    @HostCompilerDirectives.InliningCutoff
    static int calcStringAttributesUTF32FE(Node location, byte[] array, long offset, int length) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 2));
        return TStringOps.runCalcStringAttributesUTF32FE(location, array, offset, length, isNative);
    }

    static int codePointIndexToByteIndexUTF8Valid(Node location, byte[] array, long offset, int length, int index) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 0));
        return TStringOps.runCodePointIndexToByteIndexUTF8Valid(location, array, offset, length, index, isNative);
    }

    static int codePointIndexToByteIndexUTF16Valid(Node location, byte[] array, long offset, int length, int index) {
        boolean isNative;
        boolean bl = isNative = array == null;
        assert (TStringOps.validateRegionWithBaseOffset(array, offset, length, 1));
        return TStringOps.runCodePointIndexToByteIndexUTF16Valid(location, array, offset, length, index, isNative);
    }

    private static int runIndexOfAnyByte(Node location, byte[] array, long offset, int length, int fromIndex, byte ... needle) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValueS0(array, offset, i);
            for (int j = 0; j < needle.length; ++j) {
                if (value == TStringOps.uInt(needle[j])) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyChar(Node location, byte[] array, long offset, int length, int stride, int fromIndex, char ... needle) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            for (int j = 0; j < needle.length; ++j) {
                if (value == needle[j]) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyInt(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int ... needle) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            for (int j = 0; j < needle.length; ++j) {
                if (value == needle[j]) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyIntRange(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int ... ranges) {
        for (int i = fromIndex; i < length; ++i) {
            for (int j = 0; j < ranges.length; j += 2) {
                if (TStringOps.inRange(ranges[j], ranges[j + 1], TStringOps.readValue(array, offset, stride, i))) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static boolean inRange(int lo, int hi, int v) {
        return Integer.compareUnsigned(lo, v) <= 0 && Integer.compareUnsigned(v, hi) <= 0;
    }

    private static int runIndexOfAny1(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0) {
        for (int i = fromIndex; i < length; ++i) {
            if (TStringOps.readValue(array, offset, stride, i) == v0) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAny2(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value == v0 || value == v1) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAny3(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value == v0 || value == v1 || value == v2) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAny4(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2, int v3) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value == v0 || value == v1 || value == v2 || value == v3) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfRange1(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1) {
        for (int i = fromIndex; i < length; ++i) {
            if (TStringOps.inRange(v0, v1, TStringOps.readValue(array, offset, stride, i))) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfRange2(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2, int v3) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (TStringOps.inRange(v0, v1, value) || TStringOps.inRange(v2, v3, value)) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfTable(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, byte[] tables) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value <= 255 && TStringOps.performTableLookup(tables, value)) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static boolean performTableLookup(byte[] tables, int value) {
        int tableLo;
        int tableHi = TStringOps.uInt(tables[value >>> 4 & 0xF]);
        return (tableHi & (tableLo = TStringOps.uInt(tables[16 + (value & 0xF)]))) != 0;
    }

    private static int runIndexOfWithOrMaskWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int needle, int mask) {
        for (int i = fromIndex; i < length; ++i) {
            if ((TStringOps.readValue(array, offset, stride, i) | mask) == needle) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runLastIndexOfWithOrMaskWithStride(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int needle, int mask) {
        for (int i = fromIndex - 1; i >= toIndex; --i) {
            if ((TStringOps.readValue(array, offset, stride, i) | mask) == needle) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int c1, int c2) {
        for (int i = fromIndex + 1; i < length; ++i) {
            if (TStringOps.readValue(array, offset, stride, i - 1) == c1 && TStringOps.readValue(array, offset, stride, i) == c2) {
                return i - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithOrMaskWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int c1, int c2, int mask1, int mask2) {
        for (int i = fromIndex + 1; i < length; ++i) {
            if ((TStringOps.readValue(array, offset, stride, i - 1) | mask1) == c1 && (TStringOps.readValue(array, offset, stride, i) | mask2) == c2) {
                return i - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static int runLastIndexOf2ConsecutiveWithOrMaskWithStride(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int c1, int c2, int mask1, int mask2) {
        for (int i = fromIndex - 1; i > toIndex; --i) {
            if ((TStringOps.readValue(array, offset, stride, i - 1) | mask1) == c1 && (TStringOps.readValue(array, offset, stride, i) | mask2) == c2) {
                return i - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static boolean runRegionEqualsWithStride(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int length, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < length; ++i) {
            if (TStringOps.readValue(arrayA, offsetA, strideA, i) != TStringOps.readValue(arrayB, offsetB, strideB, i)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static boolean runRegionEqualsWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, byte[] arrayMask, int lengthCMP, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < lengthCMP; ++i) {
            if ((TStringOps.readValue(arrayA, offsetA, strideA, i) | TStringOps.readFromByteArray(arrayMask, strideB, i)) != TStringOps.readValue(arrayB, offsetB, strideB, i)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static int runMemCmp(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int lengthCMP, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < lengthCMP; ++i) {
            int cmp = TStringOps.readValue(arrayA, offsetA, strideA, i) - TStringOps.readValue(arrayB, offsetB, strideB, i);
            if (cmp != 0) {
                return cmp;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return 0;
    }

    private static int runMemCmpBytes(Node location, byte[] arrayA, long offsetA, int strideA, boolean isNativeA, byte[] arrayB, long offsetB, int strideB, boolean isNativeB, int lengthCMP) {
        assert (strideA >= strideB);
        for (int i = 0; i < lengthCMP; ++i) {
            int valueA = TStringOps.readValue(arrayA, offsetA, strideA, i);
            int valueB = TStringOps.readValue(arrayB, offsetB, strideB, i);
            for (int j = 0; j < 4; ++j) {
                int cmp;
                if (TStringGuards.littleEndian()) {
                    cmp = (valueA & 0xFF) - (valueB & 0xFF);
                    valueA >>= 8;
                    valueB >>= 8;
                } else {
                    cmp = (valueA >> 24 & 0xFF) - (valueB >> 24 & 0xFF);
                    valueA <<= 8;
                    valueB <<= 8;
                }
                if (cmp == 0) continue;
                return cmp;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return 0;
    }

    private static int runHashCode(Node location, byte[] array, long offset, int length, int stride, boolean isNative) {
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + TStringOps.readValue(array, offset, stride, i);
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return hash;
    }

    private static void runArrayCopy(Node location, char[] arrayA, long offsetA, byte[] arrayB, long offsetB, int lengthCPY, int stubStride) {
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        int charOffsetA = (int)(offsetA - (long)Unsafe.ARRAY_CHAR_BASE_OFFSET >> 1);
        for (int i = 0; i < lengthCPY; ++i) {
            TStringOps.writeValue(arrayB, offsetB, strideB, i, arrayA[charOffsetA + i]);
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runArrayCopy(Node location, int[] arrayA, long offsetA, byte[] arrayB, long offsetB, int lengthCPY, int stubStride) {
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        int intOffsetA = (int)(offsetA - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2);
        for (int i = 0; i < lengthCPY; ++i) {
            TStringOps.writeValue(arrayB, offsetB, strideB, i, arrayA[intOffsetA + i]);
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runArrayCopy(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int lengthCPY, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < lengthCPY; ++i) {
            TStringOps.writeValue(arrayB, offsetB, strideB, i, TStringOps.readValue(arrayA, offsetA, strideA, i));
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runByteSwapS1(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int length) {
        for (int i = 0; i < length; ++i) {
            TStringOps.writeValue(arrayB, offsetB, 1, i, Character.reverseBytes(TStringOps.readValueS1(arrayA, offsetA, i)));
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runByteSwapS2(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int length) {
        for (int i = 0; i < length; ++i) {
            TStringOps.writeValue(arrayB, offsetB, 2, i, Integer.reverseBytes(TStringOps.readValueS2(arrayA, offsetA, i)));
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static int runCalcStringAttributesLatin1(Node location, byte[] array, long offset, int length, boolean isNative) {
        for (int i = 0; i < length; ++i) {
            if (TStringOps.readValueS0(array, offset, i) > 127) {
                return TSCodeRange.get8Bit();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return TSCodeRange.get7Bit();
    }

    private static int runCalcStringAttributesBMP(Node location, byte[] array, long offset, int length, boolean isNative) {
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (TStringOps.readValueS1(array, offset, i) > '\u007f') {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return TSCodeRange.get7Bit();
        }
        while (i < length) {
            if (TStringOps.readValueS1(array, offset, i) > '\u00ff') {
                return TSCodeRange.get16Bit();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        return TSCodeRange.get8Bit();
    }

    private static int runCalcStringAttributesUTF32I(Node location, int[] array, long offset, int length) {
        return TStringOps.runCalcStringAttributesUTF32AnyArray(location, array, offset, length);
    }

    private static int runCalcStringAttributesUTF32(Node location, byte[] array, long offset, int length, boolean isNative) {
        return TStringOps.runCalcStringAttributesUTF32AnyArray(location, array, offset, length);
    }

    private static int readValueS2I(Object array, long offset, int i) {
        if (array instanceof int[]) {
            return ((int[])array)[(int)(offset - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2) + i];
        }
        return TStringOps.readValueS2((byte[])array, offset, i);
    }

    private static int runCalcStringAttributesUTF32AnyArray(Node location, Object array, long offset, int length) {
        int value;
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (Integer.toUnsignedLong(TStringOps.readValueS2I(array, offset, i)) > 127L) {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return TSCodeRange.get7Bit();
        }
        while (i < length) {
            if (Integer.toUnsignedLong(TStringOps.readValueS2I(array, offset, i)) > 255L) {
                codeRange = TSCodeRange.get16Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.is16Bit(codeRange)) {
            return TSCodeRange.get8Bit();
        }
        while (i < length) {
            value = TStringOps.readValueS2I(array, offset, i);
            if (Integer.toUnsignedLong(value) > 65535L) {
                codeRange = TSCodeRange.getValidFixedWidth();
                break;
            }
            if (Encodings.isUTF16Surrogate(value)) {
                return TSCodeRange.getBrokenFixedWidth();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.isValid(codeRange)) {
            return TSCodeRange.get16Bit();
        }
        while (i < length) {
            value = TStringOps.readValueS2I(array, offset, i);
            if (!Encodings.isValidUnicodeCodepoint(value)) {
                return TSCodeRange.getBrokenFixedWidth();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        return TSCodeRange.getValidFixedWidth();
    }

    private static int runCalcStringAttributesUTF32FE(Node location, byte[] array, long offset, int length, boolean isNative) {
        for (int i = 0; i < length; ++i) {
            int value = Integer.reverseBytes(TStringOps.readValueS2(array, offset, i));
            if (!Encodings.isValidUnicodeCodepoint(value)) {
                return TSCodeRange.getBrokenMultiByte();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return TSCodeRange.getValidMultiByte();
    }

    private static long runCalcStringAttributesUTF8(Node location, byte[] array, long offset, int length, boolean isNative, boolean assumeValid) {
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (TStringOps.readValueS0(array, offset, i) > 127) {
                codeRange = TSCodeRange.getValidMultiByte();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.isValidMultiByte(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }
        int nCodePoints = i;
        if (assumeValid) {
            while (i < length) {
                if (!Encodings.isUTF8ContinuationByte(TStringOps.readValueS0(array, offset, i))) {
                    ++nCodePoints;
                }
                TStringConstants.truffleSafePointPoll(location, i + 1);
                ++i;
            }
            return StringAttributes.create(nCodePoints, TSCodeRange.getValidMultiByte());
        }
        int state = 0;
        while (i < length) {
            int b = TStringOps.readValueS0(array, offset, i);
            if (!Encodings.isUTF8ContinuationByte(b)) {
                ++nCodePoints;
            }
            byte type = Encodings.UTF_8_STATE_MACHINE[b];
            state = Encodings.UTF_8_STATE_MACHINE[256 + state + type];
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (state != 0) {
            codeRange = TSCodeRange.getBrokenMultiByte();
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static long runCalcStringAttributesUTF16C(Node location, char[] array, long offset, int length) {
        return TStringOps.runCalcStringAttributesUTF16AnyArray(location, array, offset, length, false);
    }

    private static long runCalcStringAttributesUTF16(Node location, byte[] array, long offset, int length, boolean isNative, boolean assumeValid) {
        return TStringOps.runCalcStringAttributesUTF16AnyArray(location, array, offset, length, assumeValid);
    }

    private static char readValueS1C(Object array, long offset, int i) {
        if (array instanceof char[]) {
            return ((char[])array)[(int)(offset - (long)Unsafe.ARRAY_CHAR_BASE_OFFSET >> 1) + i];
        }
        return TStringOps.readValueS1((byte[])array, offset, i);
    }

    private static long runCalcStringAttributesUTF16AnyArray(Node location, Object array, long offset, int length, boolean assumeValid) {
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (TStringOps.readValueS1C(array, offset, i) > '\u007f') {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }
        while (i < length) {
            if (TStringOps.readValueS1C(array, offset, i) > '\u00ff') {
                codeRange = TSCodeRange.get16Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.is16Bit(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get8Bit());
        }
        while (i < length) {
            char c = TStringOps.readValueS1C(array, offset, i);
            if (assumeValid ? Encodings.isUTF16HighSurrogate(c) : Encodings.isUTF16Surrogate(c)) {
                codeRange = TSCodeRange.getValidMultiByte();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.isValidMultiByte(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get16Bit());
        }
        int nCodePoints = length;
        if (assumeValid) {
            while (i < length) {
                if (Encodings.isUTF16HighSurrogate(TStringOps.readValueS1C(array, offset, i))) {
                    --nCodePoints;
                }
                TStringConstants.truffleSafePointPoll(location, i + 1);
                ++i;
            }
            return StringAttributes.create(nCodePoints, TSCodeRange.getValidMultiByte());
        }
        while (i < length) {
            char c = TStringOps.readValueS1C(array, offset, i);
            if (Encodings.isUTF16Surrogate(c)) {
                if (Encodings.isUTF16LowSurrogate(c) || i + 1 >= length || !Encodings.isUTF16LowSurrogate(TStringOps.readValueS1C(array, offset, i + 1))) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    ++i;
                    --nCodePoints;
                }
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static long runCalcStringAttributesUTF16FE(Node location, byte[] array, long offset, int length, boolean isNative) {
        int codeRange = TSCodeRange.getValidMultiByte();
        int nCodePoints = length;
        for (int i = 0; i < length; ++i) {
            char c = Character.reverseBytes(TStringOps.readValueS1(array, offset, i));
            if (Encodings.isUTF16Surrogate(c)) {
                if (Encodings.isUTF16LowSurrogate(c) || i + 1 >= length || !Encodings.isUTF16LowSurrogate(Character.reverseBytes(TStringOps.readValueS1(array, offset, i + 1)))) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    ++i;
                    --nCodePoints;
                }
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static int runCodePointIndexToByteIndexUTF8Valid(Node location, byte[] array, long offset, int length, int index, boolean isNative) {
        int cpi = index;
        for (int i = 0; i < length; ++i) {
            if (!Encodings.isUTF8ContinuationByte(TStringOps.readValueS0(array, offset, i)) && --cpi < 0) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return cpi == 0 ? length : -1;
    }

    private static int runCodePointIndexToByteIndexUTF16Valid(Node location, byte[] array, long offset, int length, int index, boolean isNative) {
        int cpi = index;
        for (int i = 0; i < length; ++i) {
            if (!Encodings.isUTF16LowSurrogate(TStringOps.readValueS1(array, offset, i)) && --cpi < 0) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return cpi == 0 ? length : -1;
    }

    private static boolean rangeInBounds(int rangeStart, int rangeLength, int arrayLength) {
        return Integer.toUnsignedLong(rangeStart) + Integer.toUnsignedLong(rangeLength) <= (long)arrayLength;
    }

    private static int stubStride(int strideA, int strideB) {
        assert (Stride.isStride(strideA));
        assert (Stride.isStride(strideB));
        return strideA * 3 + strideB;
    }

    private static int stubStrideToStrideA(int stubStride) {
        assert (0 <= stubStride && stubStride < 9) : stubStride;
        return stubStride / 3;
    }

    private static int stubStrideToStrideB(int stubStride) {
        assert (0 <= stubStride && stubStride < 9) : stubStride;
        return stubStride % 3;
    }

    private static int uInt(byte value) {
        return Byte.toUnsignedInt(value);
    }

    static boolean validateRegion(byte[] array, long offset, int length, int stride) {
        assert (TStringOps.validRegion(array, offset, length, stride)) : String.format("array.length: %d, offset: %d, length: %d, stride: %d", array.length, offset, length, stride);
        return true;
    }

    static boolean validateRegionWithBaseOffset(byte[] array, long offset, int length, int stride) {
        assert (TStringOps.validRegionWithBaseOffset(array, offset, length, stride)) : String.format("array.length: %d, offset: %d, length: %d, stride: %d", array.length, offset, length, stride);
        return true;
    }

    private static boolean validateRegionWithBaseOffset(char[] array, long offset, int length) {
        long charOffset = offset - (long)Unsafe.ARRAY_CHAR_BASE_OFFSET >> 1;
        assert (Long.compareUnsigned(charOffset + Integer.toUnsignedLong(length), array.length) <= 0) : String.format("array.length: %d, offset: %d, length: %d", array.length, offset, length);
        return true;
    }

    private static boolean validateRegionWithBaseOffset(int[] array, long offset, int length) {
        long intOffset = offset - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2;
        assert (Long.compareUnsigned(intOffset + Integer.toUnsignedLong(length), array.length) <= 0) : String.format("array.length: %d, offset: %d, length: %d", array.length, offset, length);
        return true;
    }

    private static boolean validateRegionIndex(byte[] array, long offset, int length, int stride, int i) {
        assert (TStringOps.validRegionIndex(array, offset, length, stride, i)) : String.format("array.length: %d, offset: %d, length: %d, stride: %d, i: %d", array.length, offset, length, stride, i);
        return true;
    }

    private static boolean validateRegionIndexWithBaseOffset(byte[] array, long offset, int length, int stride, int i) {
        assert (TStringOps.validRegionIndexWithBaseOffset(array, offset, length, stride, i)) : String.format("array.length: %d, offset: %d, length: %d, stride: %d, i: %d", array.length, offset, length, stride, i);
        return true;
    }

    private static boolean validRegion(byte[] array, long offset, int length, int stride) {
        return TStringOps.validOffsetOrLength(array, offset, length, stride);
    }

    private static boolean validRegionWithBaseOffset(byte[] array, long offset, int length, int stride) {
        return TStringOps.validOffsetOrLengthWithBaseOffset(array, offset, length, stride);
    }

    private static boolean validRegionIndex(byte[] array, long offset, int length, int stride, int i) {
        return TStringOps.validOffsetOrLength(array, offset, length, stride) && TStringOps.validIndex(length, i);
    }

    private static boolean validRegionIndexWithBaseOffset(byte[] array, long offset, int length, int stride, int i) {
        return TStringOps.validOffsetOrLengthWithBaseOffset(array, offset, length, stride) && TStringOps.validIndex(length, i);
    }

    private static boolean validOffsetOrLength(byte[] array, long offset, int length, int stride) {
        if (array == null) {
            return offset >= 0L && length >= 0;
        }
        return Long.compareUnsigned(offset + (Integer.toUnsignedLong(length) << stride), array.length) <= 0;
    }

    private static boolean validOffsetOrLengthWithBaseOffset(byte[] array, long offset, int length, int stride) {
        if (array == null) {
            return offset >= 0L && length >= 0;
        }
        return Long.compareUnsigned(offset - (long)TStringUnsafe.byteArrayBaseOffset() + (Integer.toUnsignedLong(length) << stride), array.length) <= 0;
    }

    private static boolean validIndex(int length, int i) {
        return Integer.compareUnsigned(i, length) < 0;
    }
}

