/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Assumption;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.CoreLayoutFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Layout;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LayoutStrategy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ShapeImpl;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platform;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platforms;

abstract class LayoutImpl
extends Layout {
    private static final int INT_TO_DOUBLE_FLAG = 1;
    private static final int INT_TO_LONG_FLAG = 2;
    protected final LayoutStrategy strategy;
    protected final Class<? extends DynamicObject> clazz;
    private final int allowedImplicitCasts;
    protected static final Map<Class<? extends DynamicObject>, Object> LAYOUT_INFO_MAP = new ConcurrentHashMap<Class<? extends DynamicObject>, Object>();
    protected static final Map<Key, LayoutImpl> LAYOUT_MAP = new ConcurrentHashMap<Key, LayoutImpl>();

    protected LayoutImpl(Class<? extends DynamicObject> clazz, LayoutStrategy strategy, int implicitCastFlags) {
        this.strategy = strategy;
        this.clazz = Objects.requireNonNull(clazz);
        this.allowedImplicitCasts = implicitCastFlags;
    }

    @Override
    public Class<? extends DynamicObject> getType() {
        return this.clazz;
    }

    @Override
    protected final Shape buildShape(Object dynamicType, Object sharedData, int flags, Assumption singleContextAssumption) {
        return this.newShape(dynamicType, sharedData, flags, null);
    }

    protected abstract ShapeImpl newShape(Object var1, Object var2, int var3, Assumption var4);

    public boolean isAllowedIntToDouble() {
        return (this.allowedImplicitCasts & 1) != 0;
    }

    public boolean isAllowedIntToLong() {
        return (this.allowedImplicitCasts & 2) != 0;
    }

    protected abstract boolean hasObjectExtensionArray();

    protected abstract boolean hasPrimitiveExtensionArray();

    protected abstract int getObjectFieldCount();

    protected abstract int getPrimitiveFieldCount();

    public abstract ShapeImpl.BaseAllocator createAllocator();

    public LayoutStrategy getStrategy() {
        return this.strategy;
    }

    public String toString() {
        return "Layout[" + this.clazz.getName() + "]";
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static void resetNativeImageState() {
        assert (ImageInfo.inImageBuildtimeCode()) : "Only supported during image generation";
        LAYOUT_MAP.clear();
        LAYOUT_INFO_MAP.clear();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static void initializeDynamicObjectLayout(Class<?> dynamicObjectClass, MethodHandles.Lookup lookup) {
        assert (ImageInfo.inImageBuildtimeCode()) : "Only supported during image generation";
        ((CoreLayoutFactory)LayoutImpl.getFactory()).registerLayoutClass(dynamicObjectClass.asSubclass(DynamicObject.class), lookup);
    }

    protected record Key(Class<? extends DynamicObject> type, int implicitCastFlags, LayoutStrategy strategy) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.type == other.type && this.implicitCastFlags == other.implicitCastFlags && this.strategy == other.strategy;
        }
    }
}

