/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.UnsafeAccess;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.CoreLocations;

final class FieldInfo
extends CoreLocations.DynamicObjectFieldLocation
implements Comparable<FieldInfo> {
    private static final boolean JDK21 = Runtime.version().feature() == 21;
    private static final int UNUSED_OFFSET = 0;
    private final long offset;
    private final Class<? extends DynamicObject> tclass;
    private final VarHandle varHandle;
    private final Class<?> type;
    private final String name;

    FieldInfo(Class<?> type, String name, long offset, Class<? extends DynamicObject> declaringClass, VarHandle varHandle) {
        super(JDK21 ? offset : 0L, declaringClass);
        if (type != Object.class && type != Integer.TYPE && type != Long.TYPE) {
            throw new IllegalArgumentException(type.getName());
        }
        this.offset = JDK21 ? 0L : offset;
        this.tclass = declaringClass;
        this.varHandle = varHandle;
        this.type = type;
        this.name = name;
    }

    static FieldInfo fromField(Field field, VarHandle varHandle) {
        return new FieldInfo(field.getType(), field.getName(), UnsafeAccess.objectFieldOffset(field), field.getDeclaringClass().asSubclass(DynamicObject.class), varHandle);
    }

    public Class<? extends DynamicObject> getDeclaringClass() {
        return this.tclass;
    }

    public long offset() {
        if (JDK21) {
            assert (((CoreLocations.DynamicObjectFieldLocation)this).offset != 0L);
            return ((CoreLocations.DynamicObjectFieldLocation)this).offset;
        }
        assert (this.offset != 0L);
        return this.offset;
    }

    public VarHandle varHandle() {
        return this.varHandle;
    }

    public Class<?> type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public int getBytes() {
        if (this.type == Long.TYPE) {
            return 8;
        }
        assert (this.type == Integer.TYPE);
        return 4;
    }

    public String toString() {
        return this.name + ":" + this.offset;
    }

    @Override
    public int compareTo(FieldInfo other) {
        return Long.compare(this.offset, other.offset);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Long.hashCode(this.offset);
        result = 31 * result + this.tclass.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldInfo)) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        return this.offset == other.offset && this.tclass == other.tclass;
    }

    void receiverCheck(DynamicObject store) {
        if (!this.tclass.isInstance(store)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw this.illegalReceiver(store);
        }
    }

    private IllegalArgumentException illegalReceiver(DynamicObject store) {
        CompilerAsserts.neverPartOfCompilation();
        return new IllegalArgumentException("Invalid receiver type (expected " + String.valueOf(this.getDeclaringClass()) + ", was " + String.valueOf(store == null ? null : store.getClass()) + ")");
    }
}

