/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Assumption;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLayout;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLocation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLocations;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.FieldInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Flags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LayoutImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Location;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ShapeImpl;
import sun.misc.Unsafe;

abstract class ExtAllocator
extends ShapeImpl.BaseAllocator {
    private static final Object NO_VALUE = new Object();

    ExtAllocator(LayoutImpl layout) {
        super(layout);
    }

    ExtAllocator(ShapeImpl shape) {
        super(shape);
    }

    private ExtLayout getLayout() {
        return (ExtLayout)this.layout;
    }

    @Override
    public ExtLocation constantLocation(Object value) {
        return new ExtLocations.ConstantLocation(value);
    }

    @Override
    public ExtLocation declaredLocation(Object value) {
        return new ExtLocations.DeclaredLocation(value);
    }

    @Override
    protected Location moveLocation(Location oldLocation) {
        boolean decorateFinal = false;
        if (oldLocation instanceof ExtLocations.IntLocation) {
            return this.newIntLocation(false, oldLocation, NO_VALUE);
        }
        if (oldLocation instanceof ExtLocations.DoubleLocation) {
            return this.newDoubleLocation(false, ((ExtLocations.DoubleLocation)((Object)oldLocation)).isImplicitCastIntToDouble(), oldLocation, NO_VALUE);
        }
        if (oldLocation instanceof ExtLocations.LongLocation) {
            return this.newLongLocation(false, ((ExtLocations.LongLocation)((Object)oldLocation)).isImplicitCastIntToLong(), oldLocation, NO_VALUE);
        }
        if (oldLocation instanceof ExtLocations.BooleanLocation) {
            return this.newBooleanLocation(false, oldLocation, NO_VALUE);
        }
        if (oldLocation instanceof ExtLocations.AbstractObjectFieldLocation) {
            return this.newObjectLocation(false, oldLocation, NO_VALUE);
        }
        if (oldLocation instanceof ExtLocations.AbstractObjectArrayLocation) {
            return this.newObjectLocation(false, oldLocation, NO_VALUE);
        }
        assert (oldLocation.isValue());
        return this.advance(oldLocation);
    }

    public Location newObjectLocation() {
        return this.newObjectLocation(false, null, NO_VALUE);
    }

    private Location newObjectLocation(boolean decorateFinal, Location oldLocation, Object value) {
        ExtLayout l;
        int insertPos;
        if (ExtLayout.InObjectFields && (insertPos = this.objectFieldSize) + 1 <= (l = this.getLayout()).getObjectFieldCount()) {
            FieldInfo fieldInfo = l.getObjectField(insertPos);
            ExtLocations.TypeAssumption initialTypeAssumption = ExtAllocator.getTypeAssumption(oldLocation, value);
            Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
            ExtLocations.AbstractObjectFieldLocation location = ExtAllocator.newObjectFieldLocationWithAssumption(insertPos, fieldInfo, initialTypeAssumption, initialFinalAssumption);
            return this.advance(location);
        }
        return this.newObjectArrayLocation(decorateFinal, oldLocation, value);
    }

    private Location newObjectArrayLocation(boolean decorateFinal, Location oldLocation, Object value) {
        int index = this.objectArraySize;
        ExtLocations.TypeAssumption initialTypeAssumption = ExtAllocator.getTypeAssumption(oldLocation, value);
        Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
        ExtLocations.AbstractObjectArrayLocation location = ExtAllocator.newObjectArrayLocationWithAssumption(index, initialTypeAssumption, initialFinalAssumption);
        return this.advance(location);
    }

    private Location newTypedObjectLocation(Class<?> type, boolean nonNull, boolean decorateFinal, Location oldLocation, Object value) {
        ExtLayout l;
        int insertPos;
        if (ExtLayout.InObjectFields && (insertPos = this.objectFieldSize) + 1 <= (l = this.getLayout()).getObjectFieldCount()) {
            FieldInfo fieldInfo = l.getObjectField(insertPos);
            ExtLocations.TypeAssumption initialTypeAssumption = ExtAllocator.getTypeAssumptionForTypeOrValue(type, nonNull, oldLocation, value);
            Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
            ExtLocations.AbstractObjectFieldLocation location = ExtAllocator.newObjectFieldLocationWithAssumption(insertPos, fieldInfo, initialTypeAssumption, initialFinalAssumption);
            return this.advance(location);
        }
        return this.newTypedObjectArrayLocation(type, nonNull, decorateFinal, oldLocation, value);
    }

    private Location newTypedObjectArrayLocation(Class<?> type, boolean nonNull, boolean decorateFinal, Location oldLocation, Object value) {
        if (type != Object.class) {
            int index = this.objectArraySize;
            ExtLocations.TypeAssumption initialTypeAssumption = ExtAllocator.getTypeAssumptionForTypeOrValue(type, nonNull, oldLocation, value);
            Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
            ExtLocations.AbstractObjectArrayLocation location = ExtAllocator.newObjectArrayLocationWithAssumption(index, initialTypeAssumption, initialFinalAssumption);
            return this.advance(location);
        }
        return this.newObjectArrayLocation(decorateFinal, oldLocation, value);
    }

    private static ExtLocations.AbstractObjectFieldLocation newObjectFieldLocationWithAssumption(int index, FieldInfo fieldInfo, ExtLocations.TypeAssumption initialTypeAssumption, Assumption initialFinalAssumption) {
        return new ExtLocations.ATypedObjectFieldLocation(index, fieldInfo, initialTypeAssumption, initialFinalAssumption);
    }

    private static ExtLocations.AbstractObjectArrayLocation newObjectArrayLocationWithAssumption(int index, ExtLocations.TypeAssumption initialTypeAssumption, Assumption initialFinalAssumption) {
        return new ExtLocations.ATypedObjectArrayLocation(index, initialTypeAssumption, initialFinalAssumption);
    }

    private static boolean allowTypeSpeculation(Location oldLocation, Object value) {
        return value != NO_VALUE && oldLocation == null || oldLocation instanceof ExtLocations.AbstractObjectLocation;
    }

    private static ExtLocations.TypeAssumption getTypeAssumption(Location oldLocation, Object value) {
        if (ExtLayout.NewTypeSpeculation && ExtAllocator.allowTypeSpeculation(oldLocation, value)) {
            if (value != NO_VALUE && oldLocation == null) {
                return ExtLocations.AbstractObjectLocation.createTypeAssumptionFromValue(value);
            }
            if (oldLocation instanceof ExtLocations.AbstractObjectLocation) {
                return ((ExtLocations.AbstractObjectLocation)oldLocation).getTypeAssumption();
            }
        }
        return ExtLocations.TypeAssumption.ANY;
    }

    private static ExtLocations.TypeAssumption getTypeAssumptionForTypeOrValue(Class<?> type, boolean nonNull, Location oldLocation, Object value) {
        if (!ExtLayout.NewTypeSpeculation && !ExtLayout.NewFinalSpeculation && value == NO_VALUE) {
            if (oldLocation instanceof ExtLocations.AbstractObjectLocation) {
                return ((ExtLocations.AbstractObjectLocation)oldLocation).getTypeAssumption();
            }
            return ExtLocations.AbstractObjectLocation.createTypeAssumption(type, nonNull);
        }
        return ExtAllocator.getTypeAssumption(oldLocation, value);
    }

    private static Assumption getFinalAssumption(Location oldLocation, boolean allowFinalSpeculation) {
        if (ExtLayout.NewFinalSpeculation && allowFinalSpeculation) {
            if (oldLocation == null) {
                return null;
            }
            if (oldLocation instanceof ExtLocations.InstanceLocation) {
                return ((ExtLocations.InstanceLocation)oldLocation).getFinalAssumptionField();
            }
        }
        return Assumption.NEVER_VALID;
    }

    private static int tryAllocatePrimitiveSlot(ExtLayout l, int startIndex, int desiredBytes) {
        if (desiredBytes > l.getPrimitiveFieldMaxSize()) {
            return -1;
        }
        for (int fieldIndex = startIndex; fieldIndex < l.getPrimitiveFieldCount(); ++fieldIndex) {
            int availableBytes;
            int align = desiredBytes - 1;
            FieldInfo fieldInfo = l.getPrimitiveField(fieldIndex);
            if ((fieldInfo.offset() & (long)align) != 0L || (availableBytes = fieldInfo.getBytes()) < desiredBytes) continue;
            return fieldIndex;
        }
        return -1;
    }

    private Location newIntLocation() {
        return this.newIntLocation(false, null, NO_VALUE);
    }

    private Location newIntLocation(boolean decorateFinal, Location oldLocation, Object value) {
        if (ExtLayout.PrimitiveLocations && ExtLayout.IntegerLocations) {
            int fieldIndex;
            ExtLayout l = this.getLayout();
            if (ExtLayout.InObjectFields && (fieldIndex = ExtAllocator.tryAllocatePrimitiveSlot(l, this.primitiveFieldSize, 4)) >= 0) {
                FieldInfo fieldInfo = l.getPrimitiveField(fieldIndex);
                Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
                ExtLocations.IntFieldLocation location = new ExtLocations.IntFieldLocation(fieldIndex, fieldInfo, initialFinalAssumption);
                return this.advance(location);
            }
            if (l.hasPrimitiveExtensionArray()) {
                int index = ExtAllocator.alignArrayIndex(this.primitiveArraySize, 1);
                Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
                ExtLocations.IntArrayLocation location = new ExtLocations.IntArrayLocation(index, initialFinalAssumption);
                return this.advance(location);
            }
        }
        return this.newObjectLocation(decorateFinal, oldLocation, value);
    }

    private Location newDoubleLocation() {
        return this.newDoubleLocation(false, this.getLayout().isAllowedIntToDouble(), null, NO_VALUE);
    }

    private Location newDoubleLocation(boolean decorateFinal, boolean allowIntToDouble, Location oldLocation, Object value) {
        if (ExtLayout.PrimitiveLocations && ExtLayout.DoubleLocations) {
            int fieldIndex;
            ExtLayout l = this.getLayout();
            if (ExtLayout.InObjectFields && (fieldIndex = ExtAllocator.tryAllocatePrimitiveSlot(l, this.primitiveFieldSize, 8)) >= 0) {
                FieldInfo fieldInfo = l.getPrimitiveField(fieldIndex);
                int slotCount = 8 / fieldInfo.getBytes();
                Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
                ExtLocations.DoubleFieldLocation location = new ExtLocations.DoubleFieldLocation(fieldIndex, fieldInfo, allowIntToDouble, slotCount, initialFinalAssumption);
                return this.advance(location);
            }
            if (l.hasPrimitiveExtensionArray()) {
                int index = ExtAllocator.alignArrayIndex(this.primitiveArraySize, 2);
                Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
                ExtLocations.DoubleArrayLocation location = new ExtLocations.DoubleArrayLocation(index, allowIntToDouble, initialFinalAssumption);
                return this.advance(location);
            }
        }
        return this.newObjectLocation(decorateFinal, oldLocation, value);
    }

    private static int alignArrayIndex(int index, int slotSize) {
        if (slotSize == 2) {
            if ((Unsafe.ARRAY_INT_BASE_OFFSET + Unsafe.ARRAY_INT_INDEX_SCALE * index) % 8 != 0) {
                return index + 1;
            }
            return index;
        }
        if (slotSize == 1) {
            return index;
        }
        throw new AssertionError(slotSize);
    }

    private Location newLongLocation() {
        return this.newLongLocation(false, this.getLayout().isAllowedIntToLong(), null, NO_VALUE);
    }

    private Location newLongLocation(boolean decorateFinal, boolean allowIntToLong, Location oldLocation, Object value) {
        if (ExtLayout.PrimitiveLocations && ExtLayout.LongLocations) {
            int fieldIndex;
            ExtLayout l = this.getLayout();
            if (ExtLayout.InObjectFields && (fieldIndex = ExtAllocator.tryAllocatePrimitiveSlot(l, this.primitiveFieldSize, 8)) >= 0) {
                FieldInfo fieldInfo = l.getPrimitiveField(fieldIndex);
                int slotCount = 8 / fieldInfo.getBytes();
                Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
                ExtLocations.LongFieldLocation location = new ExtLocations.LongFieldLocation(fieldIndex, fieldInfo, allowIntToLong, slotCount, initialFinalAssumption);
                return this.advance(location);
            }
            if (l.hasPrimitiveExtensionArray()) {
                int index = ExtAllocator.alignArrayIndex(this.primitiveArraySize, 2);
                Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
                ExtLocations.LongArrayLocation location = new ExtLocations.LongArrayLocation(index, allowIntToLong, initialFinalAssumption);
                return this.advance(location);
            }
        }
        return this.newObjectLocation(decorateFinal, oldLocation, value);
    }

    private Location newBooleanLocation() {
        return this.newBooleanLocation(false, null, NO_VALUE);
    }

    private Location newBooleanLocation(boolean decorateFinal, Location oldLocation, Object value) {
        FieldInfo fieldInfo;
        ExtLayout l;
        int fieldIndex;
        if (ExtLayout.PrimitiveLocations && ExtLayout.BooleanLocations && ExtLayout.InObjectFields && (fieldIndex = ExtAllocator.tryAllocatePrimitiveSlot(l = this.getLayout(), this.primitiveFieldSize, 4)) >= 0 && (fieldInfo = l.getPrimitiveField(fieldIndex)).type() == Integer.TYPE) {
            Assumption initialFinalAssumption = ExtAllocator.getFinalAssumption(oldLocation, decorateFinal);
            ExtLocations.BooleanFieldLocation location = new ExtLocations.BooleanFieldLocation(fieldIndex, fieldInfo, initialFinalAssumption);
            return this.advance(location);
        }
        return this.newObjectLocation(decorateFinal, oldLocation, value);
    }

    @Override
    protected Location locationForValueUpcast(Object value, Location oldLocation, int putFlags) {
        assert (!oldLocation.canStore(value));
        if (oldLocation instanceof ExtLocations.ConstantLocation && Flags.isConstant(putFlags)) {
            return this.constantLocation(value);
        }
        assert (!oldLocation.isFinal() && !(oldLocation instanceof ExtLocations.AbstractObjectLocation)) : oldLocation;
        boolean decorateFinal = false;
        Location newLocation = null;
        if (!this.shared && oldLocation instanceof ExtLocations.IntLocation) {
            boolean allowedIntToLong;
            boolean allowedIntToDouble = this.getLayout().isAllowedIntToDouble() || Flags.isImplicitCastIntToDouble(putFlags);
            boolean bl = allowedIntToLong = this.getLayout().isAllowedIntToLong() || Flags.isImplicitCastIntToLong(putFlags);
            if (value instanceof Double && allowedIntToDouble) {
                newLocation = this.newDoubleLocation(false, allowedIntToDouble, oldLocation, NO_VALUE);
            } else if (value instanceof Long && allowedIntToLong) {
                newLocation = this.newLongLocation(false, allowedIntToLong, oldLocation, NO_VALUE);
            }
        }
        if (newLocation == null) {
            newLocation = this.newObjectLocation(false, oldLocation, NO_VALUE);
        }
        return newLocation;
    }

    @Override
    public Location locationForValue(Object value) {
        return this.locationForValue(value, 0);
    }

    protected Location locationForValue(Object value, int putFlags) {
        if (Flags.isConstant(putFlags)) {
            return this.constantLocation(value);
        }
        if (Flags.isDeclaration(putFlags)) {
            return this.declaredLocation(value);
        }
        boolean decorateFinal = true;
        if (value instanceof Integer) {
            return this.newIntLocation(decorateFinal, null, value);
        }
        if (value instanceof Double) {
            return this.newDoubleLocation(decorateFinal, this.getLayout().isAllowedIntToDouble(), null, value);
        }
        if (value instanceof Long) {
            return this.newLongLocation(decorateFinal, this.getLayout().isAllowedIntToLong(), null, value);
        }
        if (value instanceof Boolean) {
            return this.newBooleanLocation(decorateFinal, null, value);
        }
        return this.newObjectLocation(decorateFinal, null, value);
    }

    @Override
    public Location locationForType(Class<?> type) {
        if (type == Integer.TYPE) {
            return this.newIntLocation();
        }
        if (type == Double.TYPE) {
            return this.newDoubleLocation();
        }
        if (type == Long.TYPE) {
            return this.newLongLocation();
        }
        if (type == Boolean.TYPE) {
            return this.newBooleanLocation();
        }
        if (type != null && type != Object.class) {
            assert (!type.isPrimitive()) : "unsupported primitive type";
            return this.newTypedObjectLocation(type, false, false, null, NO_VALUE);
        }
        return this.newObjectLocation();
    }

    static Class<?> getCommonSuperclass(Class<?> a, Class<?> b) {
        Class<?> type = a;
        while (type != Object.class && (type = type.getSuperclass()) != Object.class) {
            if (!type.isAssignableFrom(a) || !type.isAssignableFrom(b)) continue;
            return type;
        }
        return Object.class;
    }

    static Class<?> getCommonSuperclassForValue(Class<?> a, Object value) {
        Class<?> type = a;
        while (type != Object.class && (type = type.getSuperclass()) != Object.class) {
            if (!type.isAssignableFrom(a) || value != null && !type.isInstance(value)) continue;
            return type;
        }
        return Object.class;
    }
}

