/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.util.List;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LayoutImpl;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.hosted.Feature;

class DynamicObjectFeature
implements Feature {
    private static final String LAYOUT_IMPL_CLASS_NAME = "org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LayoutImpl";

    DynamicObjectFeature() {
    }

    @Override
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return access.findClassByName(LAYOUT_IMPL_CLASS_NAME) != null;
    }

    @Override
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Runtime.version().feature() == 21) {
            List<String> markAsReachable = List.of("org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.DefaultLayout", "org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.DefaultLayout$LayoutInfo");
            access.registerReachabilityHandler(acc -> markAsReachable.forEach(className -> acc.registerAsUsed(Objects.requireNonNull(access.findClassByName((String)className), className))), Objects.requireNonNull(access.findClassByName(LAYOUT_IMPL_CLASS_NAME)));
        }
    }

    @Override
    public void cleanup() {
        LayoutImpl.resetNativeImageState();
    }

    @Override
    public String getDescription() {
        return "Provides support for DynamicObject";
    }
}

