/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.ByteArrayOutOfBoundsException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.ByteArraySupport;

final class CheckedByteArraySupport
extends ByteArraySupport {
    final ByteArraySupport access;

    CheckedByteArraySupport(ByteArraySupport access) {
        this.access = access;
    }

    private void checkBounds(byte[] buffer, int startByteOffset, int length) {
        if (!this.inBounds(buffer, startByteOffset, length)) {
            throw new ByteArrayOutOfBoundsException();
        }
    }

    private void checkBounds(byte[] buffer, long startByteOffset, long length) {
        if (!this.inBounds(buffer, startByteOffset, length)) {
            throw new ByteArrayOutOfBoundsException();
        }
    }

    @Override
    public byte getByte(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1);
        return this.access.getByte(buffer, byteOffset);
    }

    @Override
    public byte getByte(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.getByte(buffer, byteOffset);
    }

    @Override
    public void putByte(byte[] buffer, int byteOffset, byte value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1);
        this.access.putByte(buffer, byteOffset, value);
    }

    @Override
    public void putByte(byte[] buffer, long byteOffset, byte value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        this.access.putByte(buffer, byteOffset, value);
    }

    @Override
    public short getShort(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2);
        return this.access.getShort(buffer, byteOffset);
    }

    @Override
    public short getShort(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getShort(buffer, byteOffset);
    }

    @Override
    public void putShort(byte[] buffer, int byteOffset, short value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2);
        this.access.putShort(buffer, byteOffset, value);
    }

    @Override
    public void putShort(byte[] buffer, long byteOffset, short value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        this.access.putShort(buffer, byteOffset, value);
    }

    @Override
    public int getInt(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4);
        return this.access.getInt(buffer, byteOffset);
    }

    @Override
    public int getInt(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getInt(buffer, byteOffset);
    }

    @Override
    public void putInt(byte[] buffer, int byteOffset, int value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4);
        this.access.putInt(buffer, byteOffset, value);
    }

    @Override
    public void putInt(byte[] buffer, long byteOffset, int value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        this.access.putInt(buffer, byteOffset, value);
    }

    @Override
    public long getLong(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8);
        return this.access.getLong(buffer, byteOffset);
    }

    @Override
    public long getLong(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getLong(buffer, byteOffset);
    }

    @Override
    public void putLong(byte[] buffer, int byteOffset, long value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8);
        this.access.putLong(buffer, byteOffset, value);
    }

    @Override
    public void putLong(byte[] buffer, long byteOffset, long value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        this.access.putLong(buffer, byteOffset, value);
    }

    @Override
    public float getFloat(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4);
        return this.access.getFloat(buffer, byteOffset);
    }

    @Override
    public float getFloat(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getFloat(buffer, byteOffset);
    }

    @Override
    public void putFloat(byte[] buffer, int byteOffset, float value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4);
        this.access.putFloat(buffer, byteOffset, value);
    }

    @Override
    public void putFloat(byte[] buffer, long byteOffset, float value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        this.access.putFloat(buffer, byteOffset, value);
    }

    @Override
    public double getDouble(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8);
        return this.access.getDouble(buffer, byteOffset);
    }

    @Override
    public double getDouble(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getDouble(buffer, byteOffset);
    }

    @Override
    public void putDouble(byte[] buffer, int byteOffset, double value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8);
        this.access.putDouble(buffer, byteOffset, value);
    }

    @Override
    public void putDouble(byte[] buffer, long byteOffset, double value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        this.access.putDouble(buffer, byteOffset, value);
    }

    @Override
    public short getShortUnaligned(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2);
        return this.access.getShortUnaligned(buffer, byteOffset);
    }

    @Override
    public short getShortUnaligned(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getShortUnaligned(buffer, byteOffset);
    }

    @Override
    public int getIntUnaligned(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4);
        return this.access.getIntUnaligned(buffer, byteOffset);
    }

    @Override
    public int getIntUnaligned(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getIntUnaligned(buffer, byteOffset);
    }

    @Override
    public long getLongUnaligned(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8);
        return this.access.getLongUnaligned(buffer, byteOffset);
    }

    @Override
    public long getLongUnaligned(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getLongUnaligned(buffer, byteOffset);
    }

    @Override
    public byte getByteVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.getByteVolatile(buffer, byteOffset);
    }

    @Override
    public void putByteVolatile(byte[] buffer, long byteOffset, byte value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        this.access.putByteVolatile(buffer, byteOffset, value);
    }

    @Override
    public short getShortVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getShortVolatile(buffer, byteOffset);
    }

    @Override
    public void putShortVolatile(byte[] buffer, long byteOffset, short value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        this.access.putShortVolatile(buffer, byteOffset, value);
    }

    @Override
    public int getIntVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getIntVolatile(buffer, byteOffset);
    }

    @Override
    public void putIntVolatile(byte[] buffer, long byteOffset, int value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        this.access.putIntVolatile(buffer, byteOffset, value);
    }

    @Override
    public long getLongVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getLongVolatile(buffer, byteOffset);
    }

    @Override
    public void putLongVolatile(byte[] buffer, long byteOffset, long value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        this.access.putLongVolatile(buffer, byteOffset, value);
    }

    @Override
    public byte getAndAddByte(byte[] buffer, long byteOffset, byte delta) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.getAndAddByte(buffer, byteOffset, delta);
    }

    @Override
    public short getAndAddShort(byte[] buffer, long byteOffset, short delta) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getAndAddShort(buffer, byteOffset, delta);
    }

    @Override
    public int getAndAddInt(byte[] buffer, long byteOffset, int delta) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getAndAddInt(buffer, byteOffset, delta);
    }

    @Override
    public long getAndAddLong(byte[] buffer, long byteOffset, long delta) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getAndAddLong(buffer, byteOffset, delta);
    }

    @Override
    public byte getAndBitwiseAndByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.getAndBitwiseAndByte(buffer, byteOffset, mask);
    }

    @Override
    public short getAndBitwiseAndShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getAndBitwiseAndShort(buffer, byteOffset, mask);
    }

    @Override
    public int getAndBitwiseAndInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getAndBitwiseAndInt(buffer, byteOffset, mask);
    }

    @Override
    public long getAndBitwiseAndLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getAndBitwiseAndLong(buffer, byteOffset, mask);
    }

    @Override
    public byte getAndBitwiseOrByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.getAndBitwiseOrByte(buffer, byteOffset, mask);
    }

    @Override
    public short getAndBitwiseOrShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getAndBitwiseOrShort(buffer, byteOffset, mask);
    }

    @Override
    public int getAndBitwiseOrInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getAndBitwiseOrInt(buffer, byteOffset, mask);
    }

    @Override
    public long getAndBitwiseOrLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getAndBitwiseOrLong(buffer, byteOffset, mask);
    }

    @Override
    public byte getAndBitwiseXorByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.getAndBitwiseXorByte(buffer, byteOffset, mask);
    }

    @Override
    public short getAndBitwiseXorShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getAndBitwiseXorShort(buffer, byteOffset, mask);
    }

    @Override
    public int getAndBitwiseXorInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getAndBitwiseXorInt(buffer, byteOffset, mask);
    }

    @Override
    public long getAndBitwiseXorLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getAndBitwiseXorLong(buffer, byteOffset, mask);
    }

    @Override
    public byte getAndSetByte(byte[] buffer, long byteOffset, byte newValue) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.getAndSetByte(buffer, byteOffset, newValue);
    }

    @Override
    public short getAndSetShort(byte[] buffer, long byteOffset, short newValue) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.getAndSetShort(buffer, byteOffset, newValue);
    }

    @Override
    public int getAndSetInt(byte[] buffer, long byteOffset, int newValue) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.getAndSetInt(buffer, byteOffset, newValue);
    }

    @Override
    public long getAndSetLong(byte[] buffer, long byteOffset, long newValue) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.getAndSetLong(buffer, byteOffset, newValue);
    }

    @Override
    public byte compareAndExchangeByte(byte[] buffer, long byteOffset, byte expected, byte x) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 1L);
        return this.access.compareAndExchangeByte(buffer, byteOffset, expected, x);
    }

    @Override
    public short compareAndExchangeShort(byte[] buffer, long byteOffset, short expected, short x) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 2L);
        return this.access.compareAndExchangeShort(buffer, byteOffset, expected, x);
    }

    @Override
    public int compareAndExchangeInt(byte[] buffer, long byteOffset, int expected, int x) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 4L);
        return this.access.compareAndExchangeInt(buffer, byteOffset, expected, x);
    }

    @Override
    public long compareAndExchangeLong(byte[] buffer, long byteOffset, long expected, long x) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, byteOffset, 8L);
        return this.access.compareAndExchangeLong(buffer, byteOffset, expected, x);
    }
}

