/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.ContextLocal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.ContextThreadLocal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.InstrumentInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.InternalResource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.ThreadLocalAction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleFile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLogger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Instrumenter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExecutableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.LanguageInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.MessageEndpoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.MessageTransport;

public abstract class TruffleInstrument {
    protected final ContextLocalProvider locals = new ContextLocalProvider();

    protected TruffleInstrument() {
    }

    protected abstract void onCreate(Env var1);

    protected void onFinalize(Env env) {
    }

    protected void onDispose(Env env) {
    }

    protected OptionDescriptors getOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    protected OptionDescriptors getContextOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    protected OptionDescriptors getSourceOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    @Deprecated
    protected final <T> ContextLocal<T> createContextLocal(ContextLocalFactory<T> factory) {
        return this.locals.createContextLocal(factory);
    }

    @Deprecated
    protected final <T> ContextThreadLocal<T> createContextThreadLocal(ContextThreadLocalFactory<T> factory) {
        return this.locals.createContextThreadLocal(factory);
    }

    static {
        try {
            Class.forName(InstrumentationHandler.class.getName(), true, InstrumentationHandler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected static final class ContextLocalProvider {
        List<ContextLocal<?>> contextLocals;
        List<ContextThreadLocal<?>> contextThreadLocals;

        private ContextLocalProvider() {
        }

        public <T> ContextLocal<T> createContextLocal(ContextLocalFactory<T> factory) {
            ContextLocal local = InstrumentAccessor.ENGINE.createInstrumentContextLocal(factory);
            if (this.contextLocals == null) {
                this.contextLocals = new ArrayList();
            }
            try {
                this.contextLocals.add(local);
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalStateException("The set of context locals is frozen. Context locals can only be created during construction of the TruffleInstrument subclass.");
            }
            return local;
        }

        public <T> ContextThreadLocal<T> createContextThreadLocal(ContextThreadLocalFactory<T> factory) {
            ContextThreadLocal local = InstrumentAccessor.ENGINE.createInstrumentContextThreadLocal(factory);
            if (this.contextThreadLocals == null) {
                this.contextThreadLocals = new ArrayList();
            }
            try {
                this.contextThreadLocals.add(local);
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalStateException("The set of context thread locals is frozen. Context thread locals can only be created during construction of the TruffleInstrument subclass.");
            }
            return local;
        }
    }

    @FunctionalInterface
    protected static interface ContextLocalFactory<T> {
        public T create(TruffleContext var1);
    }

    @FunctionalInterface
    protected static interface ContextThreadLocalFactory<T> {
        public T create(TruffleContext var1, Thread var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String id() default "";

        public String name() default "";

        public String version() default "inherit";

        public boolean internal() default false;

        public Class<?>[] services() default {};

        public String website() default "";

        public SandboxPolicy sandbox() default SandboxPolicy.TRUSTED;

        public Class<? extends InternalResource>[] internalResources() default {};

        public String[] optionalResources() default {};
    }

    public static final class Env {
        private final Object polyglotInstrument;
        OptionValues options;
        InstrumentationHandler.InstrumentClientInstrumenter instrumenter;
        private List<Object> services;

        Env(Object polyglotInstrument) {
            this.polyglotInstrument = polyglotInstrument;
        }

        Object getPolyglotInstrument() {
            return this.polyglotInstrument;
        }

        public Instrumenter getInstrumenter() {
            return this.instrumenter;
        }

        public InputStream in() {
            return InstrumentAccessor.ENGINE.getEngineIn(InstrumentAccessor.ENGINE.getInstrumentEngine(this.polyglotInstrument));
        }

        public OutputStream out() {
            return InstrumentAccessor.ENGINE.getEngineOut(InstrumentAccessor.ENGINE.getInstrumentEngine(this.polyglotInstrument));
        }

        public OutputStream err() {
            return InstrumentAccessor.ENGINE.getEngineErr(InstrumentAccessor.ENGINE.getInstrumentEngine(this.polyglotInstrument));
        }

        public MessageEndpoint startServer(URI uri, MessageEndpoint server) throws IOException, MessageTransport.VetoException {
            return InstrumentAccessor.ENGINE.startEngineServer(InstrumentAccessor.ENGINE.getInstrumentEngine(this.polyglotInstrument), uri, server);
        }

        public void registerService(Object service) {
            if (this.services == null) {
                throw new IllegalStateException();
            }
            this.services.add(service);
        }

        @CompilerDirectives.TruffleBoundary
        static <T extends RuntimeException> RuntimeException engineToInstrumentException(Throwable t) {
            return InstrumentAccessor.engineAccess().engineToInstrumentException(t);
        }

        public <S> S lookup(LanguageInfo language, Class<S> type) {
            try {
                return InstrumentAccessor.engineAccess().lookup(language, type);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public <S> S lookup(InstrumentInfo instrument, Class<S> type) {
            try {
                Object vm = InstrumentAccessor.langAccess().getPolyglotInstrument(instrument);
                if (vm == this.polyglotInstrument) {
                    throw new IllegalArgumentException("Not allowed to lookup services from the currrent instrument.");
                }
                return InstrumentAccessor.engineAccess().lookup(instrument, type);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public Map<String, LanguageInfo> getLanguages() {
            try {
                return InstrumentAccessor.engineAccess().getInternalLanguages(this.polyglotInstrument);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public Map<String, InstrumentInfo> getInstruments() {
            try {
                return InstrumentAccessor.engineAccess().getInstruments(this.polyglotInstrument);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        Object[] onCreate(TruffleInstrument instrument) {
            ArrayList<Object> arr = new ArrayList<Object>();
            this.services = arr;
            try {
                instrument.onCreate(this);
            }
            finally {
                this.services = null;
            }
            return arr.toArray();
        }

        public OptionValues getOptions() {
            return this.options;
        }

        @CompilerDirectives.TruffleBoundary
        public OptionValues getOptions(TruffleContext context) {
            Objects.requireNonNull(context);
            return InstrumentAccessor.ENGINE.getInstrumentContextOptions(this.polyglotInstrument, InstrumentAccessor.LANGUAGE.getPolyglotContext(context));
        }

        public OptionValues getOptions(Source source) {
            Objects.requireNonNull(source);
            try {
                return InstrumentAccessor.ENGINE.getInstrumentSourceOptions(this.polyglotInstrument, source);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public CallTarget parse(Source source, String ... argumentNames) throws IOException {
            try {
                TruffleLanguage.Env env = InstrumentAccessor.ENGINE.getEnvForInstrument(source.getLanguage(), source.getMimeType());
                Object languageContext = InstrumentAccessor.LANGUAGE.getPolyglotLanguageContext(env);
                return InstrumentAccessor.ENGINE.parseForLanguage(languageContext, source, argumentNames, true);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public ExecutableNode parseInline(Source source, Node node, MaterializedFrame frame) {
            try {
                if (node == null) {
                    throw new IllegalArgumentException("Node must not be null.");
                }
                TruffleLanguage.Env env = InstrumentAccessor.ENGINE.getEnvForInstrument(source.getLanguage(), source.getMimeType());
                assert (InstrumentAccessor.langAccess().getLanguageInfo(env) == node.getRootNode().getLanguageInfo());
                Object languageContext = InstrumentAccessor.LANGUAGE.getPolyglotLanguageContext(env);
                return InstrumentAccessor.ENGINE.parseInlineForLanguage(languageContext, source, node, frame);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        @Deprecated
        public TruffleFile getTruffleFile(String path) {
            return this.getTruffleFile(null, path);
        }

        @Deprecated
        public TruffleFile getTruffleFile(URI uri) {
            return this.getTruffleFile(null, uri);
        }

        public TruffleFile getTruffleFile(TruffleContext context, String path) {
            try {
                return InstrumentAccessor.engineAccess().getTruffleFile(context, path);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public TruffleFile getTruffleFile(TruffleContext context, URI uri) {
            try {
                return InstrumentAccessor.engineAccess().getTruffleFile(context, uri);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public TruffleContext getEnteredContext() {
            return InstrumentAccessor.ENGINE.getCurrentCreatorTruffleContext();
        }

        public boolean isEngineRoot(RootNode root) {
            try {
                return InstrumentAccessor.engineAccess().isEvalRoot(root);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public void setAsynchronousStackDepth(int depth) {
            InstrumentAccessor.engineAccess().setAsynchronousStackDepth(this.polyglotInstrument, depth);
        }

        @CompilerDirectives.TruffleBoundary
        public LanguageInfo getLanguageInfo(Class<? extends TruffleLanguage<?>> languageClass) {
            try {
                Objects.requireNonNull(languageClass);
                return InstrumentAccessor.engineAccess().getLanguageInfo(this.polyglotInstrument, languageClass);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public Object getLanguageView(LanguageInfo language, Object value) {
            try {
                Objects.requireNonNull(language);
                return InstrumentAccessor.engineAccess().getLanguageView(language, value);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public Object getPolyglotBindings() {
            try {
                return InstrumentAccessor.engineAccess().getPolyglotBindingsObject();
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public Object getScope(LanguageInfo language) {
            assert (language != null);
            try {
                TruffleLanguage.Env env = InstrumentAccessor.engineAccess().getEnvForInstrument(language);
                return InstrumentAccessor.langAccess().getScope(env);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public TruffleFile getInternalResource(Class<? extends InternalResource> resource) throws IOException {
            return InstrumentAccessor.ENGINE.getInternalResource(this.polyglotInstrument, resource);
        }

        public TruffleFile getInternalResource(String resourceId) throws IOException {
            return InstrumentAccessor.ENGINE.getInternalResource(this.polyglotInstrument, resourceId);
        }

        public TruffleLogger getLogger(String loggerName) {
            try {
                return InstrumentAccessor.engineAccess().getLogger(this.polyglotInstrument, loggerName);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public TruffleLogger getLogger(Class<?> forClass) {
            return this.getLogger(forClass.getName());
        }

        public boolean isSameFrame(RootNode root, Frame frame1, Frame frame2) {
            return InstrumentAccessor.nodesAccess().isSameFrame(root, frame1, frame2);
        }

        public long calculateContextHeapSize(TruffleContext truffleContext, long stopAtBytes, AtomicBoolean cancelled) {
            return InstrumentAccessor.engineAccess().calculateContextHeapSize(InstrumentAccessor.langAccess().getPolyglotContext(truffleContext), stopAtBytes, cancelled);
        }

        public Future<Void> submitThreadLocal(TruffleContext context, Thread[] threads, ThreadLocalAction action) {
            Objects.requireNonNull(context);
            try {
                return InstrumentAccessor.ENGINE.submitThreadLocal(InstrumentAccessor.LANGUAGE.getPolyglotContext(context), this.polyglotInstrument, threads, action, true);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createSystemThread(Runnable runnable) {
            return this.createSystemThread(runnable, null);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createSystemThread(Runnable runnable, ThreadGroup threadGroup) {
            Objects.requireNonNull(runnable, "Runnable must be non null.");
            try {
                return InstrumentAccessor.ENGINE.createInstrumentSystemThread(this.polyglotInstrument, runnable, threadGroup);
            }
            catch (Throwable t) {
                throw Env.engineToInstrumentException(t);
            }
        }

        public SandboxPolicy getSandboxPolicy() {
            return InstrumentAccessor.ENGINE.getEngineSandboxPolicy(this.polyglotInstrument);
        }
    }
}

