/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLogger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleSafepoint;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.DefaultRuntimeAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;

public abstract class ThreadLocalHandshake {
    private static final Map<Thread, TruffleSafepointImpl> SAFEPOINTS = Collections.synchronizedMap(new WeakHashMap());

    static void resetNativeImageState() {
        for (TruffleSafepointImpl impl : SAFEPOINTS.values()) {
            impl.verifyUnused();
        }
        SAFEPOINTS.clear();
    }

    protected ThreadLocalHandshake() {
    }

    public abstract void poll(Node var1);

    public abstract TruffleSafepointImpl getCurrent();

    protected boolean isSupported() {
        return true;
    }

    public void testSupport() {
        if (!this.isSupported()) {
            throw new UnsupportedOperationException("Thread local handshakes are not supported on this platform. A possible reason may be that the underlying JVMCI version is too old.");
        }
    }

    public boolean setChangeAllowActions(TruffleSafepoint safepoint, boolean enabled) {
        return ((TruffleSafepointImpl)safepoint).setChangeAllowActions(enabled);
    }

    public boolean isAllowActions(TruffleSafepoint safepoint) {
        return ((TruffleSafepointImpl)safepoint).isAllowActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public final <T extends Consumer<Node>> Future<Void> runThreadLocal(Object polyglotContext, Thread[] threads, T onThread, Consumer<T> onDone, Consumer<Node> notifyBlockedConsumer, Consumer<Node> notifyUnblockedConsumer, boolean sideEffecting, boolean recurring, boolean syncStartOfEvent, boolean syncEndOfEvent, int syncActionMaxWait, boolean syncActionPrintStackTraces, TruffleLogger engineLogger) {
        this.testSupport();
        assert (threads.length > 0);
        Handshake<T> handshake = new Handshake<T>(polyglotContext, threads, onThread, onDone, notifyBlockedConsumer, notifyUnblockedConsumer, sideEffecting, recurring, threads.length, syncStartOfEvent, syncEndOfEvent, syncActionMaxWait, syncActionPrintStackTraces, engineLogger);
        if (syncStartOfEvent || syncEndOfEvent) {
            Class<ThreadLocalHandshake> clazz = ThreadLocalHandshake.class;
            synchronized (ThreadLocalHandshake.class) {
                this.addHandshakes(threads, handshake);
                // ** MonitorExit[var15_15] (shouldn't be in output)
            }
        } else {
            this.addHandshakes(threads, handshake);
        }
        return handshake;
    }

    private <T extends Consumer<Node>> void addHandshakes(Thread[] threads, Handshake<T> handshake) {
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            if (!t.isAlive()) {
                throw new IllegalStateException("Thread no longer alive with pending handshake.");
            }
            this.getThreadState(t).addHandshake(t, handshake);
        }
    }

    public final ActivationResult activateThread(TruffleSafepoint s, Future<?> f) {
        return ((TruffleSafepointImpl)s).activateThread((Handshake)f);
    }

    public final boolean deactivateThread(TruffleSafepoint s, Future<?> f) {
        return ((TruffleSafepointImpl)s).deactivateThread((Handshake)f);
    }

    public void ensureThreadInitialized() {
    }

    protected abstract void setFastPending(Thread var1);

    @CompilerDirectives.TruffleBoundary
    protected final void processHandshake(Node location) {
        TruffleSafepointImpl s = this.getCurrent();
        if (s != null && s.fastPendingSet) {
            s.processOrNotifyHandshakes(location, s.takeHandshakes(), null);
        }
    }

    protected abstract void clearFastPending();

    private static Throwable combineThrowable(Throwable current, Throwable t) {
        if (current == null) {
            return t;
        }
        if (t instanceof ThreadDeath) {
            t.addSuppressed(current);
            return t;
        }
        current.addSuppressed(t);
        return current;
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
        throw ex;
    }

    protected final TruffleSafepointImpl getThreadState(Thread thread) {
        return SAFEPOINTS.computeIfAbsent(thread, t -> new TruffleSafepointImpl(this));
    }

    protected static final class TruffleSafepointImpl
    extends TruffleSafepoint {
        private final ReentrantLock lock = new ReentrantLock();
        private final ThreadLocalHandshake impl;
        private volatile boolean fastPendingSet;
        private boolean sideEffectsEnabled = true;
        private boolean recurringActionsEnabled = true;
        private boolean enabled = true;
        private volatile boolean changeAllowActionsAllowed;
        private TruffleSafepoint.Interrupter blockedAction;
        private boolean interrupted;
        private final LinkedList<HandshakeEntry> handshakes = new LinkedList();

        TruffleSafepointImpl(ThreadLocalHandshake handshake) {
            super(DefaultRuntimeAccessor.ENGINE);
            this.impl = handshake;
        }

        void verifyUnused() throws AssertionError {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                throw new AssertionError((Object)"Invalid locked state for safepoint.");
            }
            this.lock.lock();
            try {
                if (this.blockedAction != null) {
                    throw new AssertionError((Object)"Invalid pending blocked action.");
                }
                if (this.interrupted) {
                    throw new AssertionError((Object)"Invalid pending interrupted state.");
                }
                if (this.isPending()) {
                    throw new AssertionError((Object)"Invalid pending handshakes.");
                }
                if (!this.sideEffectsEnabled) {
                    throw new AssertionError((Object)"Invalid side-effects disabled state");
                }
                if (!this.recurringActionsEnabled) {
                    throw new AssertionError((Object)"Invalid recuring actions disabled state");
                }
                if (!this.enabled) {
                    throw new AssertionError((Object)"Invalid allow actions disabled state");
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        void processOrNotifyHandshakes(Node location, List<HandshakeEntry> toProcessOrNotify, Boolean blockedNotification) {
            if (toProcessOrNotify == null) {
                return;
            }
            Throwable ex = null;
            for (HandshakeEntry current : toProcessOrNotify) {
                if (blockedNotification == null && !this.claimEntry(current)) continue;
                try {
                    Node actionLocation = TruffleSafepointImpl.getHandshakeLocation(location, current);
                    if (blockedNotification == null) {
                        current.handshake.perform(actionLocation);
                        continue;
                    }
                    if (blockedNotification.booleanValue()) {
                        current.handshake.notifyBlockedConsumer.accept(actionLocation);
                        continue;
                    }
                    current.handshake.notifyUnblockedConsumer.accept(actionLocation);
                }
                catch (Throwable e) {
                    ex = ThreadLocalHandshake.combineThrowable(ex, e);
                }
            }
            if (this.fastPendingSet) {
                this.resetPending();
            }
            if (ex != null) {
                throw ThreadLocalHandshake.sneakyThrow(ex);
            }
        }

        private static Node getHandshakeLocation(Node location, HandshakeEntry current) {
            return location != null ? location : DefaultRuntimeAccessor.ENGINE.getUncachedLocation(current.handshake.polyglotContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deactivateThread(Handshake<?> handshake) {
            assert (Thread.holdsLock(handshake.polyglotContext));
            this.lock.lock();
            try {
                HandshakeEntry current = this.lookupEntry(handshake);
                if (current != null) {
                    assert (!current.reactivated || current.handshake.sideEffecting) : "Reactivated handshake was not processed!";
                    handshake.deactivateThread();
                    this.claimEntry(current);
                    handshake.threads.put(Thread.currentThread(), Boolean.TRUE);
                    this.resetPending();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActivationResult activateThread(Handshake<?> handshake) {
            assert (Thread.holdsLock(handshake.polyglotContext));
            if (handshake.isDone()) {
                return ActivationResult.TERMINATED;
            }
            this.lock.lock();
            try {
                Boolean threadState = handshake.threads.get(Thread.currentThread());
                HandshakeEntry current = this.lookupEntry(handshake);
                if (current != null) {
                    assert (threadState == Boolean.FALSE) : "Bad thread state for a TLA that appears as active: " + threadState;
                    ActivationResult activationResult = ActivationResult.ACTIVE;
                    return activationResult;
                }
                boolean reactivated = false;
                if (threadState == Boolean.FALSE) {
                    ActivationResult activationResult = ActivationResult.PROCESSED;
                    return activationResult;
                }
                assert (threadState == null || threadState == Boolean.TRUE) : "Bad thread state for a TLA that is about to be activated: " + threadState;
                if (threadState == Boolean.TRUE) {
                    reactivated = true;
                }
                if (handshake.activateThread()) {
                    handshake.threads.put(Thread.currentThread(), Boolean.FALSE);
                    this.addHandshakeImpl(Thread.currentThread(), handshake, reactivated);
                    if (reactivated) {
                        ActivationResult activationResult = ActivationResult.REACTIVATED;
                        return activationResult;
                    }
                    ActivationResult activationResult = ActivationResult.ACTIVATED;
                    return activationResult;
                }
                ActivationResult activationResult = ActivationResult.TERMINATED;
                return activationResult;
            }
            finally {
                this.lock.unlock();
            }
        }

        private HandshakeEntry lookupEntry(Handshake<?> handshake) {
            assert (this.lock.isHeldByCurrentThread());
            for (HandshakeEntry entry : this.handshakes) {
                if (entry.handshake != handshake) continue;
                return entry;
            }
            return null;
        }

        void addHandshake(Thread t, Handshake<?> handshake) {
            this.lock.lock();
            try {
                this.addHandshakeImpl(t, handshake, false);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void addHandshakeImpl(Thread t, Handshake<?> handshake, boolean reactivated) {
            this.handshakes.add(new HandshakeEntry(handshake, reactivated));
            if (this.isPending()) {
                this.setFastPendingAndInterrupt(t);
            }
        }

        private void setFastPendingAndInterrupt(Thread t) {
            TruffleSafepoint.Interrupter action;
            assert (this.lock.isHeldByCurrentThread());
            if (!this.fastPendingSet) {
                this.fastPendingSet = true;
                this.impl.setFastPending(t);
            }
            if ((action = this.blockedAction) != null) {
                this.interrupted = true;
                action.interrupt(t);
            }
        }

        List<HandshakeEntry> takeHandshakes() {
            this.lock.lock();
            try {
                if (this.interrupted) {
                    this.blockedAction.resetInterrupted();
                    this.interrupted = false;
                }
                if (this.isPending()) {
                    List<HandshakeEntry> taken = this.takeHandshakeImpl();
                    assert (!taken.isEmpty());
                    List<HandshakeEntry> list = taken;
                    return list;
                }
                List<HandshakeEntry> list = null;
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isFastPendingSet() {
            return this.fastPendingSet;
        }

        private void resetPending() {
            this.lock.lock();
            try {
                if (this.fastPendingSet && !this.isPending()) {
                    this.fastPendingSet = false;
                    this.impl.clearFastPending();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean claimEntry(HandshakeEntry entry) {
            this.lock.lock();
            try {
                boolean bl = this.handshakes.removeFirstOccurrence(entry);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private List<HandshakeEntry> takeHandshakeImpl() {
            if (!this.enabled) {
                return Collections.emptyList();
            }
            ArrayList<HandshakeEntry> toProcess = new ArrayList<HandshakeEntry>(this.handshakes.size());
            for (HandshakeEntry entry : this.handshakes) {
                if (!this.isPending(entry)) continue;
                toProcess.add(entry);
            }
            return toProcess;
        }

        private boolean isPending(HandshakeEntry entry) {
            return !(!this.sideEffectsEnabled && entry.handshake.sideEffecting || !this.recurringActionsEnabled && entry.handshake.recurring);
        }

        @Override
        public <T> void setBlocked(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.Interruptible<T> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant(interruptible) && interruptible instanceof TruffleSafepoint.CompiledInterruptible) {
                this.setBlockedCompiled(location, interrupter, (TruffleSafepoint.CompiledInterruptible)interruptible, object, beforeInterrupt, afterInterrupt);
            } else {
                this.setBlockedBoundary(location, interrupter, interruptible, object, beforeInterrupt, afterInterrupt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> void setBlockedCompiled(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.CompiledInterruptible<T> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            try {
                while (true) {
                    try {
                        this.setBlockedImpl(location, interrupter, false, true);
                        interruptible.apply(object);
                    }
                    catch (InterruptedException e) {
                        this.setBlockedAfterInterrupt(location, null, beforeInterrupt, afterInterrupt);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.setBlockedImpl(location, prev, false, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private <T> void setBlockedBoundary(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.Interruptible<T> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            try {
                while (true) {
                    try {
                        this.setBlockedImpl(location, interrupter, false, true);
                        interruptible.apply(object);
                    }
                    catch (InterruptedException e) {
                        this.setBlockedAfterInterrupt(location, null, beforeInterrupt, afterInterrupt);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.setBlockedImpl(location, prev, false, false);
            }
        }

        @Override
        public <T, R> R setBlockedFunction(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.InterruptibleFunction<T, R> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant(interruptible) && interruptible instanceof TruffleSafepoint.CompiledInterruptibleFunction) {
                return this.setBlockedFunctionCompiled(location, interrupter, (TruffleSafepoint.CompiledInterruptibleFunction)interruptible, object, beforeInterrupt, afterInterrupt);
            }
            return this.setBlockedFunctionBoundary(location, interrupter, interruptible, object, beforeInterrupt, afterInterrupt);
        }

        private <T, R> R setBlockedFunctionCompiled(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.CompiledInterruptibleFunction<T, R> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            while (true) {
                try {
                    this.setBlockedImpl(location, interrupter, false, true);
                    R r = interruptible.apply(object);
                    return r;
                }
                catch (InterruptedException e) {
                    this.setBlockedAfterInterrupt(location, null, beforeInterrupt, afterInterrupt);
                    continue;
                }
                break;
            }
            finally {
                this.setBlockedImpl(location, prev, false, false);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private <T, R> R setBlockedFunctionBoundary(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.InterruptibleFunction<T, R> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            while (true) {
                try {
                    this.setBlockedImpl(location, interrupter, false, true);
                    R r = interruptible.apply(object);
                    return r;
                }
                catch (InterruptedException e) {
                    this.setBlockedAfterInterrupt(location, null, beforeInterrupt, afterInterrupt);
                    continue;
                }
                break;
            }
            finally {
                this.setBlockedImpl(location, prev, false, false);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void setBlockedAfterInterrupt(Node location, TruffleSafepoint.Interrupter interrupter, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            if (beforeInterrupt != null) {
                beforeInterrupt.run();
            }
            Throwable t = null;
            try {
                this.setBlockedImpl(location, interrupter, true, false);
            }
            catch (Throwable e) {
                t = e;
                throw e;
            }
            finally {
                if (afterInterrupt != null) {
                    afterInterrupt.accept(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void setBlockedImpl(Node location, TruffleSafepoint.Interrupter interrupter, boolean processSafepoints, boolean blocked) {
            assert (!processSafepoints || !blocked);
            List<HandshakeEntry> toProcessOrNotify = null;
            this.lock.lock();
            try {
                if ((processSafepoints || !blocked) && this.isPending()) {
                    toProcessOrNotify = this.takeHandshakeImpl();
                }
                if (this.interrupted) {
                    assert (this.blockedAction != null);
                    this.blockedAction.resetInterrupted();
                    this.interrupted = false;
                }
                this.blockedAction = interrupter;
            }
            finally {
                this.lock.unlock();
            }
            this.processOrNotifyHandshakes(location, toProcessOrNotify, false);
            if (processSafepoints) {
                this.processOrNotifyHandshakes(location, toProcessOrNotify, null);
            }
            if (blocked && interrupter != null) {
                this.interruptIfPending(location, interrupter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void interruptIfPending(Node location, TruffleSafepoint.Interrupter interrupter) {
            List<HandshakeEntry> toNotify;
            this.lock.lock();
            try {
                toNotify = this.takeHandshakeImpl();
                this.recurringActionsEnabled = false;
                try {
                    if (this.isPending()) {
                        this.interrupted = true;
                        interrupter.interrupt(Thread.currentThread());
                    }
                }
                finally {
                    this.recurringActionsEnabled = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.processOrNotifyHandshakes(location, toNotify, true);
        }

        private boolean isPending() {
            assert (this.lock.isHeldByCurrentThread());
            if (!this.enabled) {
                return false;
            }
            for (HandshakeEntry entry : this.handshakes) {
                if (!this.isPending(entry)) continue;
                return true;
            }
            return false;
        }

        boolean setChangeAllowActions(boolean changeAllowActionsAllowed) {
            boolean prevChangeAllowActionsAllowed = this.changeAllowActionsAllowed;
            this.changeAllowActionsAllowed = changeAllowActionsAllowed;
            return prevChangeAllowActionsAllowed;
        }

        boolean isAllowActions() {
            return this.enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean setAllowActions(boolean enabled) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            this.lock.lock();
            try {
                if (!this.changeAllowActionsAllowed) {
                    throw new IllegalStateException("Using setAllowActions is only permitted during finalization of a language. See TruffleLanguage.finalizeContext(Object) for further details.");
                }
                boolean prev = this.enabled;
                this.enabled = enabled;
                this.updateFastPending();
                boolean bl = prev;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean setAllowSideEffects(boolean enabled) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            this.lock.lock();
            try {
                boolean prev = this.sideEffectsEnabled;
                this.sideEffectsEnabled = enabled;
                this.updateFastPending();
                boolean bl = prev;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasPendingSideEffectingActions() {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            this.lock.lock();
            try {
                boolean bl = !this.sideEffectsEnabled && this.hasSideEffecting();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean hasSideEffecting() {
            assert (this.lock.isHeldByCurrentThread());
            for (HandshakeEntry entry : this.handshakes) {
                if (!entry.handshake.sideEffecting) continue;
                return true;
            }
            return false;
        }

        private void updateFastPending() {
            if (this.isPending()) {
                this.setFastPendingAndInterrupt(Thread.currentThread());
            } else if (this.fastPendingSet) {
                this.fastPendingSet = false;
                this.impl.clearFastPending();
            }
        }
    }

    public static final class Handshake<T extends Consumer<Node>>
    implements Future<Void> {
        private final boolean sideEffecting;
        private final boolean recurring;
        private volatile boolean cancelled;
        private final Object polyglotContext;
        private final T action;
        private final Consumer<Node> notifyBlockedConsumer;
        private final Consumer<Node> notifyUnblockedConsumer;
        private final boolean syncStartOfEvent;
        private final Barrier startBarrier;
        private final boolean syncEndOfEvent;
        private final Barrier endBarrier;
        private final int syncActionMaxWait;
        private final boolean syncActionPrintStackTraces;
        private final TruffleLogger engineLogger;
        private final AtomicBoolean warned = new AtomicBoolean(false);
        private final Map<Thread, Boolean> threads;
        private final Consumer<T> onDone;

        Handshake(Object polyglotContext, Thread[] initialThreads, T action, Consumer<T> onDone, Consumer<Node> notifyBlockedConsumer, Consumer<Node> notifyUnblockedConsumer, boolean sideEffecting, boolean recurring, int numberOfThreads, boolean syncStartOfEvent, boolean syncEndOfEvent, int syncActionMaxWait, boolean syncActionPrintStackTraces, TruffleLogger engineLogger) {
            this.polyglotContext = polyglotContext;
            this.action = action;
            this.onDone = onDone;
            this.notifyBlockedConsumer = notifyBlockedConsumer;
            this.notifyUnblockedConsumer = notifyUnblockedConsumer;
            this.sideEffecting = sideEffecting;
            this.recurring = recurring;
            this.syncStartOfEvent = syncStartOfEvent;
            this.startBarrier = syncStartOfEvent ? new Barrier(numberOfThreads) : null;
            this.syncEndOfEvent = syncEndOfEvent;
            this.endBarrier = new Barrier(numberOfThreads);
            this.syncActionMaxWait = syncActionMaxWait;
            this.syncActionPrintStackTraces = syncActionPrintStackTraces;
            this.engineLogger = engineLogger;
            this.threads = new WeakHashMap<Thread, Boolean>(Arrays.stream(initialThreads).collect(Collectors.toMap(t -> t, t -> Boolean.FALSE)));
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        private boolean isTerminated() {
            return this.endBarrier.isTerminated();
        }

        void perform(Node node) {
            try {
                if (this.syncStartOfEvent) {
                    this.startBarrier.arrive();
                    this.await(this.startBarrier);
                }
                if (!this.cancelled) {
                    this.action.accept((Node)node);
                }
            }
            finally {
                this.endBarrier.arrive();
                if (this.syncEndOfEvent) {
                    this.await(this.endBarrier);
                    assert (this.isTerminated());
                }
                if (this.isTerminated()) {
                    this.onDone.accept(this.action);
                }
            }
        }

        private void await(Barrier barrier) {
            boolean interrupted;
            block14: {
                long remaining;
                interrupted = false;
                if (this.syncActionMaxWait == 0) {
                    while (true) {
                        try {
                            barrier.await();
                            break block14;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(this.syncActionMaxWait);
                boolean success = false;
                while ((remaining = deadline - System.nanoTime()) > 0L) {
                    try {
                        success = barrier.await(remaining, TimeUnit.NANOSECONDS);
                        break;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                if (!success) {
                    if (this.awaitTimeout(barrier)) {
                        this.cancel(true);
                    } else {
                        while (true) {
                            try {
                                barrier.await();
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean awaitTimeout(Barrier barrier) {
            if (this.warned.get() || !this.warned.compareAndSet(false, true)) {
                return false;
            }
            this.engineLogger.warning(barrier.getCount() + " threads did not reach the synchronous ThreadLocalAction " + String.valueOf(this.action) + " in " + this.syncActionMaxWait + " seconds. When using virtual threads this may be due to the issue that once more than Runtime.availableProcessors() virtual threads are pinned and waiting for each other, no virtual threads can progress (JDK-8334304). Cancelling this ThreadLocalAction to unblock. Use --engine.SynchronousThreadLocalActionPrintStackTraces=true to print thread stacktraces.");
            if (this.syncActionPrintStackTraces) {
                LinkedHashMap<StackTrace, List> grouped = new LinkedHashMap<StackTrace, List>();
                Iterator iterator = this.polyglotContext;
                synchronized (iterator) {
                    for (Map.Entry<Thread, Boolean> entry : this.threads.entrySet()) {
                        if (entry.getValue().booleanValue()) continue;
                        Thread thread = entry.getKey();
                        StackTrace stackTrace = new StackTrace(thread.getStackTrace());
                        grouped.computeIfAbsent(stackTrace, t -> new ArrayList()).add(thread);
                    }
                }
                for (Map.Entry entry : grouped.entrySet()) {
                    StringBuilder out = new StringBuilder("Stacktrace for:").append(System.lineSeparator());
                    for (Thread thread : (List)entry.getValue()) {
                        out.append(thread).append(System.lineSeparator());
                    }
                    Exception exception = new Exception();
                    exception.setStackTrace(((StackTrace)entry.getKey()).elements);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    exception.printStackTrace(new PrintStream(stream));
                    String stackTraceString = stream.toString();
                    stackTraceString = stackTraceString.substring(stackTraceString.indexOf("\t"));
                    this.engineLogger.warning(String.valueOf(out) + stackTraceString);
                }
            }
            return true;
        }

        boolean activateThread() {
            if (this.syncStartOfEvent) {
                if (!this.startBarrier.register()) {
                    return false;
                }
                if (!this.endBarrier.register()) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                return true;
            }
            return this.endBarrier.register();
        }

        void deactivateThread() {
            if (this.syncStartOfEvent) {
                this.startBarrier.arrive();
            }
            this.endBarrier.arrive();
            if (this.isTerminated()) {
                this.onDone.accept(this.action);
            }
        }

        @Override
        public Void get() throws InterruptedException {
            this.endBarrier.await();
            if (this.cancelled) {
                throw new CancellationException();
            }
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!this.endBarrier.await(timeout, unit)) {
                throw new TimeoutException();
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            return null;
        }

        @Override
        public boolean isDone() {
            return this.cancelled || this.isTerminated();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isTerminated()) {
                this.cancelled = true;
                if (this.syncStartOfEvent) {
                    this.startBarrier.releaseAll();
                }
                this.endBarrier.releaseAll();
                this.onDone.accept(this.action);
                return true;
            }
            return false;
        }

        public String toString() {
            return "Handshake[action=" + String.valueOf(this.action) + ", startBarrier=" + String.valueOf(this.startBarrier) + ", endBarrier=" + String.valueOf(this.endBarrier) + ", cancelled=" + this.cancelled + ", sideEffecting=" + this.sideEffecting + ", syncStartOfEvent=" + this.syncStartOfEvent + ", syncEndOfEvent=" + this.syncEndOfEvent + "]";
        }
    }

    public static enum ActivationResult {
        ACTIVE,
        PROCESSED,
        TERMINATED,
        ACTIVATED,
        REACTIVATED;

    }

    static final class HandshakeEntry {
        final Handshake<?> handshake;
        final boolean reactivated;

        HandshakeEntry(Handshake<?> handshake, boolean reactivated) {
            this.handshake = handshake;
            this.reactivated = reactivated;
        }

        public String toString() {
            return "HandshakeEntry[" + String.valueOf(this.handshake) + " reactivated=" + this.reactivated + "]";
        }
    }

    private static final class Barrier
    extends AbstractQueuedSynchronizer {
        Barrier(int initialParties) {
            this.setState(initialParties);
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            assert (acquires == 1);
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextCount;
            int count;
            assert (releases == 1);
            do {
                if ((count = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(count, nextCount = count - 1));
            return nextCount == 0;
        }

        public boolean register() {
            int nextCount;
            int count;
            do {
                if ((count = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(count, nextCount = count + 1));
            return true;
        }

        public void arrive() {
            this.releaseShared(1);
        }

        public void await() throws InterruptedException {
            this.acquireSharedInterruptibly(1);
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.tryAcquireSharedNanos(1, unit.toNanos(timeout));
        }

        public int getCount() {
            return this.getState();
        }

        public boolean isTerminated() {
            return this.getState() == 0;
        }

        public void releaseAll() {
            while (!this.isTerminated()) {
                this.arrive();
            }
        }
    }

    private static final class StackTrace {
        final StackTraceElement[] elements;

        private StackTrace(StackTraceElement[] elements) {
            this.elements = elements;
        }

        public int hashCode() {
            return Arrays.hashCode(this.elements);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (other == this) return true;
            if (!(other instanceof StackTrace)) return false;
            StackTrace stacktrace = (StackTrace)other;
            if (!Arrays.equals(this.elements, stacktrace.elements)) return false;
            return true;
        }
    }
}

