/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.debug;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleStackTraceElement;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.debug.DebugException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.debug.DebugScope;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.debug.DebuggerSession;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.NodeLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.LanguageInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

public final class DebugStackTraceElement {
    private final DebuggerSession session;
    final TruffleStackTraceElement traceElement;
    private final StackTraceElement hostTraceElement;
    private StackTraceElement stackTraceElement;

    DebugStackTraceElement(DebuggerSession session, TruffleStackTraceElement traceElement) {
        this.session = session;
        this.traceElement = traceElement;
        this.hostTraceElement = null;
    }

    DebugStackTraceElement(DebuggerSession session, StackTraceElement hostTraceElement) {
        this.session = session;
        this.traceElement = null;
        this.hostTraceElement = hostTraceElement;
    }

    public boolean isInternal() {
        if (this.isHost()) {
            return false;
        }
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return true;
        }
        return root.isInternal();
    }

    public boolean isHost() {
        return this.hostTraceElement != null;
    }

    public StackTraceElement getHostTraceElement() {
        return this.hostTraceElement;
    }

    public String getName() {
        if (this.hostTraceElement != null) {
            return this.hostTraceElement.getClassName() + "." + this.hostTraceElement.getMethodName();
        }
        try {
            Object guestObject = this.traceElement.getGuestObject();
            return DebugStackTraceElement.getExecutableName(guestObject);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            RootNode root = this.findCurrentRoot();
            LanguageInfo languageInfo = root != null ? root.getLanguageInfo() : null;
            throw DebugException.create(this.session, ex, languageInfo);
        }
    }

    public SourceSection getSourceSection() {
        try {
            return this.getSourceSectionImpl();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            RootNode root = this.findCurrentRoot();
            LanguageInfo languageInfo = root != null ? root.getLanguageInfo() : null;
            throw DebugException.create(this.session, ex, languageInfo);
        }
    }

    private SourceSection getSourceSectionImpl() {
        if (this.isHost()) {
            return null;
        }
        Object guestObject = this.traceElement.getGuestObject();
        SourceSection sc = null;
        if (InteropLibrary.getUncached().hasSourceLocation(guestObject)) {
            try {
                sc = InteropLibrary.getUncached().getSourceLocation(guestObject);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere(ex);
            }
        }
        if (sc != null) {
            return this.session.resolveSection(sc);
        }
        return null;
    }

    public DebugScope getScope() {
        MaterializedFrame frame;
        if (this.isHost()) {
            return null;
        }
        Node node = this.traceElement.getInstrumentableLocation();
        if (node == null) {
            return null;
        }
        RootNode root = node.getRootNode();
        if (root.getLanguageInfo() == null) {
            return null;
        }
        Frame elementFrame = this.traceElement.getFrame();
        MaterializedFrame materializedFrame = frame = elementFrame != null ? elementFrame.materialize() : null;
        if (!NodeLibrary.getUncached().hasScope(node, frame)) {
            return null;
        }
        try {
            Object scope = NodeLibrary.getUncached().getScope(node, frame, true);
            return new DebugScope(scope, this.session, null, node, frame, root);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    private LanguageInfo getLanguage() {
        if (this.isHost()) {
            return null;
        }
        RootNode root = this.findCurrentRoot();
        LanguageInfo language = root != null ? root.getLanguageInfo() : null;
        return language;
    }

    private RootNode findCurrentRoot() {
        if (this.isHost()) {
            return null;
        }
        Node node = this.traceElement.getLocation();
        if (node != null) {
            return node.getRootNode();
        }
        RootCallTarget target = this.traceElement.getTarget();
        return target.getRootNode();
    }

    StackTraceElement toTraceElement() {
        if (this.stackTraceElement == null) {
            if (this.hostTraceElement != null) {
                this.stackTraceElement = this.hostTraceElement;
            } else {
                LanguageInfo language = this.getLanguage();
                Object methodName = null;
                String metaQualifiedName = null;
                SourceSection sourceLocation = null;
                try {
                    Object guestObject = this.traceElement.getGuestObject();
                    if (guestObject != null) {
                        methodName = DebugStackTraceElement.getExecutableName(guestObject);
                        metaQualifiedName = DebugStackTraceElement.getDeclaringMetaQualifiedName(guestObject);
                    }
                    sourceLocation = this.getSourceSectionImpl();
                }
                catch (AssertionError | ThreadDeath td) {
                    throw td;
                }
                catch (Throwable ex) {
                    if (InteropLibrary.getUncached().isException(ex)) {
                        methodName = "Error in generating method name: " + ex.getLocalizedMessage();
                    }
                    throw ex;
                }
                StringBuilder declaringClass = new StringBuilder();
                if (language != null) {
                    declaringClass.append("<").append(language.getId()).append(">");
                    if (metaQualifiedName != null) {
                        declaringClass.append(" ");
                    }
                }
                if (metaQualifiedName != null) {
                    declaringClass.append(metaQualifiedName);
                }
                if (methodName == null) {
                    methodName = "";
                }
                String fileName = sourceLocation != null ? sourceLocation.getSource().getName() : "Unknown";
                int startLine = sourceLocation != null ? sourceLocation.getStartLine() : -1;
                this.stackTraceElement = new StackTraceElement(declaringClass.toString(), (String)methodName, fileName, startLine);
            }
        }
        return this.stackTraceElement;
    }

    private static String getExecutableName(Object guestObject) {
        if (InteropLibrary.getUncached().hasExecutableName(guestObject)) {
            try {
                return InteropLibrary.getUncached().asString(InteropLibrary.getUncached().getExecutableName(guestObject));
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere(ex);
            }
        }
        return null;
    }

    private static String getDeclaringMetaQualifiedName(Object guestObject) {
        if (InteropLibrary.getUncached().hasDeclaringMetaObject(guestObject)) {
            try {
                Object hostObject = InteropLibrary.getUncached().getDeclaringMetaObject(guestObject);
                return InteropLibrary.getUncached().asString(InteropLibrary.getUncached().getMetaQualifiedName(hostObject));
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere(ex);
            }
        }
        return null;
    }
}

