/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.serialization;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

final class ByteBufferDataInput
implements DataInput {
    private final ByteBuffer buffer;
    private char[] lineBuffer;

    ByteBufferDataInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    private static EOFException wrap(BufferUnderflowException ex) {
        EOFException eof = new EOFException();
        eof.addSuppressed(ex);
        return eof;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.buffer.get(b, 0, len);
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = this.buffer.remaining() > n ? this.buffer.remaining() : n;
        this.buffer.position(this.buffer.position() + skip);
        return skip;
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.buffer.get() != 0;
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            return this.buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        try {
            return this.buffer.getShort() & 0xFFFF;
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.buffer.getChar();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferDataInput.wrap(ex);
        }
    }

    private static int get(ByteBuffer buf) {
        if (buf.position() >= buf.limit()) {
            return -1;
        }
        return buf.get();
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        int c;
        char[] buf = this.lineBuffer;
        if (buf == null) {
            buf = this.lineBuffer = new char[128];
        }
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            c = ByteBufferDataInput.get(this.buffer);
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = ByteBufferDataInput.get(this.buffer);
                    if (c2 == 10 || c2 == -1) break block4;
                    this.buffer.position(this.buffer.position() - 1);
                    break block4;
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(this.lineBuffer, 0, buf, 0, offset);
                        this.lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

