/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.evaluate.translation.translator.OperatorProxyExecutable;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.PolyglotException;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorOperator
implements IValueTranslator<ValueTypeOperator.ValueOperator> {
    @Override
    public IValueType<?> getValueType() {
        return ValueTypes.OPERATOR;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        return value.canExecute();
    }

    @Override
    public boolean canTranslateNbt() {
        return false;
    }

    @Override
    public Value translateToGraal(Context context, ValueTypeOperator.ValueOperator value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        return context.asValue(new OperatorProxyExecutable(context, value, exceptionFactory, valueDeseralizationContext));
    }

    @Override
    public ValueTypeOperator.ValueOperator translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        if (value.isProxyObject()) {
            try {
                OperatorProxyExecutable cast = (OperatorProxyExecutable)value.asProxyObject();
                return cast.getValue();
            }
            catch (ClassCastException cast) {
                // empty catch block
            }
        }
        int argCount = value.getMember("length").asInt();
        IValueType[] inputValueTypes = new IValueType[argCount];
        for (int i = 0; i < argCount; ++i) {
            inputValueTypes[i] = ValueTypes.CATEGORY_ANY;
        }
        return ValueTypeOperator.ValueOperator.of((IOperator)new GraalOperator(inputValueTypes, args -> {
            Value returnValue;
            IVariable[] variables = args.getVariables();
            Value[] values = new Value[variables.length];
            context.resetLimits();
            for (int i = 0; i < variables.length; ++i) {
                try {
                    values[i] = ValueTranslators.REGISTRY.translateToGraal(context, variables[i].getValue(), exceptionFactory, valueDeseralizationContext);
                    continue;
                }
                catch (PolyglotException e) {
                    throw exceptionFactory.createError(e.getMessage());
                }
            }
            try {
                returnValue = value.execute(values);
            }
            catch (PolyglotException e) {
                throw exceptionFactory.createError(e.getMessage());
            }
            return ValueTranslators.REGISTRY.translateFromGraal(context, returnValue, exceptionFactory, valueDeseralizationContext);
        }));
    }

    @Override
    public Tag translateToNbt(Context context, ValueTypeOperator.ValueOperator value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        throw exceptionFactory.createError(Component.translatable((String)"valuetype.integratedscripting.error.translation.unsupported_translateToNbt", (Object[])new Object[]{Component.translatable((String)value.getType().getTranslationKey()), value.getType().toCompactString((IValue)value)}));
    }

    static {
        Operators.REGISTRY.registerSerializer((IOperatorSerializer)new GraalOperator.Serializer());
    }

    public static class GraalOperator
    extends OperatorBase {
        protected GraalOperator(IValueType[] inputTypes, OperatorBase.IFunction function) {
            super("graal", "graal", "graal", null, false, inputTypes, (IValueType)ValueTypes.CATEGORY_ANY, function, null);
        }

        protected String getUnlocalizedType() {
            return "integratedscript";
        }

        protected String getModId() {
            return "integratedscripting";
        }

        public static class Serializer
        implements IOperatorSerializer<GraalOperator> {
            public boolean canHandle(IOperator operator) {
                return operator instanceof GraalOperator;
            }

            public ResourceLocation getUniqueName() {
                return ResourceLocation.fromNamespaceAndPath((String)"integratedscripting", (String)"graal");
            }

            public Tag serialize(ValueDeseralizationContext valueDeseralizationContext, GraalOperator operator) {
                ListTag list = new ListTag();
                for (int i = 0; i < operator.getInputTypes().length; ++i) {
                    list.add((Object)StringTag.valueOf((String)operator.getInputTypes()[i].getUniqueName().toString()));
                }
                return list;
            }

            public GraalOperator deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) throws EvaluationException {
                ListTag listTag = (ListTag)value;
                IValueType[] inputTypes = new IValueType[listTag.size()];
                for (int i = 0; i < listTag.size(); ++i) {
                    inputTypes[i] = ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)listTag.getString(i)));
                }
                return new GraalOperator(inputTypes, variables -> {
                    throw new EvaluationException(Component.translatable((String)"operator.integratedscripting.error.no_graal_serialization"));
                });
            }
        }
    }
}

