/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLogger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLoggers {
    private static final Map<Path, SharedFileHandler> fileHandlers = new HashMap<Path, SharedFileHandler>();
    private static final String GRAAL_COMPILER_LOG_ID = "graal";
    private static final Set<String> INTERNAL_IDS;

    private PolyglotLoggers() {
    }

    static Set<String> getInternalIds() {
        return INTERNAL_IDS;
    }

    static boolean haveSameTarget(AbstractPolyglotImpl.LogHandler h1, AbstractPolyglotImpl.LogHandler h2) {
        if (h1 == h2) {
            return true;
        }
        if (h1 instanceof StreamLogHandler && h2 instanceof StreamLogHandler) {
            return ((StreamLogHandler)h1).stream == ((StreamLogHandler)h2).stream;
        }
        if (h1 instanceof JavaLogHandler && h2 instanceof JavaLogHandler) {
            return ((JavaLogHandler)h1).handler == ((JavaLogHandler)h2).handler;
        }
        return false;
    }

    static AbstractPolyglotImpl.LogHandler asLogHandler(Object logHandlerOrStream) {
        if (logHandlerOrStream instanceof Handler) {
            return new JavaLogHandler((Handler)logHandlerOrStream);
        }
        if (logHandlerOrStream instanceof OutputStream) {
            return PolyglotLoggers.createStreamHandler((OutputStream)logHandlerOrStream, true, true);
        }
        throw new IllegalArgumentException("Unexpected logHandlerOrStream parameter: " + String.valueOf(logHandlerOrStream));
    }

    static AbstractPolyglotImpl.LogHandler createDefaultHandler(OutputStream out, SandboxPolicy sandboxPolicy) {
        return new StreamLogHandler(out, false, true, true, sandboxPolicy.isStricterOrEqual(SandboxPolicy.UNTRUSTED) ? sandboxPolicy : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isDefault(AbstractPolyglotImpl.LogHandler handler) {
        if (!(handler instanceof StreamLogHandler)) return false;
        StreamLogHandler streamLogHandler = (StreamLogHandler)handler;
        if (!streamLogHandler.isDefault) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AbstractPolyglotImpl.LogHandler getFileHandler(String path) {
        Path absolutePath = Paths.get(path, new String[0]).toAbsolutePath().normalize();
        Map<Path, SharedFileHandler> map = fileHandlers;
        synchronized (map) {
            SharedFileHandler handler = fileHandlers.get(absolutePath);
            if (handler == null) {
                try {
                    handler = new SharedFileHandler(absolutePath);
                    fileHandlers.put(absolutePath, handler);
                }
                catch (IOException ioe) {
                    throw PolyglotEngineException.illegalArgument("Cannot open log file " + path + " for writing, IO error: " + (ioe.getMessage() != null ? ioe.getMessage() : null));
                }
            }
            return handler.retain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Path> getActiveFileHandlers() {
        Map<Path, SharedFileHandler> map = fileHandlers;
        synchronized (map) {
            return new HashSet<Path>(fileHandlers.keySet());
        }
    }

    static AbstractPolyglotImpl.LogHandler createStreamHandler(OutputStream out, boolean closeStream, boolean flushOnPublish) {
        return new StreamLogHandler(out, closeStream, flushOnPublish, false, null);
    }

    static LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown, String formatKind) {
        return new ImmutableLogRecord(level, loggerName, message, className, methodName, parameters, thrown, ImmutableLogRecord.FormatKind.valueOf(formatKind));
    }

    static String getFormatKind(LogRecord logRecord) {
        return (logRecord instanceof ImmutableLogRecord ? ((ImmutableLogRecord)logRecord).getFormatKind() : ImmutableLogRecord.FormatKind.DEFAULT).name();
    }

    static boolean isCallerClassSet(LogRecord logRecord) {
        return logRecord instanceof ImmutableLogRecord && ((ImmutableLogRecord)logRecord).isCallerClassSet();
    }

    static boolean isCallerMethodSet(LogRecord logRecord) {
        return logRecord instanceof ImmutableLogRecord && ((ImmutableLogRecord)logRecord).isCallerMethodSet();
    }

    static {
        HashSet s = new HashSet();
        Collections.addAll(s, "engine", GRAAL_COMPILER_LOG_ID);
        INTERNAL_IDS = Collections.unmodifiableSet(s);
    }

    private static class StreamLogHandler
    extends AbstractLogHandler {
        private static final String REDIRECT_FORMAT = "[To redirect Truffle log output to a file use one of the following options:%n* '--log.file=<path>' if the option is passed using a guest language launcher.%n* '-Dpolyglot.log.file=<path>' if the option is passed using the host Java launcher.%n* Configure logging using the polyglot embedding API.]%n";
        private static final String DISABLED_FORMAT = "[engine] Logging to context error output stream is not enabled for the sandbox policy %s. To resolve this issue, install a custom logging handler using Builder.logHandler(Handler) or switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).%n";
        private final OutputStream stream;
        private final OutputStreamWriter writer;
        private final Formatter formatter;
        private final boolean closeStream;
        private final boolean flushOnPublish;
        private final boolean isDefault;
        private final SandboxPolicy disabledForActiveSandboxPolicy;
        private boolean notificationPrinted;

        StreamLogHandler(OutputStream stream, boolean closeStream, boolean flushOnPublish, boolean isDefault, SandboxPolicy disabledForActiveSandboxPolicy) {
            Objects.requireNonNull(stream, "Stream must be non null");
            this.stream = stream;
            this.writer = new OutputStreamWriter(stream);
            this.formatter = FormatterImpl.INSTANCE;
            this.closeStream = closeStream;
            this.flushOnPublish = flushOnPublish;
            this.isDefault = isDefault;
            this.disabledForActiveSandboxPolicy = disabledForActiveSandboxPolicy;
        }

        @Override
        public synchronized void publish(LogRecord logRecord) {
            try {
                String msg;
                this.checkClosed();
                if (this.disabledForActiveSandboxPolicy != null) {
                    assert (this.isDefault) : "Only default handler can be disabled";
                    if (!this.notificationPrinted) {
                        this.writer.write(String.format(DISABLED_FORMAT, new Object[]{this.disabledForActiveSandboxPolicy}));
                        this.writer.flush();
                        this.notificationPrinted = true;
                    }
                    return;
                }
                try {
                    msg = this.formatter.format(logRecord);
                }
                catch (Exception ex) {
                    this.reportHandlerError(5, ex);
                    return;
                }
                try {
                    if (this.isDefault && !this.notificationPrinted) {
                        this.writer.write(String.format(REDIRECT_FORMAT, new Object[0]));
                        this.notificationPrinted = true;
                    }
                    this.writer.write(msg);
                    if (this.flushOnPublish) {
                        this.writer.flush();
                    }
                }
                catch (Exception ex) {
                    this.reportHandlerError(1, ex);
                }
            }
            catch (Throwable t) {
                this.reportHandlerError(0, t);
            }
        }

        @Override
        public synchronized void flush() {
            try {
                this.checkClosed();
                this.writer.flush();
            }
            catch (Throwable t) {
                this.reportHandlerError(2, t);
            }
        }

        @Override
        public synchronized void close() {
            this.closed = true;
            try {
                this.writer.flush();
                if (this.closeStream) {
                    this.writer.close();
                }
            }
            catch (Exception ex) {
                this.reportHandlerError(3, ex);
            }
        }

        private static final class FormatterImpl
        extends Formatter {
            private static final String FORMAT_FULL = "[%1$s] %2$s: %3$s%4$s%n";
            private static final String FORMAT_NO_LEVEL = "[%1$s] %2$s%3$s%n";
            static final Formatter INSTANCE = new FormatterImpl();

            private FormatterImpl() {
            }

            @Override
            public String format(LogRecord record) {
                String loggerName = FormatterImpl.formatLoggerName(record.getLoggerName());
                String message = this.formatMessage(record);
                String stackTrace = "";
                Throwable exception = record.getThrown();
                if (exception != null) {
                    StringWriter str = new StringWriter();
                    try (PrintWriter out = new PrintWriter(str);){
                        out.println();
                        exception.printStackTrace(out);
                    }
                    stackTrace = str.toString();
                }
                ImmutableLogRecord.FormatKind formatKind = ((ImmutableLogRecord)record).getFormatKind();
                return switch (formatKind.ordinal()) {
                    case 2 -> String.format(FORMAT_FULL, loggerName, record.getLevel().getName(), message, stackTrace);
                    case 1 -> String.format(FORMAT_NO_LEVEL, loggerName, message, stackTrace);
                    case 0 -> message;
                    default -> throw new IllegalArgumentException("Unsupported FormatKind " + String.valueOf((Object)formatKind));
                };
            }

            private static String formatLoggerName(String loggerName) {
                String name;
                String id;
                int index = loggerName.indexOf(46);
                if (index < 0) {
                    id = loggerName;
                    name = "";
                } else {
                    id = loggerName.substring(0, index);
                    name = loggerName.substring(index + 1);
                }
                if (name.isEmpty()) {
                    return id;
                }
                StringBuilder sb = new StringBuilder(id);
                sb.append("::");
                sb.append(FormatterImpl.possibleSimpleName(name));
                return sb.toString();
            }

            private static String possibleSimpleName(String loggerName) {
                int index = -1;
                int i = loggerName.indexOf(46);
                while (i >= 0) {
                    if (i + 1 < loggerName.length() && Character.isUpperCase(loggerName.charAt(i + 1))) {
                        index = i + 1;
                        break;
                    }
                    i = loggerName.indexOf(46, i + 1);
                }
                return index < 0 ? loggerName : loggerName.substring(index);
            }
        }
    }

    private static final class JavaLogHandler
    extends AbstractLogHandler {
        private final Handler handler;

        JavaLogHandler(Handler handler) {
            this.handler = Objects.requireNonNull(handler, "Handler must be non null");
        }

        @Override
        public void publish(LogRecord logRecord) {
            try {
                this.checkClosed();
                this.handler.publish(logRecord);
            }
            catch (Throwable t) {
                this.reportHandlerError(0, t);
            }
        }

        @Override
        public void flush() {
            try {
                this.checkClosed();
                this.handler.flush();
            }
            catch (Throwable t) {
                this.reportHandlerError(2, t);
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.handler.close();
        }
    }

    private static final class SharedFileHandler
    extends StreamLogHandler {
        private final Path path;
        private int refCount;

        SharedFileHandler(Path path) throws IOException {
            super(new FileOutputStream(path.toFile(), true), true, true, false, null);
            this.path = path;
        }

        SharedFileHandler retain() {
            assert (Thread.holdsLock(fileHandlers));
            ++this.refCount;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map<Path, SharedFileHandler> map = fileHandlers;
            synchronized (map) {
                --this.refCount;
                if (this.refCount == 0) {
                    fileHandlers.remove(this.path);
                    super.close();
                }
            }
        }
    }

    private static final class ImmutableLogRecord
    extends LogRecord {
        private static final long serialVersionUID = 1L;
        private final FormatKind formatKind;
        private final boolean isCallerClassSet;
        private final boolean isCallerMethodSet;

        ImmutableLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown, FormatKind formatKind) {
            super(level, message);
            super.setLoggerName(loggerName);
            if (className != null) {
                super.setSourceClassName(className);
                this.isCallerClassSet = true;
            } else {
                this.isCallerClassSet = false;
            }
            if (methodName != null) {
                super.setSourceMethodName(methodName);
                this.isCallerMethodSet = true;
            } else {
                this.isCallerMethodSet = false;
            }
            Object[] copy = parameters;
            if (parameters != null && parameters.length > 0) {
                copy = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    copy[i] = ImmutableLogRecord.safeValue(parameters[i]);
                }
            }
            super.setParameters(copy);
            super.setThrown(thrown);
            this.formatKind = formatKind;
        }

        @Override
        public void setLevel(Level level) {
            throw new UnsupportedOperationException("Setting Level is not supported.");
        }

        @Override
        public void setLoggerName(String name) {
            throw new UnsupportedOperationException("Setting Logger Name is not supported.");
        }

        @Override
        public void setMessage(String message) {
            throw new UnsupportedOperationException("Setting Messag is not supported.");
        }

        @Override
        public void setMillis(long millis) {
            throw new UnsupportedOperationException("Setting Millis is not supported.");
        }

        @Override
        public void setParameters(Object[] parameters) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setResourceBundle(ResourceBundle bundle) {
            throw new UnsupportedOperationException("Setting Resource Bundle is not supported.");
        }

        @Override
        public void setResourceBundleName(String name) {
            throw new UnsupportedOperationException("Setting Resource Bundle Name is not supported.");
        }

        @Override
        public void setSequenceNumber(long seq) {
            throw new UnsupportedOperationException("Setting Sequence Number is not supported.");
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            throw new UnsupportedOperationException("Setting Source Method Name is not supported.");
        }

        @Override
        public void setThreadID(int threadID) {
            throw new UnsupportedOperationException("Setting Thread ID is not supported.");
        }

        @Override
        public void setThrown(Throwable thrown) {
            throw new UnsupportedOperationException("Setting Throwable is not supported.");
        }

        FormatKind getFormatKind() {
            return this.formatKind;
        }

        boolean isCallerClassSet() {
            return this.isCallerClassSet;
        }

        public boolean isCallerMethodSet() {
            return this.isCallerMethodSet;
        }

        private static Object safeValue(Object param) {
            if (param == null || EngineAccessor.EngineImpl.isPrimitive(param)) {
                return param;
            }
            try {
                return InteropLibrary.getFactory().getUncached().asString(InteropLibrary.getFactory().getUncached().toDisplayString(param));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        public String toString() {
            return "ImmutableLogRecord [loggerName=" + this.getLoggerName() + ", level=" + String.valueOf(this.getLevel()) + ", sequence=" + this.getSequenceNumber() + ", message()=" + this.getMessage() + ", parameters=" + Arrays.toString(this.getParameters()) + ", instant=" + String.valueOf(this.getInstant()) + "]";
        }

        static enum FormatKind {
            RAW,
            NO_LEVEL,
            DEFAULT;

        }
    }

    private static final class PolyglotErrorManager
    extends ErrorManager {
        private final AtomicBoolean reported = new AtomicBoolean();

        PolyglotErrorManager() {
        }

        @Override
        public void error(String msg, Exception ex, int code) {
            if (this.reported.getAndSet(true)) {
                return;
            }
            StringWriter content = new StringWriter();
            try (PrintWriter out = new PrintWriter(content);){
                String text = "java.util.logging.ErrorManager: " + code;
                if (msg != null) {
                    text = text + ": " + msg;
                }
                out.println(text);
                if (ex != null) {
                    ex.printStackTrace(out);
                }
            }
            PolyglotEngineImpl.logFallback(content.toString());
        }
    }

    static final class EngineLoggerProvider
    implements Function<String, TruffleLogger> {
        private volatile Object loggers;
        private final AbstractPolyglotImpl.LogHandler logHandler;
        private final Map<String, Level> logLevels;

        EngineLoggerProvider(AbstractPolyglotImpl.LogHandler logHandler, Map<String, Level> logLevels) {
            this.logHandler = logHandler;
            this.logLevels = logLevels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TruffleLogger apply(String loggerId) {
            Object loggersCache = this.loggers;
            if (loggersCache == null) {
                EngineLoggerProvider engineLoggerProvider = this;
                synchronized (engineLoggerProvider) {
                    loggersCache = this.loggers;
                    if (loggersCache == null) {
                        LoggerCache spi = LoggerCache.newEngineLoggerCache(this.logHandler, this.logLevels, Collections.singleton(PolyglotLoggers.GRAAL_COMPILER_LOG_ID), Level.INFO);
                        this.loggers = loggersCache = EngineAccessor.LANGUAGE.createEngineLoggers(spi);
                    }
                }
            }
            return EngineAccessor.LANGUAGE.getLogger(loggerId, null, loggersCache);
        }
    }

    private static final class ContextLogHandler
    extends AbstractPolyglotImpl.LogHandler {
        private final WeakReference<PolyglotContextImpl> contextRef;

        ContextLogHandler(PolyglotContextImpl context) {
            this.contextRef = new WeakReference<PolyglotContextImpl>(context);
        }

        @Override
        public void publish(LogRecord record) {
            this.findDelegate().publish(record);
        }

        @Override
        public void flush() {
            this.findDelegate().flush();
        }

        @Override
        public void close() throws SecurityException {
            this.findDelegate().close();
        }

        private AbstractPolyglotImpl.LogHandler findDelegate() {
            PolyglotContextImpl context = (PolyglotContextImpl)this.contextRef.get();
            if (context == null) {
                throw ContextLogHandler.invalidSharing();
            }
            return context.config.logHandler;
        }

        static AssertionError invalidSharing() {
            throw new AssertionError((Object)"Invalid sharing of bound TruffleLogger in AST nodes detected.");
        }
    }

    private static final class PolyglotLogHandler
    extends AbstractPolyglotImpl.LogHandler {
        private static final AbstractPolyglotImpl.LogHandler INSTANCE = new PolyglotLogHandler();
        private final WeakReference<PolyglotEngineImpl> engineRef;

        PolyglotLogHandler() {
            this.engineRef = null;
        }

        PolyglotLogHandler(PolyglotEngineImpl engine) {
            this.engineRef = new WeakReference<PolyglotEngineImpl>(engine);
        }

        @Override
        public void publish(LogRecord record) {
            AbstractPolyglotImpl.LogHandler handler = PolyglotLogHandler.findDelegate();
            if (handler == null) {
                PolyglotEngineImpl engine = this.engineRef != null ? (PolyglotEngineImpl)this.engineRef.get() : null;
                AbstractPolyglotImpl.LogHandler logHandler = handler = engine != null ? engine.logHandler : null;
            }
            if (handler != null) {
                handler.publish(record);
            }
        }

        @Override
        public void flush() {
            AbstractPolyglotImpl.LogHandler handler = PolyglotLogHandler.findDelegate();
            if (handler != null) {
                handler.flush();
            }
        }

        @Override
        public void close() throws SecurityException {
            AbstractPolyglotImpl.LogHandler handler = PolyglotLogHandler.findDelegate();
            if (handler != null) {
                handler.close();
            }
        }

        private static AbstractPolyglotImpl.LogHandler findDelegate() {
            PolyglotContextImpl currentContext = PolyglotFastThreadLocals.getContext(null);
            return currentContext != null ? currentContext.config.logHandler : null;
        }
    }

    private static abstract class AbstractLogHandler
    extends AbstractPolyglotImpl.LogHandler {
        volatile boolean closed;
        private ErrorManager errorManager;

        private AbstractLogHandler() {
        }

        final void checkClosed() {
            if (this.closed) {
                throw new AssertionError((Object)"The log handler is closed.");
            }
        }

        final synchronized void reportHandlerError(int errorKind, Throwable t) {
            Exception exception;
            if (this.errorManager == null) {
                this.errorManager = new PolyglotErrorManager();
            }
            if (t instanceof Exception) {
                exception = (Exception)t;
            } else {
                exception = new RuntimeException(String.format("%s: %s", t.getClass().getName(), t.getMessage()));
                exception.setStackTrace(t.getStackTrace());
            }
            this.errorManager.error("", exception, errorKind);
        }
    }

    static final class LoggerCache {
        static final LoggerCache DEFAULT = new LoggerCache(PolyglotLogHandler.INSTANCE, true, null, Collections.emptySet(), new Level[0]);
        private final AbstractPolyglotImpl.LogHandler handler;
        private final boolean useCurrentContext;
        private final Function<PolyglotImpl.VMObject, Map<String, Level>> ownerLogLevelsProvider;
        private final Set<String> rawLoggerIds;
        private final Set<Level> implicitLevels;
        private volatile WeakReference<PolyglotImpl.VMObject> ownerRef;

        private LoggerCache(AbstractPolyglotImpl.LogHandler handler, boolean useCurrentContext, Function<PolyglotImpl.VMObject, Map<String, Level>> ownerLogLevelsProvider, Set<String> rawLoggerIds, Level ... implicitLevels) {
            Objects.requireNonNull(handler);
            this.handler = handler;
            this.useCurrentContext = useCurrentContext;
            this.ownerLogLevelsProvider = ownerLogLevelsProvider;
            this.rawLoggerIds = rawLoggerIds;
            if (implicitLevels.length == 0) {
                this.implicitLevels = Collections.emptySet();
            } else {
                this.implicitLevels = new HashSet<Level>();
                Collections.addAll(this.implicitLevels, implicitLevels);
            }
        }

        boolean isContextBoundLogger() {
            return !this.useCurrentContext;
        }

        void setOwner(PolyglotImpl.VMObject owner) {
            if (this.ownerRef != null) {
                throw new IllegalStateException("owner can only be set once");
            }
            this.ownerRef = new WeakReference<PolyglotImpl.VMObject>(owner);
        }

        static LoggerCache newEngineLoggerCache(PolyglotEngineImpl engine) {
            Objects.requireNonNull(engine);
            LoggerCache cache = new LoggerCache(new PolyglotLogHandler(engine), true, owner -> ((PolyglotEngineImpl)owner).logLevels, Collections.emptySet(), new Level[0]);
            cache.setOwner(engine);
            return cache;
        }

        static LoggerCache newEngineLoggerCache(AbstractPolyglotImpl.LogHandler handler, Map<String, Level> logLevels, Set<String> rawLoggerIds, Level ... implicitLevels) {
            return new LoggerCache(handler, false, owner -> logLevels, rawLoggerIds, implicitLevels);
        }

        static LoggerCache newContextLoggerCache(PolyglotContextImpl context) {
            Objects.requireNonNull(context);
            LoggerCache cache = new LoggerCache(new ContextLogHandler(context), false, owner -> ((PolyglotContextImpl)owner).config.logLevels, Collections.emptySet(), new Level[0]);
            cache.setOwner(context);
            return cache;
        }

        public PolyglotImpl.VMObject getOwner() {
            return this.ownerRef == null ? null : (PolyglotImpl.VMObject)this.ownerRef.get();
        }

        public AbstractPolyglotImpl.LogHandler getLogHandler() {
            return this.handler;
        }

        public Map<String, Level> getLogLevels() {
            PolyglotContextImpl context;
            if (this.useCurrentContext && (context = PolyglotFastThreadLocals.getContext(null)) != null) {
                return context.config.logLevels;
            }
            if (this.ownerLogLevelsProvider != null) {
                PolyglotImpl.VMObject owner;
                if (this.ownerRef != null) {
                    owner = (PolyglotImpl.VMObject)this.ownerRef.get();
                    if (owner == null) {
                        throw ContextLogHandler.invalidSharing();
                    }
                } else {
                    owner = null;
                }
                return this.ownerLogLevelsProvider.apply(owner);
            }
            return null;
        }

        public LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown) {
            ImmutableLogRecord.FormatKind formaterKind = this.rawLoggerIds.contains(loggerName) ? ImmutableLogRecord.FormatKind.RAW : (this.implicitLevels.contains(level) ? ImmutableLogRecord.FormatKind.NO_LEVEL : ImmutableLogRecord.FormatKind.DEFAULT);
            return new ImmutableLogRecord(level, loggerName, message, className, methodName, parameters, thrown, formaterKind);
        }
    }
}

