/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import com.oracle.truffle.polyglot.WeakAssumedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Pair;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptor;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLanguageInstance
implements PolyglotImpl.VMObject {
    final PolyglotLanguage language;
    final TruffleLanguage<Object> spi;
    @CompilerDirectives.CompilationFinal
    PolyglotSharingLayer sharing;
    private final Map<Class<?>, PolyglotValueDispatch> valueCache;
    private final Map<Class<?>, CallTarget> callTargetCache;
    final Map<Object, Object> hostToGuestCodeCache = new ConcurrentHashMap<Object, Object>();
    final Map<Class<?>, Object> staticObjectClassLoaders = new ConcurrentHashMap();
    final ConcurrentHashMap<Pair<Class<?>, Class<?>>, Object> generatorCache = new ConcurrentHashMap();
    final WeakAssumedValue<PolyglotLanguageContext> singleLanguageContext = new WeakAssumedValue("single language context");
    List<PolyglotLocals.LanguageContextLocal<?>> contextLocals;
    List<PolyglotLocals.LanguageContextThreadLocal<?>> contextThreadLocals;
    PolyglotLocals.LocalLocation[] contextLocalLocations;
    PolyglotLocals.LocalLocation[] contextThreadLocalLocations;
    @CompilerDirectives.CompilationFinal
    private volatile Object guestToHostCodeCache;
    private static final AtomicReferenceFieldUpdater<PolyglotLanguageInstance, Object> GUEST_TO_HOST_CODE_CACHE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PolyglotLanguageInstance.class, Object.class, "guestToHostCodeCache");

    PolyglotLanguageInstance(PolyglotLanguage language, PolyglotSharingLayer layer) {
        this.language = language;
        this.sharing = layer;
        this.valueCache = new ConcurrentHashMap();
        this.callTargetCache = new ConcurrentHashMap();
        try {
            this.spi = language.cache.loadLanguage();
            EngineAccessor.LANGUAGE.initializeLanguage(this.spi, language.info, language, language.isHost() ? null : this);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", language.cache.getId(), language.cache.getClassName()), e);
        }
        PolyglotValueDispatch.createDefaultValues(this.getImpl(), this, this.valueCache);
    }

    CallTarget lookupCallTarget(Class<? extends RootNode> rootNodeClass) {
        return this.callTargetCache.get(rootNodeClass);
    }

    CallTarget installCallTarget(RootNode rootNode) {
        return this.callTargetCache.computeIfAbsent(rootNode.getClass(), r -> rootNode.getCallTarget());
    }

    OptionValuesImpl parseSourceOptions(PolyglotSourceCache.ParseOrigin origin, Source source, String componentOnly) {
        Map<String, OptionValuesImpl> options;
        OptionValuesImpl languageOptions;
        Map<String, String> rawOptions = EngineAccessor.SOURCE.getSourceOptions(source);
        if (rawOptions.isEmpty()) {
            return this.language.getEmptySourceOptionsInternal();
        }
        PolyglotEngineImpl engine = this.sharing.engine;
        boolean allowExperimental = true;
        SandboxPolicy sandboxPolicy = SandboxPolicy.TRUSTED;
        if (origin == PolyglotSourceCache.ParseOrigin.EMBEDDING) {
            allowExperimental = engine.allowExperimentalOptions;
            sandboxPolicy = engine.sandboxPolicy;
        }
        if ((languageOptions = (options = PolyglotSourceCache.parseSourceOptions(this.getEngine(), rawOptions, componentOnly, sandboxPolicy, allowExperimental)).get(componentOnly != null ? componentOnly : source.getLanguage())) == null) {
            return this.language.getEmptySourceOptionsInternal();
        }
        ArrayList<OptionDescriptor> deprecated = null;
        for (OptionValuesImpl resolvedOptions : options.values()) {
            Collection<OptionDescriptor> descriptors = resolvedOptions.getUsedDeprecatedDescriptors();
            if (descriptors.isEmpty()) continue;
            if (deprecated == null) {
                deprecated = new ArrayList<OptionDescriptor>();
            }
            deprecated.addAll(descriptors);
        }
        if (deprecated != null) {
            engine.printDeprecatedOptionsWarning(deprecated);
        }
        return languageOptions;
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.language.engine;
    }

    @Override
    public AbstractPolyglotImpl.APIAccess getAPIAccess() {
        return this.language.engine.apiAccess;
    }

    @Override
    public PolyglotImpl getImpl() {
        return this.language.engine.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotValueDispatch lookupValueCache(PolyglotContextImpl context, Object guestValue) {
        PolyglotValueDispatch cache = this.valueCache.get(guestValue.getClass());
        if (cache == null) {
            Object prev = this.language.engine.enterIfNeeded(context, true);
            try {
                cache = this.lookupValueCacheImpl(guestValue);
            }
            finally {
                this.language.engine.leaveIfNeeded(prev, context);
            }
        }
        assert (Objects.equals(cache.languageInstance.sharing, this.sharing)) : PolyglotSharingLayer.invalidSharingError(null, cache.languageInstance.sharing, this.sharing);
        return cache;
    }

    private synchronized PolyglotValueDispatch lookupValueCacheImpl(final Object guestValue) {
        PolyglotValueDispatch cache = this.valueCache.computeIfAbsent(guestValue.getClass(), new Function<Class<?>, PolyglotValueDispatch>(){
            final /* synthetic */ PolyglotLanguageInstance this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public PolyglotValueDispatch apply(Class<?> t) {
                return PolyglotValueDispatch.createInteropValue(this.this$0, (TruffleObject)guestValue, guestValue.getClass());
            }
        });
        return cache;
    }

    Object getGuestToHostCodeCache() {
        return this.guestToHostCodeCache;
    }

    Object installGuestToHostCodeCache(Object newCache) {
        if (GUEST_TO_HOST_CODE_CACHE_UPDATER.compareAndSet(this, null, newCache)) {
            return newCache;
        }
        return this.guestToHostCodeCache;
    }

    public String toString() {
        return "PolyglotLanguageInstance[" + String.valueOf(this.spi) + "]";
    }
}

