/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import java.util.Iterator;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleOptionDescriptors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GeneratedBy;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionCategory;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptor;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionStability;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(value=PolyglotEngineOptions.class)
final class PolyglotEngineOptionsOptionDescriptors
implements TruffleOptionDescriptors {
    PolyglotEngineOptionsOptionDescriptors() {
    }

    @Override
    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "engine.AssertProbes": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.AssertProbes, "engine.AssertProbes").deprecated(false).help("Asserts that enter and return are always called in pairs on ProbeNode, verifies correct behavior of wrapper nodes. Java asserts need to be turned on for this option to have an effect. (default: false)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CloseOnGCFailureAction": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.CloseOnGCFailureAction, "engine.CloseOnGCFailureAction").deprecated(false).help(String.format("Specifies the action to take when closing a garbage collected engine or context fails.%nThe accepted values are:%n    Ignore:    Do not print this warning.%n    Print:     Print this warning (default value).%n    Throw:     Throw an exception instead of printing this warning.", new Object[0])).usageSyntax("Ignore|Print|Throw").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.DisableCodeSharing": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.DisableCodeSharing, "engine.DisableCodeSharing").deprecated(false).help("Option to force disable code sharing for this engine, even if the context was created with an explicit engine. This option is intended for testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.ForceCodeSharing": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.ForceCodeSharing, "engine.ForceCodeSharing").deprecated(false).help("Option to force enable code sharing for this engine, even if the context was created with a bound engine. This option is intended for testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InstrumentExceptionsAreThrown": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.InstrumentExceptionsAreThrown, "engine.InstrumentExceptionsAreThrown").deprecated(false).help("Propagates exceptions thrown by instruments. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PreinitializeContexts": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.PreinitializeContexts, "engine.PreinitializeContexts").deprecated(true).deprecationMessage("").help("Preinitialize language contexts for given languages.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PrintInternalStackTrace": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.PrintInternalStackTrace, "engine.PrintInternalStackTrace").deprecated(false).help("Printed PolyglotException stacktrace unconditionally contains the stacktrace of the original internal exception as well as the stacktrace of the creation of the PolyglotException instance.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.RelaxStaticObjectSafetyChecks": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.RelaxStaticObjectSafetyChecks, "engine.RelaxStaticObjectSafetyChecks").deprecated(false).help("On property accesses, the Static Object Model does not perform shape checks and uses unsafe casts").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SafepointALot": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.SafepointALot, "engine.SafepointALot").deprecated(false).help("Repeadly submits thread local actions and collects statistics about safepoint intervals in the process. Prints event and interval statistics when the context is closed for each thread. This option significantly slows down execution and is therefore intended for testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.ShowInternalStackFrames": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.ShowInternalStackFrames, "engine.ShowInternalStackFrames").deprecated(false).help("Show internal frames specific to the language implementation in stack traces.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SourceCacheStatisticDetails": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.SourceCacheStatisticDetails, "engine.SourceCacheStatisticDetails").deprecated(false).help("Print source cache statistics for an engine when the engine is closed. With the details enabled, statistics for all individual sources are printed.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.SourceCacheStatistics": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.SourceCacheStatistics, "engine.SourceCacheStatistics").deprecated(false).help("Print source cache statistics for an engine when the engine is closed.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.SpecializationStatistics": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.SpecializationStatistics, "engine.SpecializationStatistics").deprecated(false).help("Enables specialization statistics for nodes generated with Truffle DSL and prints the result on exit. In order for this flag to be functional -Atruffle.dsl.GenerateSpecializationStatistics=true needs to be set at build time. Enabling this flag and the compiler option has major implications on the performance and footprint of the interpreter. Do not use in production environments.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.StaticObjectStorageStrategy": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.StaticObjectStorageStrategy, "engine.StaticObjectStorageStrategy").deprecated(false).help("Set the storage strategy used by the Static Object Model. Accepted values are: ['default', 'array-based', 'field-based']").usageSyntax("default|array-based|field-based").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SynchronousThreadLocalActionMaxWait": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.SynchronousThreadLocalActionMaxWait, "engine.SynchronousThreadLocalActionMaxWait").deprecated(false).help("How long to wait for other threads to reach a synchronous ThreadLocalAction before cancelling it, in seconds. 0 means no limit.").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SynchronousThreadLocalActionPrintStackTraces": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.SynchronousThreadLocalActionPrintStackTraces, "engine.SynchronousThreadLocalActionPrintStackTraces").deprecated(false).help("Print thread stacktraces when a synchronous ThreadLocalAction is waiting for more than SynchronousThreadLocalActionMaxWait seconds.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceCodeSharing": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceCodeSharing, "engine.TraceCodeSharing").deprecated(false).help("Enables printing of code sharing related information to the logger. This option is intended to support debugging language implementations.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceMissingSafepointPollInterval": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceMissingSafepointPollInterval, "engine.TraceMissingSafepointPollInterval").deprecated(false).help("Show Java stacktraces for missing polls longer than the supplied number of milliseconds. Implies SafepointALot.").usageSyntax("[0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceSourceCache": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceSourceCache, "engine.TraceSourceCache").deprecated(false).help("Print information for source cache misses/evictions/failures.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.TraceSourceCacheDetails": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceSourceCacheDetails, "engine.TraceSourceCacheDetails").deprecated(false).help("Print information for all source cache events including hits and uncached misses.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.TraceStackTraceInterval": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceStackTraceInterval, "engine.TraceStackTraceInterval").deprecated(false).help("Prints the stack trace for all threads for a time interval. By default 0, which disables the output.").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceThreadLocalActions": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceThreadLocalActions, "engine.TraceThreadLocalActions").deprecated(false).help("Traces thread local events and when they are processed on the individual threads. Prints messages with the [engine] [tl] prefix.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TriggerUncaughtExceptionHandlerForCancel": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.TriggerUncaughtExceptionHandlerForCancel, "engine.TriggerUncaughtExceptionHandlerForCancel").deprecated(false).help("Propagates cancel execution exception into UncaughtExceptionHandler. For testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.UseConservativeContextReferences": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.UseConservativeContextReferences, "engine.UseConservativeContextReferences").deprecated(true).deprecationMessage("Has no longer any effect. Scheduled for removal in in 22.1.").help("Enables conservative context references. This allows invalid sharing between contexts. For testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.UsePreInitializedContext": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.UsePreInitializedContext, "engine.UsePreInitializedContext").deprecated(false).help("Use pre-initialized context when it's available (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.WarnInterpreterOnly": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.WarnInterpreterOnly, "engine.WarnInterpreterOnly").deprecated(false).help("Print warning when the engine is using a default Truffle runtime (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "engine.WarnOptionDeprecation": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.WarnOptionDeprecation, "engine.WarnOptionDeprecation").deprecated(false).help("Print warning when a deprecated option is used (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "engine.WarnVirtualThreadSupport": {
                return OptionDescriptor.newBuilder(PolyglotEngineOptions.WarnVirtualThreadSupport, "engine.WarnVirtualThreadSupport").deprecated(false).help("Warn that the virtual thread support is experimental (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
        }
        return null;
    }

    @Override
    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert (this.get(optionName) != null) : "Unknown option " + optionName;
        switch (optionName) {
            case "engine.AssertProbes": {
                return SandboxPolicy.UNTRUSTED;
            }
            case "engine.CloseOnGCFailureAction": {
                return SandboxPolicy.UNTRUSTED;
            }
            case "engine.WarnInterpreterOnly": {
                return SandboxPolicy.UNTRUSTED;
            }
            case "engine.WarnOptionDeprecation": {
                return SandboxPolicy.UNTRUSTED;
            }
            case "engine.WarnVirtualThreadSupport": {
                return SandboxPolicy.UNTRUSTED;
            }
        }
        return SandboxPolicy.TRUSTED;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return List.of(OptionDescriptor.newBuilder(PolyglotEngineOptions.AssertProbes, "engine.AssertProbes").deprecated(false).help("Asserts that enter and return are always called in pairs on ProbeNode, verifies correct behavior of wrapper nodes. Java asserts need to be turned on for this option to have an effect. (default: false)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.CloseOnGCFailureAction, "engine.CloseOnGCFailureAction").deprecated(false).help(String.format("Specifies the action to take when closing a garbage collected engine or context fails.%nThe accepted values are:%n    Ignore:    Do not print this warning.%n    Print:     Print this warning (default value).%n    Throw:     Throw an exception instead of printing this warning.", new Object[0])).usageSyntax("Ignore|Print|Throw").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.DisableCodeSharing, "engine.DisableCodeSharing").deprecated(false).help("Option to force disable code sharing for this engine, even if the context was created with an explicit engine. This option is intended for testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.ForceCodeSharing, "engine.ForceCodeSharing").deprecated(false).help("Option to force enable code sharing for this engine, even if the context was created with a bound engine. This option is intended for testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.InstrumentExceptionsAreThrown, "engine.InstrumentExceptionsAreThrown").deprecated(false).help("Propagates exceptions thrown by instruments. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.PreinitializeContexts, "engine.PreinitializeContexts").deprecated(true).deprecationMessage("").help("Preinitialize language contexts for given languages.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.PrintInternalStackTrace, "engine.PrintInternalStackTrace").deprecated(false).help("Printed PolyglotException stacktrace unconditionally contains the stacktrace of the original internal exception as well as the stacktrace of the creation of the PolyglotException instance.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.RelaxStaticObjectSafetyChecks, "engine.RelaxStaticObjectSafetyChecks").deprecated(false).help("On property accesses, the Static Object Model does not perform shape checks and uses unsafe casts").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.SafepointALot, "engine.SafepointALot").deprecated(false).help("Repeadly submits thread local actions and collects statistics about safepoint intervals in the process. Prints event and interval statistics when the context is closed for each thread. This option significantly slows down execution and is therefore intended for testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.ShowInternalStackFrames, "engine.ShowInternalStackFrames").deprecated(false).help("Show internal frames specific to the language implementation in stack traces.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.SourceCacheStatisticDetails, "engine.SourceCacheStatisticDetails").deprecated(false).help("Print source cache statistics for an engine when the engine is closed. With the details enabled, statistics for all individual sources are printed.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.SourceCacheStatistics, "engine.SourceCacheStatistics").deprecated(false).help("Print source cache statistics for an engine when the engine is closed.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.SpecializationStatistics, "engine.SpecializationStatistics").deprecated(false).help("Enables specialization statistics for nodes generated with Truffle DSL and prints the result on exit. In order for this flag to be functional -Atruffle.dsl.GenerateSpecializationStatistics=true needs to be set at build time. Enabling this flag and the compiler option has major implications on the performance and footprint of the interpreter. Do not use in production environments.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.StaticObjectStorageStrategy, "engine.StaticObjectStorageStrategy").deprecated(false).help("Set the storage strategy used by the Static Object Model. Accepted values are: ['default', 'array-based', 'field-based']").usageSyntax("default|array-based|field-based").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.SynchronousThreadLocalActionMaxWait, "engine.SynchronousThreadLocalActionMaxWait").deprecated(false).help("How long to wait for other threads to reach a synchronous ThreadLocalAction before cancelling it, in seconds. 0 means no limit.").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.SynchronousThreadLocalActionPrintStackTraces, "engine.SynchronousThreadLocalActionPrintStackTraces").deprecated(false).help("Print thread stacktraces when a synchronous ThreadLocalAction is waiting for more than SynchronousThreadLocalActionMaxWait seconds.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceCodeSharing, "engine.TraceCodeSharing").deprecated(false).help("Enables printing of code sharing related information to the logger. This option is intended to support debugging language implementations.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceMissingSafepointPollInterval, "engine.TraceMissingSafepointPollInterval").deprecated(false).help("Show Java stacktraces for missing polls longer than the supplied number of milliseconds. Implies SafepointALot.").usageSyntax("[0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceSourceCache, "engine.TraceSourceCache").deprecated(false).help("Print information for source cache misses/evictions/failures.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceSourceCacheDetails, "engine.TraceSourceCacheDetails").deprecated(false).help("Print information for all source cache events including hits and uncached misses.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceStackTraceInterval, "engine.TraceStackTraceInterval").deprecated(false).help("Prints the stack trace for all threads for a time interval. By default 0, which disables the output.").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.TraceThreadLocalActions, "engine.TraceThreadLocalActions").deprecated(false).help("Traces thread local events and when they are processed on the individual threads. Prints messages with the [engine] [tl] prefix.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.TriggerUncaughtExceptionHandlerForCancel, "engine.TriggerUncaughtExceptionHandlerForCancel").deprecated(false).help("Propagates cancel execution exception into UncaughtExceptionHandler. For testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.UseConservativeContextReferences, "engine.UseConservativeContextReferences").deprecated(true).deprecationMessage("Has no longer any effect. Scheduled for removal in in 22.1.").help("Enables conservative context references. This allows invalid sharing between contexts. For testing purposes only.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.UsePreInitializedContext, "engine.UsePreInitializedContext").deprecated(false).help("Use pre-initialized context when it's available (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.WarnInterpreterOnly, "engine.WarnInterpreterOnly").deprecated(false).help("Print warning when the engine is using a default Truffle runtime (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.WarnOptionDeprecation, "engine.WarnOptionDeprecation").deprecated(false).help("Print warning when a deprecated option is used (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotEngineOptions.WarnVirtualThreadSupport, "engine.WarnVirtualThreadSupport").deprecated(false).help("Warn that the virtual thread support is experimental (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build()).iterator();
    }
}

