/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.InternalResourceCache;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.module.Modules;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.InternalResource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.Accessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.asm.ClassWriter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.asm.FieldVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.asm.MethodVisitor;

final class JDKSupport {
    private static final Method ADD_ENABLE_NATIVE_ACCESS;
    private static final Method ADD_ENABLE_NATIVE_ACCESS_TO_ALL_UNNAMED;
    private static final Accessor.ModulesAccessor MODULES_ACCESSOR;

    private static Accessor.ModulesAccessor initializeModuleAccessor() {
        String attachLibPath = System.getProperty("truffle.attach.library");
        if (attachLibPath == null) {
            try {
                Path truffleAttachRoot = InternalResourceCache.installRuntimeResource(new LibTruffleAttachResource());
                Path libAttach = truffleAttachRoot.resolve("bin").resolve(System.mapLibraryName("truffleattach"));
                attachLibPath = libAttach.toString();
            }
            catch (IOException ioe) {
                JDKSupport.performTruffleAttachLoadFailureAction("The Truffle API JAR is missing the 'truffleattach' resource, likely due to issues when Truffle was repackaged into a fat JAR.", ioe);
                return null;
            }
        }
        try {
            try {
                System.load(attachLibPath);
            }
            catch (UnsatisfiedLinkError failedToLoad) {
                JDKSupport.performTruffleAttachLoadFailureAction("Unable to load the TruffleAttach library.", failedToLoad);
                return null;
            }
            catch (IllegalCallerException illegalCaller) {
                String vmOption = "--enable-native-access=" + (JDKSupport.class.getModule().isNamed() ? "org.cyclops.integratedscripting.vendors.org.graalvm.truffle" : "ALL-UNNAMED");
                JDKSupport.performTruffleAttachLoadFailureAction(String.format("Failed to load the TruffleAttach library. The Truffle module does not have native access enabled. To resolve this, pass the following VM option: %s.", vmOption), illegalCaller);
                return null;
            }
            Accessor.ModulesAccessor accessor = Accessor.ModulesAccessor.class.getModule().isNamed() ? new DirectImpl(Accessor.ModulesAccessor.class) : new IsolatedImpl(Accessor.ModulesAccessor.class);
            Module javaBase = ModuleLayer.boot().findModule("java.base").orElseThrow();
            JDKSupport.addExports0(javaBase, "jdk.internal.module", accessor.getTargetModule());
            JDKSupport.addExports0(javaBase, "jdk.internal.access", accessor.getTargetModule());
            return accessor;
        }
        catch (ReflectiveOperationException re) {
            throw new InternalError(re);
        }
    }

    private static native void addExports0(Module var0, String var1, Module var2);

    private static void performTruffleAttachLoadFailureAction(String reason, Throwable t) {
        String action;
        switch (action = System.getProperty("polyglotimpl.AttachLibraryFailureAction", "warn")) {
            case "ignore": {
                break;
            }
            case "warn": {
                PolyglotEngineImpl.logFallback(JDKSupport.formatErrorMessage(reason));
                break;
            }
            case "diagnose": {
                StringWriter message = new StringWriter();
                try (PrintWriter err = new PrintWriter(message);){
                    err.println(JDKSupport.formatErrorMessage(reason));
                    t.printStackTrace(err);
                }
                PolyglotEngineImpl.logFallback(message.toString());
                break;
            }
            case "throw": {
                throw new InternalError(JDKSupport.formatErrorMessage(reason), t);
            }
            default: {
                throw new IllegalArgumentException("Invalid polyglotimpl.AttachLibraryFailureAction system property value. Supported values are ignore, warn, diagnose, throw");
            }
        }
    }

    private static String formatErrorMessage(String reason) {
        return String.format("[engine] WARNING: %s\nAs a result, the optimized Truffle runtime is unavailable, and Truffle cannot provide native access to languages and tools.\nTo customize the behavior of this warning, use the 'polyglotimpl.AttachLibraryFailureAction' system property.\nAllowed values are:\n  - ignore:    Do not print this warning.\n  - warn:      Print this warning (default value).\n  - diagnose:  Print this warning along with the exception cause.\n  - throw:     Throw an exception instead of printing this warning.\n", reason);
    }

    private JDKSupport() {
    }

    static void exportTransitivelyTo(Module clientModule) {
        if (JDKSupport.isExportedTo(clientModule)) {
            return;
        }
        Module truffleModule = Truffle.class.getModule();
        JDKSupport.forEach(clientModule, EnumSet.of(Edge.READS, Edge.USES), m -> m != truffleModule && m.canRead(truffleModule), JDKSupport::exportFromTo);
    }

    static void enableNativeAccess(Module clientModule) {
        JDKSupport.forEach(clientModule, EnumSet.of(Edge.READS), m -> true, m -> {
            Accessor.ModulesAccessor accessor = JDKSupport.getModulesAccessor();
            if (accessor != null) {
                if (m.isNamed()) {
                    JDKSupport.getModulesAccessor().addEnableNativeAccess((Module)m);
                } else {
                    JDKSupport.getModulesAccessor().addEnableNativeAccessToAllUnnamed();
                }
            }
        });
    }

    static Accessor.ModulesAccessor getModulesAccessor() {
        return MODULES_ACCESSOR;
    }

    private static void forEach(Module rootModule, Set<Edge> edges, Predicate<? super Module> filter, Consumer<? super Module> action) {
        ModuleLayer layer = rootModule.getLayer();
        HashSet<Module> targetModules = new HashSet<Module>();
        ArrayDeque<Module> todo = new ArrayDeque<Module>();
        HashSet<Module> visited = new HashSet<Module>();
        todo.add(rootModule);
        HashMap serviceDictionary = null;
        while (!todo.isEmpty()) {
            Set<String> usedServices;
            Module module = (Module)todo.removeFirst();
            if (!visited.add(module) || !Objects.equals(module.getLayer(), layer) || !filter.test(module)) continue;
            targetModules.add(module);
            ModuleDescriptor descriptor = module.getDescriptor();
            if (descriptor == null || descriptor.isAutomatic()) continue;
            if (edges.contains((Object)Edge.READS)) {
                for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                    Module requiredModule = JDKSupport.findModule(layer, requires);
                    if (requiredModule == null) continue;
                    todo.add(requiredModule);
                }
            }
            if (!edges.contains((Object)Edge.USES) || (usedServices = descriptor.uses()).isEmpty()) continue;
            if (serviceDictionary == null) {
                serviceDictionary = new HashMap();
                for (Module m : layer.modules()) {
                    if (!filter.test(m)) continue;
                    for (ModuleDescriptor.Provides provides : m.getDescriptor().provides()) {
                        serviceDictionary.computeIfAbsent(provides.service(), k -> new HashSet()).add(m);
                    }
                }
            }
            for (String service : usedServices) {
                todo.addAll(serviceDictionary.getOrDefault(service, Set.of()));
            }
        }
        targetModules.forEach(action);
    }

    private static Module findModule(ModuleLayer layer, ModuleDescriptor.Requires requires) {
        Optional<Module> moduleOrNull = layer.findModule(requires.name());
        if (moduleOrNull.isPresent()) {
            return moduleOrNull.get();
        }
        if (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC)) {
            return null;
        }
        throw new AssertionError((Object)String.format("A non-optional module %s not found in the module layer %s.", requires.name(), layer));
    }

    private static boolean isExportedTo(Module clientModule) {
        Module truffleModule = Truffle.class.getModule();
        for (String pack : truffleModule.getPackages()) {
            if (truffleModule.isExported(pack, clientModule)) continue;
            return false;
        }
        return true;
    }

    private static void exportFromTo(Module clientModule) {
        Module truffleModule = Truffle.class.getModule();
        if (truffleModule != clientModule) {
            Set<String> packages = truffleModule.getPackages();
            for (String pkg : packages) {
                boolean exported = truffleModule.isExported(pkg, clientModule);
                if (exported) continue;
                truffleModule.addExports(pkg, clientModule);
            }
        }
    }

    static {
        if (Runtime.version().feature() >= 21) {
            try {
                Class<?> langAccessClass = Class.forName("jdk.internal.access.JavaLangAccess");
                ADD_ENABLE_NATIVE_ACCESS = langAccessClass.getDeclaredMethod("addEnableNativeAccess", Module.class);
                ADD_ENABLE_NATIVE_ACCESS_TO_ALL_UNNAMED = langAccessClass.getDeclaredMethod("addEnableNativeAccessToAllUnnamed", new Class[0]);
            }
            catch (ReflectiveOperationException re) {
                throw new InternalError(re);
            }
        } else {
            ADD_ENABLE_NATIVE_ACCESS = null;
            ADD_ENABLE_NATIVE_ACCESS_TO_ALL_UNNAMED = null;
        }
        MODULES_ACCESSOR = JDKSupport.initializeModuleAccessor();
    }

    @InternalResource.Id(value="libtruffleattach", componentId="engine", optional=true)
    static final class LibTruffleAttachResource
    implements InternalResource {
        static final String ID = "libtruffleattach";

        LibTruffleAttachResource() {
        }

        @Override
        public void unpackFiles(InternalResource.Env env, Path targetDirectory) throws IOException {
            if (env.inNativeImageBuild() && !env.inContextPreinitialization()) {
                return;
            }
            Path base = LibTruffleAttachResource.basePath(env);
            env.unpackResourceFiles(base.resolve("files"), targetDirectory, base);
        }

        @Override
        public String versionHash(InternalResource.Env env) throws IOException {
            Path base = LibTruffleAttachResource.basePath(env);
            return env.readResourceLines(base.resolve("sha256")).get(0);
        }

        private static Path basePath(InternalResource.Env env) {
            return Path.of("META-INF", "resources", "engine", ID, env.getOS().toString(), env.getCPUArchitecture().toString());
        }
    }

    private static final class DirectImpl
    extends Accessor.ModulesAccessor {
        private final Class<?> baseClass;

        DirectImpl(Class<?> baseClass) {
            if (!baseClass.getModule().isNamed()) {
                throw new IllegalStateException("");
            }
            this.baseClass = baseClass;
        }

        @Override
        public void addExports(Module base, String p, Module target) {
            Modules.addExports(base, p, target);
        }

        @Override
        public void addExportsToAllUnnamed(Module base, String p) {
            Modules.addExportsToAllUnnamed(base, p);
        }

        @Override
        public void addOpens(Module base, String p, Module target) {
            Modules.addOpens(base, p, target);
        }

        @Override
        public void addOpensToAllUnnamed(Module base, String p) {
            Modules.addOpensToAllUnnamed(base, p);
        }

        @Override
        public void addEnableNativeAccess(Module module) {
            if (ADD_ENABLE_NATIVE_ACCESS != null) {
                try {
                    ADD_ENABLE_NATIVE_ACCESS.invoke((Object)SharedSecrets.getJavaLangAccess(), module);
                }
                catch (ReflectiveOperationException re) {
                    throw new InternalError(re);
                }
            }
        }

        @Override
        public void addEnableNativeAccessToAllUnnamed() {
            if (ADD_ENABLE_NATIVE_ACCESS_TO_ALL_UNNAMED != null) {
                try {
                    ADD_ENABLE_NATIVE_ACCESS_TO_ALL_UNNAMED.invoke((Object)SharedSecrets.getJavaLangAccess(), new Object[0]);
                }
                catch (ReflectiveOperationException re) {
                    throw new InternalError(re);
                }
            }
        }

        @Override
        public Module getTargetModule() {
            return this.baseClass.getModule();
        }

        @Override
        public Accessor.JavaLangSupport getJavaLangSupport() {
            return JavaLangSupportImpl.INSTANCE;
        }

        private static final class JavaLangSupportImpl
        extends Accessor.JavaLangSupport {
            private static final JavaLangAccess JAVA_LANG_ACCESS = SharedSecrets.getJavaLangAccess();
            static final Accessor.JavaLangSupport INSTANCE = new JavaLangSupportImpl();

            private JavaLangSupportImpl() {
            }

            @Override
            public Thread currentCarrierThread() {
                return JAVA_LANG_ACCESS.currentCarrierThread();
            }
        }
    }

    private static final class IsolatedImpl
    extends Accessor.ModulesAccessor {
        private final MethodHandle addExports;
        private final MethodHandle addExportsToAllUnnamed;
        private final MethodHandle addOpens;
        private final MethodHandle addOpensToAllUnnamed;
        private final MethodHandle addEnableNativeAccess;
        private final MethodHandle addEnableNativeAccessToAllUnnamed;
        private final MethodHandle currentCarrierThread;
        private final Module targetModule;

        IsolatedImpl(Class<?> baseClass) throws ReflectiveOperationException {
            String moduleName = "org.cyclops.integratedscripting.vendors.org.graalvm.truffle.generated";
            String targetPackage = baseClass.getPackageName() + ".generated";
            String className = targetPackage + ".GeneratedModules";
            final String binaryClassName = className.replace('.', '/');
            ClassWriter cw = new ClassWriter(0);
            cw.visit(52, 33, binaryClassName, null, "java/lang/Object", null);
            FieldVisitor fv = cw.visitField(26, "javaLangAccess", "Ljdk/internal/access/JavaLangAccess;", null, null);
            fv.visitEnd();
            MethodVisitor clinit = cw.visitMethod(8, "<clinit>", "()V", null, null);
            clinit.visitCode();
            clinit.visitMethodInsn(184, "jdk/internal/access/SharedSecrets", "getJavaLangAccess", "()Ljdk/internal/access/JavaLangAccess;", false);
            clinit.visitFieldInsn(179, binaryClassName, "javaLangAccess", "Ljdk/internal/access/JavaLangAccess;");
            clinit.visitInsn(177);
            clinit.visitMaxs(1, 0);
            clinit.visitEnd();
            MethodVisitor constructor = cw.visitMethod(1, "<init>", "()V", null, null);
            constructor.visitCode();
            constructor.visitVarInsn(25, 0);
            constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            constructor.visitInsn(177);
            constructor.visitMaxs(1, 1);
            constructor.visitEnd();
            MethodVisitor mv1 = cw.visitMethod(9, "addExports", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", null, null);
            mv1.visitCode();
            mv1.visitVarInsn(25, 0);
            mv1.visitVarInsn(25, 1);
            mv1.visitVarInsn(25, 2);
            mv1.visitMethodInsn(184, "jdk/internal/module/Modules", "addExports", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", false);
            mv1.visitInsn(177);
            mv1.visitMaxs(3, 3);
            mv1.visitEnd();
            MethodVisitor mv2 = cw.visitMethod(9, "addExportsToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", null, null);
            mv2.visitCode();
            mv2.visitVarInsn(25, 0);
            mv2.visitVarInsn(25, 1);
            mv2.visitMethodInsn(184, "jdk/internal/module/Modules", "addExportsToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", false);
            mv2.visitInsn(177);
            mv2.visitMaxs(2, 2);
            mv2.visitEnd();
            MethodVisitor mv3 = cw.visitMethod(9, "addOpens", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", null, null);
            mv3.visitCode();
            mv3.visitVarInsn(25, 0);
            mv3.visitVarInsn(25, 1);
            mv3.visitVarInsn(25, 2);
            mv3.visitMethodInsn(184, "jdk/internal/module/Modules", "addOpens", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", false);
            mv3.visitInsn(177);
            mv3.visitMaxs(3, 3);
            mv3.visitEnd();
            MethodVisitor mv4 = cw.visitMethod(9, "addOpensToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", null, null);
            mv4.visitCode();
            mv4.visitVarInsn(25, 0);
            mv4.visitVarInsn(25, 1);
            mv4.visitMethodInsn(184, "jdk/internal/module/Modules", "addOpensToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", false);
            mv4.visitInsn(177);
            mv4.visitMaxs(2, 2);
            mv4.visitEnd();
            MethodVisitor mv5 = cw.visitMethod(9, "addEnableNativeAccess", "(Ljava/lang/Module;)V", null, null);
            mv5.visitCode();
            if (ADD_ENABLE_NATIVE_ACCESS != null) {
                mv5.visitMethodInsn(184, "jdk/internal/access/SharedSecrets", "getJavaLangAccess", "()Ljdk/internal/access/JavaLangAccess;", false);
                mv5.visitVarInsn(25, 0);
                mv5.visitMethodInsn(185, "jdk/internal/access/JavaLangAccess", "addEnableNativeAccess", "(Ljava/lang/Module;)Ljava/lang/Module;", true);
            }
            mv5.visitInsn(177);
            mv5.visitMaxs(2, 2);
            mv5.visitEnd();
            MethodVisitor mv6 = cw.visitMethod(9, "addEnableNativeAccessToAllUnnamed", "()V", null, null);
            mv6.visitCode();
            if (ADD_ENABLE_NATIVE_ACCESS_TO_ALL_UNNAMED != null) {
                mv6.visitMethodInsn(184, "jdk/internal/access/SharedSecrets", "getJavaLangAccess", "()Ljdk/internal/access/JavaLangAccess;", false);
                mv6.visitMethodInsn(185, "jdk/internal/access/JavaLangAccess", "addEnableNativeAccessToAllUnnamed", "()V", true);
            }
            mv6.visitInsn(177);
            mv6.visitMaxs(1, 1);
            mv6.visitEnd();
            MethodVisitor mv7 = cw.visitMethod(9, "currentCarrierThread", "()Ljava/lang/Thread;", null, null);
            mv7.visitCode();
            mv7.visitFieldInsn(178, binaryClassName, "javaLangAccess", "Ljdk/internal/access/JavaLangAccess;");
            mv7.visitMethodInsn(185, "jdk/internal/access/JavaLangAccess", "currentCarrierThread", "()Ljava/lang/Thread;", true);
            mv7.visitInsn(176);
            mv7.visitMaxs(1, 0);
            mv7.visitEnd();
            cw.visitEnd();
            final byte[] classBytes = cw.toByteArray();
            final ModuleDescriptor descriptor = ModuleDescriptor.newModule("org.cyclops.integratedscripting.vendors.org.graalvm.truffle.generated").exports(targetPackage).build();
            ModuleFinder finder = new ModuleFinder(){
                final /* synthetic */ IsolatedImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Optional<ModuleReference> find(String name) {
                    if (name.equals("org.cyclops.integratedscripting.vendors.org.graalvm.truffle.generated")) {
                        return Optional.of(new ModuleReference(this, descriptor, null){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                super(descriptor, location);
                            }

                            @Override
                            public ModuleReader open() throws IOException {
                                return new ModuleReader(){
                                    final /* synthetic */ IsolatedImpl.1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public Optional<ByteBuffer> read(String name) throws IOException {
                                        if (name.equals(binaryClassName + ".class")) {
                                            return Optional.of(ByteBuffer.wrap(classBytes));
                                        }
                                        return Optional.empty();
                                    }

                                    @Override
                                    public void close() throws IOException {
                                    }

                                    @Override
                                    public Optional<URI> find(String name) throws IOException {
                                        return Optional.empty();
                                    }

                                    @Override
                                    public Stream<String> list() throws IOException {
                                        return Stream.empty();
                                    }
                                };
                            }
                        });
                    }
                    return Optional.empty();
                }

                @Override
                public Set<ModuleReference> findAll() {
                    return Collections.singleton(this.find("org.cyclops.integratedscripting.vendors.org.graalvm.truffle.generated").get());
                }
            };
            ModuleLayer bootLayer = ModuleLayer.boot();
            Configuration cf = bootLayer.configuration().resolve(finder, ModuleFinder.of(new Path[0]), Collections.singleton("org.cyclops.integratedscripting.vendors.org.graalvm.truffle.generated"));
            ModuleLayer layer = bootLayer.defineModulesWithOneLoader(cf, ClassLoader.getSystemClassLoader());
            Class<?> generatedClass = layer.findLoader("org.cyclops.integratedscripting.vendors.org.graalvm.truffle.generated").loadClass(className);
            this.targetModule = generatedClass.getModule();
            MethodHandles.Lookup l = MethodHandles.lookup();
            l.accessClass(generatedClass);
            this.addExports = l.findStatic(generatedClass, "addExports", MethodType.methodType(Void.TYPE, Module.class, String.class, Module.class));
            this.addExportsToAllUnnamed = l.findStatic(generatedClass, "addExportsToAllUnnamed", MethodType.methodType(Void.TYPE, Module.class, String.class));
            this.addOpens = l.findStatic(generatedClass, "addOpens", MethodType.methodType(Void.TYPE, Module.class, String.class, Module.class));
            this.addOpensToAllUnnamed = l.findStatic(generatedClass, "addOpensToAllUnnamed", MethodType.methodType(Void.TYPE, Module.class, String.class));
            this.addEnableNativeAccess = l.findStatic(generatedClass, "addEnableNativeAccess", MethodType.methodType(Void.TYPE, Module.class));
            this.addEnableNativeAccessToAllUnnamed = l.findStatic(generatedClass, "addEnableNativeAccessToAllUnnamed", MethodType.methodType(Void.TYPE));
            this.currentCarrierThread = l.findStatic(generatedClass, "currentCarrierThread", MethodType.methodType(Thread.class));
        }

        @Override
        public Module getTargetModule() {
            return this.targetModule;
        }

        @Override
        public void addExports(Module base, String p, Module target) {
            try {
                this.addExports.invokeExact(base, p, target);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        public void addExportsToAllUnnamed(Module base, String p) {
            try {
                this.addExportsToAllUnnamed.invokeExact(base, p);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        public void addOpens(Module base, String p, Module target) {
            try {
                this.addOpens.invokeExact(base, p, target);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        public void addOpensToAllUnnamed(Module base, String p) {
            try {
                this.addOpensToAllUnnamed.invokeExact(base, p);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        public void addEnableNativeAccess(Module module) {
            try {
                this.addEnableNativeAccess.invokeExact(module);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        public void addEnableNativeAccessToAllUnnamed() {
            try {
                this.addEnableNativeAccessToAllUnnamed.invokeExact();
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        public Accessor.JavaLangSupport getJavaLangSupport() {
            return JavaLangSupportImpl.INSTANCE;
        }

        private static final class JavaLangSupportImpl
        extends Accessor.JavaLangSupport {
            private static final MethodHandle CURRENT_CARRIER_THREAD;
            private static final Accessor.JavaLangSupport INSTANCE;

            private JavaLangSupportImpl() {
                this.currentCarrierThread();
            }

            @Override
            public Thread currentCarrierThread() {
                try {
                    return CURRENT_CARRIER_THREAD.invokeExact();
                }
                catch (Throwable e) {
                    throw new InternalError(e);
                }
            }

            static {
                if (MODULES_ACCESSOR == null) {
                    throw new IllegalStateException("JavaLangAccessorImpl initialized before JDKSupport.");
                }
                if (!(MODULES_ACCESSOR instanceof IsolatedImpl)) {
                    throw new IllegalStateException("JDKSupport.MODULES_ACCESSOR initialized with wrong type " + String.valueOf(MODULES_ACCESSOR.getClass()));
                }
                CURRENT_CARRIER_THREAD = ((IsolatedImpl)JDKSupport.MODULES_ACCESSOR).currentCarrierThread;
                INSTANCE = new JavaLangSupportImpl();
            }
        }
    }

    private static enum Edge {
        READS,
        USES;

    }
}

