PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 === 0) {
    if (player.level.dimension === 'minecraft:the_end') {
      if (!player.persistentData.hasEnteredEnd) {
        player.persistentData.hasEnteredEnd = true;
        player.tell(Text.translate('kubejs.story.the_end.intro'));
        server.scheduleInTicks(80, _ => {
          player.tell(Text.translate('kubejs.story.the_end.my_question'));
        });
        server.scheduleInTicks(150, _ => {
          player.tell(Text.translate('kubejs.story.the_end.world_voice_response'));
        });
        server.scheduleInTicks(180, _ => {
          player.tell(Text.translate('kubejs.story.the_end.my_reaction'));
        });
        server.scheduleInTicks(210, _ => {
          player.tell(Text.translate('kubejs.story.the_end.final_thought'));
        });
      }
    }
  }
});
