PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(10, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:supermassive_slime') {
    if (player.persistentData.seenSuperSlime) return;
    player.persistentData.seenSuperSlime = true;
    player.tell(Text.translate('kubejs.story.supermassive_slime.intro'));
    server.scheduleInTicks(20, _ => player.tell(Text.translate('kubejs.story.supermassive_slime.challenge')));
    server.scheduleInTicks(60, _ => player.tell(Text.translate('kubejs.story.supermassive_slime.reward')));
  }
});
