PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(20, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:orc') {
    if (player.persistentData.seenOrc) return;
    player.persistentData.seenOrc = true;
    player.tell(Text.translate('kubejs.story.orc.reaction'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.orc.request')));
  }
});
