PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(15, true);
  if (rayTraceResult && rayTraceResult.block && rayTraceResult.block.id === 'tensura:spider_egg') {
    if (player.persistentData.seenSpiderEgg) return;
    player.persistentData.seenSpiderEgg = true;
    player.tell(Text.translate('kubejs.story.spider.egg_warning'));
  }
  const rayTraceResultWeb = player.rayTrace(70, true);
  if (rayTraceResultWeb && rayTraceResultWeb.block && rayTraceResultWeb.block.id === 'tensura:web_block') {
    if (player.persistentData.seenWebBlock) return;
    player.persistentData.seenWebBlock = true;
    player.tell(Text.translate('kubejs.story.spider.web_warning'));
  }
});
