PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const lookingAt = player.rayTrace(15, false);
  if (lookingAt && lookingAt.entity && lookingAt.entity.type === 'tensura:shizu') {
    if (player.persistentData.seenShizu) return;
    player.persistentData.seenShizu = true;
    player.tell(Text.translate('kubejs.story.shizu.intro'));
    server.scheduleInTicks(40, _ => {
      player.tell(Text.translate('kubejs.story.shizu.warning'));
    });
    server.scheduleInTicks(80, _ => {
      player.tell(Text.translate('kubejs.story.shizu.my_reaction'));
    });
    server.scheduleInTicks(100, _ => {
      player.tell(Text.translate('kubejs.story.shizu.advice'));
    });
    server.scheduleInTicks(140, _ => {
      player.tell(Text.translate('kubejs.story.shizu.narrator_hint'));
    });
  }
});
