PlayerEvents.tick(event => {
  const player = event.player;
  if (!player || !player.isPlayer()) return;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  if (!player.persistentData.lastDimension) {
    player.persistentData.lastDimension = `${level.dimension}`;
  }
  const currentDimension = `${level.dimension}`;
  const lastDimension = player.persistentData.lastDimension;
  if (currentDimension !== lastDimension) {
    player.persistentData.lastDimension = currentDimension;
    if (currentDimension === 'tensura:hell' && player.persistentData.killedInOverworld) {
      if (!player.persistentData.hellIntroTriggered) {
        player.tell(Text.translate('kubejs.story.hell_dimension.intro'));
        player.persistentData.hellIntroTriggered = true;
      }
    }
  }
});

EntityEvents.hurt(event => {
  const player = event.source.entity;
  if (!player || !player.isPlayer() || `${player.level.dimension}` !== 'minecraft:overworld') return;
  if (!player.persistentData.killedInOverworld) {
    player.persistentData.killedInOverworld = true;
  }
});
