PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(20, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:orc_lord') {
    if (player.persistentData.seenOrcLord) return;
    player.persistentData.seenOrcLord = true;
    player.tell(Text.translate('kubejs.story.orc_lord.intro'));
    server.scheduleInTicks(20, _ => player.tell(Text.translate('kubejs.story.orc_lord.choice')));
    server.scheduleInTicks(60, _ => player.tell(Text.translate('kubejs.story.orc_lord.my_question')));
    server.scheduleInTicks(100, _ => player.tell(Text.translate('kubejs.story.orc_lord.growth')));
    server.scheduleInTicks(140, _ => player.tell(Text.translate('kubejs.story.orc_lord.evolution')));
  }
});
